/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.patternMapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.solrmarc.index.extractor.AbstractValueExtractor;
import org.solrmarc.index.extractor.AbstractValueExtractorFactory;
import org.solrmarc.index.extractor.impl.patternMapping.PatternMapping;

public class PatternMappingValueExtractorFactory
extends AbstractValueExtractorFactory {
    private static final Map<String, List<PatternMapping>> PATTERN_MAPPINGS = new HashMap<String, List<PatternMapping>>();

    public static List<PatternMapping> getPatternMappingsForName(String name) {
        List<PatternMapping> mappings = PATTERN_MAPPINGS.get(name);
        if (mappings == null) {
            mappings = new ArrayList<PatternMapping>();
            PATTERN_MAPPINGS.put(name, mappings);
        }
        return mappings;
    }

    @Override
    public boolean canHandle(String solrFieldName, String mappingConfiguration) {
        boolean isPatternMap = solrFieldName.startsWith("pattern_map.");
        int index = solrFieldName.indexOf(".pattern_");
        if (!isPatternMap) {
            return false;
        }
        if (index == -1 || !Character.isDigit(solrFieldName.charAt(index + ".pattern_".length()))) {
            throw new IllegalArgumentException("A pattern impl name should end with '.pattern_[index]', where '[index]' is a number: " + solrFieldName + " = " + mappingConfiguration);
        }
        return true;
    }

    @Override
    public AbstractValueExtractor<?> createExtractor(String solrFieldName, String[] parts) {
        return null;
    }
}

