/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.patternMapping;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.solrmarc.index.indexer.IndexerSpecException;

public class PatternMapping {
    private final Pattern inputPattern;
    private final String outputPattern;
    private final int orderIndex;

    public PatternMapping(String inputPatternStr, String outputPattern, int orderIndex) {
        this.inputPattern = Pattern.compile(inputPatternStr);
        this.outputPattern = outputPattern;
        this.orderIndex = orderIndex;
        int index = outputPattern.indexOf(36);
        int groupMax = 0;
        Matcher inputMatcher = this.inputPattern.matcher("");
        inputMatcher.replaceAll(outputPattern);
        int groupCnt = inputMatcher.groupCount();
        while (index >= 0) {
            String num = outputPattern.substring(index + 1, index + 2);
            int groupNum = Integer.parseInt(num);
            if (groupNum > groupMax) {
                groupMax = groupNum;
            }
            index = outputPattern.indexOf(36, index + 1 + num.length());
        }
        if (groupCnt < groupMax) {
            throw new IndexerSpecException("Unknown group $" + groupMax + " in pattern map replacement string : " + outputPattern + "\n");
        }
    }

    public static String mapSingleValue(List<PatternMapping> patternMappings, String value) {
        for (PatternMapping patternMapping : patternMappings) {
            Matcher matcher = patternMapping.inputPattern.matcher(value);
            if (!matcher.find()) continue;
            value = patternMapping.map(matcher);
        }
        return value;
    }

    public static String filterSingleValue(List<PatternMapping> patternMappings, String value) {
        for (PatternMapping patternMapping : patternMappings) {
            Matcher matcher = patternMapping.inputPattern.matcher(value);
            if (!matcher.find()) continue;
            value = patternMapping.filter(matcher);
        }
        return value;
    }

    public static void mapValues(List<PatternMapping> patternMappings, String value, Collection<String> values) {
        for (PatternMapping patternMapping : patternMappings) {
            String mappedValue;
            Matcher matcher = patternMapping.inputPattern.matcher(value);
            if (!matcher.find() || (mappedValue = patternMapping.map(matcher)).length() == 0) continue;
            values.add(mappedValue);
        }
    }

    public static void filterValues(List<PatternMapping> patternMappings, String value, Collection<String> values) {
        for (PatternMapping patternMapping : patternMappings) {
            String mappedValue;
            Matcher matcher = patternMapping.inputPattern.matcher(value);
            if (!matcher.find() || (mappedValue = patternMapping.filter(matcher)).length() == 0) continue;
            values.add(mappedValue);
        }
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public String map(Matcher inputMatcher) {
        String result = this.outputPattern;
        if (this.outputPattern.contains("$")) {
            for (int group = inputMatcher.groupCount(); group > 0; --group) {
                String pattern = Matcher.quoteReplacement("$" + group);
                String replacement = inputMatcher.group(group);
                replacement = Matcher.quoteReplacement(replacement);
                result = result.replaceAll(pattern, replacement);
            }
        }
        return result;
    }

    public String filter(Matcher inputMatcher) {
        return inputMatcher.replaceAll(this.outputPattern);
    }
}

