/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.log4j.Logger;
import org.solrmarc.driver.Boot;
import org.solrmarc.index.utils.ClasspathUtils;

public class JavaValueExtractorUtils {
    private static final Logger logger = Logger.getLogger(JavaValueExtractorUtils.class);
    private static final Map<File, String> packageNamesForFile = new LinkedHashMap<File, String>();
    private static final Pattern packageFinder = Pattern.compile("package[ \t]+(([a-z_][a-z0-9_]*[.])*[a-z_][a-z0-9_]*)[ \t]*;.*");
    private Map<String, List<File>> sourceFilesMap = new LinkedHashMap<String, List<File>>();
    private String[] dirsContainingJavaSource;

    public JavaValueExtractorUtils(String[] dirsContainingJavaSource) {
        this.dirsContainingJavaSource = dirsContainingJavaSource;
    }

    public boolean compileSources(boolean recompileAll) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        boolean compiledSome = false;
        if (compiler == null) {
            logger.warn((Object)("Java environment at JAVA_HOME = " + System.getProperty("java.home") + " does not have a Java compiler."));
            logger.warn((Object)"Any custom mixin routines will not be compiled and will not be available.");
            return compiledSome;
        }
        for (int i = this.dirsContainingJavaSource.length - 1; i >= 0; --i) {
            String homeDirectory = this.dirsContainingJavaSource[i];
            String srcDirectory = homeDirectory + File.separator + "index_java" + File.separator + "src";
            String binDirectory = homeDirectory + File.separator + "index_java" + File.separator + "bin";
            this.createBinDirectory(binDirectory);
            List<File> sourceFiles = this.getChangedSourceFiles(srcDirectory, binDirectory, recompileAll);
            if (sourceFiles.isEmpty()) continue;
            compiledSome = true;
            List<File> classpath = ClasspathUtils.instance().getClassPath();
            for (int j = this.dirsContainingJavaSource.length - 1; j > i; --j) {
                try {
                    String otherBinDirectory = this.dirsContainingJavaSource[j] + File.separator + "index_java" + File.separator + "bin";
                    URL url = new File(otherBinDirectory).toURI().toURL();
                    classpath.add(new File(url.getFile()));
                    continue;
                }
                catch (MalformedURLException otherBinDirectory) {
                    // empty catch block
                }
            }
            try {
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, Charset.forName("UTF-8"));
                fileManager.setLocation(StandardLocation.SOURCE_PATH, Collections.singleton(new File(srcDirectory)));
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(new File(binDirectory)));
                fileManager.setLocation(StandardLocation.CLASS_PATH, classpath);
                DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
                Iterable<? extends JavaFileObject> units = fileManager.getJavaFileObjectsFromFiles(sourceFiles);
                List<String> options = Collections.singletonList("-g");
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticCollector, options, null, units);
                logger.trace((Object)("Compile java files:\n" + sourceFiles.toString().replaceAll(",", ",\n")));
                if (!task.call().booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
                        buffer.append(diagnostic.toString()).append('\n');
                    }
                    throw new RuntimeException('\n' + buffer.toString() + "\nCompiling java sources failed!");
                }
                logger.trace((Object)"... done");
                fileManager.close();
                continue;
            }
            catch (IOException ioe) {
                throw new RuntimeException('\n' + ioe.getMessage() + "\nCompiling java sources failed!");
            }
        }
        return true;
    }

    private void createBinDirectory(String binDirectoryStr) {
        File binDirectory = new File(binDirectoryStr);
        if (!binDirectory.exists() && !binDirectory.mkdirs()) {
            throw new RuntimeException("Couldn't create binary directory: " + binDirectory.getAbsolutePath());
        }
    }

    public Class<?>[] getClasses() {
        Set<String> classNames = this.getClassNames();
        ArrayList classList = new ArrayList(classNames.size());
        ClassLoader classLoader = this.getClassLoader();
        for (String className : classNames) {
            try {
                classList.add(classLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("Unable to load custom mixin class: " + className));
            }
        }
        Class[] classes = classList.toArray(new Class[classList.size()]);
        return classes;
    }

    private ClassLoader getClassLoader() {
        ArrayList<URL> listURL = new ArrayList<URL>();
        for (String homeDirectory : this.dirsContainingJavaSource) {
            String binDirectory = homeDirectory + File.separator + "index_java" + File.separator + "bin";
            try {
                URL url = new File(binDirectory).toURI().toURL();
                listURL.add(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        URL[] URLs = listURL.toArray(new URL[0]);
        return new URLClassLoader(URLs, (ClassLoader)Boot.getURLClassLoaderToUse());
    }

    private Set<String> getClassNames() {
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        for (String homeDirectory : this.dirsContainingJavaSource) {
            String srcDirectory = homeDirectory + File.separator + "index_java" + File.separator + "src";
            String binDirectory = homeDirectory + File.separator + "index_java" + File.separator + "bin";
            List<File> sourceFiles = this.getSourceFiles(srcDirectory);
            for (File sourceFile : sourceFiles) {
                classNames.add(this.getClassNameForSourceFile(sourceFile, srcDirectory, binDirectory));
            }
        }
        return classNames;
    }

    private String getClassNameForSourceFile(File sourceFile, String srcDirectory, String binDirectory) {
        int pathOffset;
        String sourcePath = sourceFile.getPath();
        String classPath = sourcePath.substring(pathOffset = srcDirectory.length() + (srcDirectory.endsWith("/") ? 0 : 1), sourcePath.length() - 5);
        String className = classPath.replace(File.separator, ".");
        if (!className.contains(".")) {
            String packageName = this.getPackageName(sourceFile);
            className = packageName + className;
        }
        return className;
    }

    private String getClassFileForSourceFile(File sourceFile, String srcDirectory, String binDirectory) {
        String classPath;
        String sourcePath = sourceFile.getPath();
        int pathOffset = srcDirectory.length() + (srcDirectory.endsWith("/") ? 0 : 1);
        String classFile = classPath = sourcePath.substring(pathOffset, sourcePath.length() - 5);
        if (!classPath.contains(File.separator)) {
            String packageName = this.getPackageName(sourceFile);
            classFile = packageName.replace(".", File.separator) + classFile;
        }
        return binDirectory + File.separator + classFile + ".class";
    }

    private String getPackageName(File sourceFile) {
        String packageName = "";
        if (!packageNamesForFile.containsKey(sourceFile)) {
            try {
                String line;
                BufferedReader srcReader = new BufferedReader(new FileReader(sourceFile));
                while ((line = srcReader.readLine()) != null) {
                    Matcher matcher = packageFinder.matcher(line);
                    if (!matcher.matches()) continue;
                    packageName = matcher.group(1) + ".";
                    break;
                }
                srcReader.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            packageNamesForFile.put(sourceFile, packageName);
        } else {
            packageName = packageNamesForFile.get(sourceFile);
        }
        return packageName;
    }

    private Date getCreateDateOfSolrMarcJar() {
        Manifest manifest;
        Class<JavaValueExtractorUtils> clazz = JavaValueExtractorUtils.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
        }
        catch (IOException e) {
            return null;
        }
        Attributes attr = manifest.getMainAttributes();
        String value = attr.getValue("Built-Date");
        if (value == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        try {
            Date dateBuilt = format.parse(value);
            return dateBuilt;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private List<File> getChangedSourceFiles(String srcDirectory, String binDirectory, boolean recompileAll) {
        List<File> sourceFiles = this.getSourceFiles(srcDirectory);
        ArrayList<File> changedSourceFiles = new ArrayList<File>();
        Date dateJarBuilt = this.getCreateDateOfSolrMarcJar();
        for (File sourceFile : sourceFiles) {
            if (!recompileAll && !this.hasChanged(sourceFile, srcDirectory, binDirectory, dateJarBuilt)) continue;
            changedSourceFiles.add(sourceFile);
        }
        return changedSourceFiles;
    }

    private List<File> getSourceFiles(String srcDirectory) {
        if (this.sourceFilesMap.containsKey(srcDirectory)) {
            List<File> sourceFiles = this.sourceFilesMap.get(srcDirectory);
            return sourceFiles;
        }
        ArrayList<File> sourceFiles = new ArrayList<File>();
        LinkedList<File> directories = new LinkedList<File>();
        directories.add(new File(srcDirectory));
        while (!directories.isEmpty()) {
            File directory = (File)directories.poll();
            for (File file : this.listFiles(directory)) {
                if (file.isDirectory()) {
                    directories.add(file);
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".java")) continue;
                sourceFiles.add(file);
            }
        }
        this.sourceFilesMap.put(srcDirectory, sourceFiles);
        return sourceFiles;
    }

    private File[] listFiles(File directory) {
        if (directory == null) {
            return new File[0];
        }
        File[] fileList = directory.listFiles();
        return fileList != null ? fileList : new File[]{};
    }

    private boolean hasChanged(File sourceFile, String srcDirectory, String binDirectory, Date dateJarBuilt) {
        Date sourceDate;
        String sourcePath = sourceFile.getPath();
        String targetPath = this.getClassFileForSourceFile(new File(sourcePath), srcDirectory, binDirectory);
        File targetFile = new File(targetPath);
        if (!targetFile.exists()) {
            return true;
        }
        Date targetDate = new Date(targetFile.lastModified());
        if (targetDate.before(sourceDate = new Date(sourceFile.lastModified()))) {
            return true;
        }
        return dateJarBuilt != null && targetDate.before(dateJarBuilt);
    }
}

