/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.fullrecord;

import org.solrmarc.index.extractor.AbstractValueExtractor;
import org.solrmarc.index.extractor.AbstractValueExtractorFactory;
import org.solrmarc.index.extractor.impl.fullrecord.FullRecordAsFieldsValuesExtractor;
import org.solrmarc.index.extractor.impl.fullrecord.FullRecordAsJSON2ValueExtractor;
import org.solrmarc.index.extractor.impl.fullrecord.FullRecordAsJSONValueExtractor;
import org.solrmarc.index.extractor.impl.fullrecord.FullRecordAsMarcValueExtractor;
import org.solrmarc.index.extractor.impl.fullrecord.FullRecordAsTextValueExtractor;
import org.solrmarc.index.extractor.impl.fullrecord.FullRecordAsXMLValueExtractor;

public class FullRecordValueExtractorFactory
extends AbstractValueExtractorFactory {
    @Override
    public boolean canHandle(String solrFieldName, String mappingConfiguration) {
        String mapping = mappingConfiguration.toLowerCase().trim();
        return mapping.startsWith("FullRecordAs".toLowerCase()) || mapping.startsWith("xml") || mapping.startsWith("raw") || mapping.startsWith("json") || mapping.startsWith("json2") || mapping.startsWith("text");
    }

    public AbstractValueExtractor<?> createExtractor(String solrFieldName, String mapping) {
        String mappingLC = mapping.toLowerCase();
        if (mappingLC.startsWith("raw") || mappingLC.startsWith("FullRecordAsMARC".toLowerCase())) {
            return new FullRecordAsMarcValueExtractor();
        }
        if (mappingLC.startsWith("xml") || mappingLC.startsWith("FullRecordAsXML".toLowerCase())) {
            return new FullRecordAsXMLValueExtractor();
        }
        if (mappingLC.startsWith("json2") || mappingLC.startsWith("FullRecordAsJSON2".toLowerCase())) {
            return new FullRecordAsJSON2ValueExtractor();
        }
        if (mappingLC.startsWith("json") || mappingLC.startsWith("FullRecordAsJSON".toLowerCase())) {
            return new FullRecordAsJSONValueExtractor();
        }
        if (mappingLC.startsWith("text") || mappingLC.startsWith("FullRecordAsText".toLowerCase())) {
            return new FullRecordAsTextValueExtractor();
        }
        if (mappingLC.startsWith("FullRecordAsFields".toLowerCase())) {
            return new FullRecordAsFieldsValuesExtractor(".*");
        }
        throw new IllegalArgumentException("Unknown impl configuration: " + solrFieldName + " = " + mapping);
    }

    @Override
    public AbstractValueExtractor<?> createExtractor(String solrFieldName, String[] parts) {
        return this.createExtractor(solrFieldName, parts[0]);
    }
}

