/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.fullrecord;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.marc4j.MarcWriter;
import org.marc4j.MarcXmlWriter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.solrmarc.index.extractor.impl.fullrecord.AbstractFullRecordValueExtractor;

public class FullRecordAsXMLValueExtractor
extends AbstractFullRecordValueExtractor {
    private static final String spaces = "                                          ";
    protected static final String CONTROL_FIELD = "controlfield";
    protected static final String DATA_FIELD = "datafield";
    protected static final String SUBFIELD = "subfield";
    protected static final String COLLECTION = "collection";
    protected static final String RECORD = "record";
    protected static final String LEADER = "leader";

    @Override
    public String extract(Record record) throws UnsupportedEncodingException {
        return FullRecordAsXMLValueExtractor.toXMLString(record, false);
    }

    public static String toXMLString(Record record, boolean indent) {
        StringBuilder sb = new StringBuilder();
        FullRecordAsXMLValueExtractor.startDocument(sb);
        FullRecordAsXMLValueExtractor.startElement(sb, COLLECTION, indent, 0, new Tag("xmlns", "http://www.loc.gov/MARC21/slim"));
        FullRecordAsXMLValueExtractor.startElement(sb, RECORD, indent, 2, new Tag[0]);
        if (indent) {
            FullRecordAsXMLValueExtractor.indent(sb, 2);
        }
        FullRecordAsXMLValueExtractor.startElement(sb, LEADER, indent, 4, new Tag[0]);
        sb.append(record.getLeader().toString());
        FullRecordAsXMLValueExtractor.endElement(sb, LEADER);
        for (ControlField field : record.getControlFields()) {
            FullRecordAsXMLValueExtractor.startElement(sb, CONTROL_FIELD, indent, 4, new Tag("tag", field.getTag()));
            sb.append(FullRecordAsXMLValueExtractor.getDataElement(field.getData()));
            FullRecordAsXMLValueExtractor.endElement(sb, CONTROL_FIELD);
        }
        for (ControlField field : record.getDataFields()) {
            FullRecordAsXMLValueExtractor.startElement(sb, DATA_FIELD, indent, 4, new Tag("tag", field.getTag()), new Tag("ind1", String.valueOf(field.getIndicator1())), new Tag("ind2", String.valueOf(field.getIndicator2())));
            for (Subfield subfield : field.getSubfields()) {
                FullRecordAsXMLValueExtractor.startElement(sb, SUBFIELD, indent, 6, new Tag("code", Character.toString(subfield.getCode())));
                sb.append(FullRecordAsXMLValueExtractor.getDataElement(subfield.getData()));
                FullRecordAsXMLValueExtractor.endElement(sb, SUBFIELD);
            }
            FullRecordAsXMLValueExtractor.endElement(sb, DATA_FIELD, indent, 4);
        }
        FullRecordAsXMLValueExtractor.endElement(sb, RECORD);
        FullRecordAsXMLValueExtractor.endElement(sb, COLLECTION);
        return sb.toString();
    }

    private static void indent(StringBuilder sb, int i) {
    }

    private static void startDocument(StringBuilder sb) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    private static String getDataElement(String data) {
        return data.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static void startElement(StringBuilder sb, String qname, boolean indent, int indentCnt, Tag ... tags) {
        if (indent) {
            sb.append("\n").append(spaces.substring(0, indentCnt));
        }
        sb.append("<").append(qname);
        for (Tag tag : tags) {
            sb.append(" ").append(tag.name).append("=\"").append(tag.value).append("\"");
        }
        sb.append(">");
    }

    private static void endElement(StringBuilder sb, String qname, boolean indent, int indentCnt) {
        sb.append("</").append(qname).append(">");
    }

    private static void endElement(StringBuilder sb, String qname) {
        FullRecordAsXMLValueExtractor.endElement(sb, qname, false, 0);
    }

    @Override
    protected MarcWriter makeNewWriter(ByteArrayOutputStream outputStream) {
        return new MarcXmlWriter((OutputStream)outputStream, "UTF8");
    }

    protected MarcWriter makeNewWriter(StreamResult streamResult) {
        return new MarcXmlWriter((Result)streamResult);
    }

    private static class Tag {
        final String name;
        final String value;

        public Tag(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

