/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.direct;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.marc4j.marc.Record;
import org.solrmarc.index.extractor.AbstractMultiValueExtractor;
import org.solrmarc.index.extractor.ExternalMethod;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.extractor.impl.direct.FieldMatch;
import org.solrmarc.index.extractor.impl.direct.ModifyableMultiValueExtractor;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.specification.RegexSpecification;
import org.solrmarc.index.specification.conditional.Condition;

public class RegexMultiValueExtractor
extends AbstractMultiValueExtractor
implements ExternalMethod,
ModifyableMultiValueExtractor {
    private RegexSpecification fieldRegex;

    public RegexMultiValueExtractor(String regex) {
        this.fieldRegex = new RegexSpecification(regex);
    }

    public RegexMultiValueExtractor(String regex, Condition cond) {
        this.fieldRegex = new RegexSpecification(regex, cond);
    }

    public RegexMultiValueExtractor(RegexSpecification fieldRegex) {
        this.fieldRegex = fieldRegex;
    }

    private RegexMultiValueExtractor(RegexMultiValueExtractor toClone) {
        this.fieldRegex = toClone.fieldRegex;
    }

    public final Collection<FieldMatch> getFieldMatches(Record record) {
        List<FieldMatch> result = this.fieldRegex.getFieldMatches(record);
        return result;
    }

    @Override
    public void extract(Collection<String> result, Record record) throws Exception {
        for (FieldMatch fm : this.getFieldMatches(record)) {
            fm.addValuesTo(result);
        }
    }

    @Override
    public void addCleanVal(FieldFormatter.eCleanVal cleanVal) {
        this.fieldRegex.addCleanVal(cleanVal);
    }

    @Override
    public void setCleanVal(EnumSet<FieldFormatter.eCleanVal> of) {
        this.fieldRegex.setCleanVal(of);
    }

    @Override
    public void setJoinVal(FieldFormatter.eJoinVal joinVal) {
        this.fieldRegex.setJoinVal(joinVal);
    }

    @Override
    public void setSeparator(String separator) {
        this.fieldRegex.setSeparator(separator);
    }

    @Override
    public void setFormatPatterns(String[] mapParts) {
        this.fieldRegex.setFormatPatterns(mapParts);
    }

    @Override
    public boolean isThreadSafe() {
        return this.fieldRegex.isThreadSafe();
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new RegexMultiValueExtractor(this);
    }

    @Override
    public void setSubstring(String startStr, String endStr) {
        int start;
        try {
            start = Integer.parseInt(startStr);
        }
        catch (NumberFormatException nfe) {
            throw new IndexerSpecException("Illegal substring specification: " + startStr);
        }
        if (endStr.equals("toEnd")) {
            this.fieldRegex.setSubstring(start, -1);
        } else {
            int end;
            try {
                end = Integer.parseInt(endStr);
            }
            catch (NumberFormatException nfe) {
                throw new IndexerSpecException("Illegal substring specification: " + endStr);
            }
            if (start < 0 || end < 0 || start > end) {
                throw new IndexerSpecException("Illegal substring interval: " + start + " " + end);
            }
            this.fieldRegex.setSubstring(start, end);
        }
    }

    @Override
    public void addMap(AbstractMultiValueMapping valueMapping) {
    }
}

