/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.direct;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.marc4j.marc.Record;
import org.solrmarc.index.extractor.AbstractMultiValueExtractor;
import org.solrmarc.index.extractor.ExternalMethod;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.extractor.impl.direct.FieldMatch;
import org.solrmarc.index.extractor.impl.direct.ModifyableMultiValueExtractor;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.specification.Specification;

public class DirectMultiValueExtractor
extends AbstractMultiValueExtractor
implements ExternalMethod,
ModifyableMultiValueExtractor {
    private Specification fieldsAndSubfieldSpec;

    public DirectMultiValueExtractor(Specification fieldSpec) {
        this.fieldsAndSubfieldSpec = fieldSpec;
    }

    private DirectMultiValueExtractor(DirectMultiValueExtractor toClone) {
        this.fieldsAndSubfieldSpec = toClone.fieldsAndSubfieldSpec.isThreadSafe() ? toClone.fieldsAndSubfieldSpec : (Specification)toClone.fieldsAndSubfieldSpec.makeThreadSafeCopy();
    }

    public Specification getFieldsAndSubfieldSpec() {
        return this.fieldsAndSubfieldSpec;
    }

    public void setFieldsAndSubfieldSpec(Specification fieldsAndSubfieldSpec) {
        this.fieldsAndSubfieldSpec = fieldsAndSubfieldSpec;
    }

    @Override
    public void addMap(AbstractMultiValueMapping valueMapping) {
        this.fieldsAndSubfieldSpec.addMap(valueMapping);
    }

    public final Collection<FieldMatch> getFieldMatches(Record record) {
        List<FieldMatch> result = this.fieldsAndSubfieldSpec.getFieldMatches(record);
        return result;
    }

    @Override
    public void extract(Collection<String> result, Record record) throws Exception {
        for (FieldMatch fm : this.getFieldMatches(record)) {
            fm.addValuesTo(result);
        }
    }

    @Override
    public void addCleanVal(FieldFormatter.eCleanVal cleanVal) {
        this.fieldsAndSubfieldSpec.addCleanVal(cleanVal);
    }

    @Override
    public void setCleanVal(EnumSet<FieldFormatter.eCleanVal> of) {
        this.fieldsAndSubfieldSpec.setCleanVal(of);
    }

    @Override
    public void setJoinVal(FieldFormatter.eJoinVal joinVal) {
        this.fieldsAndSubfieldSpec.setJoinVal(joinVal);
    }

    @Override
    public void setSeparator(String separator) {
        this.fieldsAndSubfieldSpec.setSeparator(separator);
    }

    @Override
    public void setSubstring(String startStr, String endStr) {
        int start;
        try {
            start = Integer.parseInt(startStr);
        }
        catch (NumberFormatException nfe) {
            throw new IndexerSpecException("Illegal substring specification: " + startStr);
        }
        if (endStr.equals("toEnd")) {
            this.fieldsAndSubfieldSpec.setSubstring(start, -1);
        } else {
            int end;
            try {
                end = Integer.parseInt(endStr);
            }
            catch (NumberFormatException nfe) {
                throw new IndexerSpecException("Illegal substring specification: " + endStr);
            }
            if (start < 0 || end < 0 || start > end) {
                throw new IndexerSpecException("Illegal substring interval: " + start + " " + end);
            }
            this.fieldsAndSubfieldSpec.setSubstring(start, end);
        }
    }

    @Override
    public void setFormatPatterns(String[] mapParts) {
        this.fieldsAndSubfieldSpec.setFormatPatterns(mapParts);
    }

    @Override
    public boolean isThreadSafe() {
        return this.fieldsAndSubfieldSpec.isThreadSafe();
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new DirectMultiValueExtractor(this);
    }
}

