/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.formatter;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.marc4j.marc.DataField;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.extractor.ExternalMethod;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.tools.DataUtil;

public class FieldFormatterBase
implements FieldFormatter {
    String indicatorFmt = null;
    Map<String, String> sfCodeMap = null;
    String fieldFormat = null;
    String separator = null;
    List<AbstractMultiValueMapping> maps = null;
    FieldFormatter.eJoinVal joinVal = FieldFormatter.eJoinVal.SEPARATE;
    int substringStart = -1;
    int substringEnd = -1;
    EnumSet<FieldFormatter.eCleanVal> cleanVal = EnumSet.noneOf(FieldFormatter.eCleanVal.class);
    String fieldTagFmt = null;

    public FieldFormatterBase(boolean clean) {
        if (clean) {
            this.cleanVal.add(FieldFormatter.eCleanVal.CLEAN_EACH);
            this.cleanVal.add(FieldFormatter.eCleanVal.CLEAN_END);
        }
    }

    public FieldFormatterBase(EnumSet<FieldFormatter.eCleanVal> cleanVal) {
        this.cleanVal = cleanVal;
    }

    public FieldFormatterBase(FieldFormatterBase toClone) {
        this.indicatorFmt = toClone.indicatorFmt;
        this.sfCodeMap = toClone.sfCodeMap;
        this.separator = toClone.separator;
        this.joinVal = toClone.joinVal;
        this.substringStart = toClone.substringStart;
        this.substringEnd = toClone.substringEnd;
        this.cleanVal = toClone.cleanVal;
        if (toClone.maps != null) {
            if (this.maps == null) {
                this.maps = new LinkedList<AbstractMultiValueMapping>();
            }
            for (AbstractMultiValueMapping map : toClone.maps) {
                if (map instanceof ExternalMethod && !((ExternalMethod)((Object)map)).isThreadSafe()) {
                    this.maps.add((AbstractMultiValueMapping)((ExternalMethod)((Object)map)).makeThreadSafeCopy());
                    continue;
                }
                this.maps.add(map);
            }
        }
    }

    @Override
    public String getFieldTagFmt() {
        return this.fieldTagFmt;
    }

    @Override
    public FieldFormatter setFieldTagFmt(String fieldTagFmt) {
        this.fieldTagFmt = fieldTagFmt;
        return this;
    }

    @Override
    public String getIndicatorFmt() {
        return this.indicatorFmt;
    }

    @Override
    public FieldFormatter setIndicatorFmt(String indicatorFmt) {
        this.indicatorFmt = indicatorFmt;
        return this;
    }

    @Override
    public FieldFormatter setSfCodeFmt(String[] mapParts) {
        if (this.sfCodeMap == null) {
            this.sfCodeMap = new LinkedHashMap<String, String>();
        }
        for (String part : mapParts) {
            String[] pieces = part.split("=>", 2);
            if (pieces.length != 2 || pieces[1].contains("=>")) {
                // empty if block
            }
            if (pieces.length == 2 && pieces[0].length() == 1) {
                this.sfCodeMap.put(pieces[0], pieces[1]);
                continue;
            }
            if (pieces.length == 2 && pieces[0].matches("\\[[-a-z0-9]*\\]")) {
                String cstr;
                char c;
                for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                    cstr = Character.toString(c);
                    if (!cstr.matches(pieces[0])) continue;
                    this.sfCodeMap.put(cstr, pieces[1]);
                }
                for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                    cstr = Character.toString(c);
                    if (!cstr.matches(pieces[0])) continue;
                    this.sfCodeMap.put(cstr, pieces[1]);
                }
                continue;
            }
            if (pieces.length == 2 && pieces[0].contains("tag")) {
                this.setFieldTagFmt(pieces[1]);
                continue;
            }
            if (pieces.length == 2 && pieces[0].contains("ind")) {
                this.setIndicatorFmt(pieces[1]);
                continue;
            }
            if (this.fieldFormat != null || part.equals("format")) continue;
            this.fieldFormat = part;
        }
        return this;
    }

    @Override
    public String getFieldFormat() {
        return this.fieldFormat;
    }

    @Override
    public boolean hasFieldFormat() {
        return this.fieldFormat != null;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public FieldFormatter setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public EnumSet<FieldFormatter.eCleanVal> getCleanVal() {
        return this.cleanVal;
    }

    @Override
    public FieldFormatter setCleanVal(EnumSet<FieldFormatter.eCleanVal> cleanVal) {
        this.cleanVal.addAll(cleanVal);
        return this;
    }

    @Override
    public FieldFormatter addCleanVal(FieldFormatter.eCleanVal cleanVal) {
        this.cleanVal.add(cleanVal);
        return this;
    }

    @Override
    public FieldFormatter.eJoinVal getJoinVal() {
        return this.joinVal;
    }

    @Override
    public FieldFormatter setJoinVal(FieldFormatter.eJoinVal joinVal) {
        this.joinVal = joinVal;
        return this;
    }

    @Override
    public FieldFormatter setSubstring(int offset, int endOffset) {
        this.substringStart = offset;
        this.substringEnd = endOffset;
        return this;
    }

    @Override
    public FieldFormatter addMap(AbstractMultiValueMapping valueMapping) {
        if (this.maps == null) {
            this.maps = new LinkedList<AbstractMultiValueMapping>();
        }
        this.maps.add(valueMapping);
        return this;
    }

    @Override
    public StringBuilder start() {
        return new StringBuilder();
    }

    @Override
    public void addTag(StringBuilder sb, VariableField df) {
        if (this.fieldFormat != null && this.fieldFormat.contains("%tag")) {
            this.sbReplace(sb, "%tag", df.getTag());
        } else if (this.fieldTagFmt != null && this.fieldTagFmt.length() > 0) {
            sb.append(this.fieldTagFmt.contains("%tag") ? this.fieldTagFmt.replace("%tag", df.getTag()) : this.fieldTagFmt);
        }
    }

    private void sbReplace(StringBuilder sb, String pattern, String value) {
        int indexOf = sb.indexOf(pattern);
        if (indexOf != -1) {
            sb.replace(indexOf, indexOf + pattern.length(), value);
        }
    }

    @Override
    public void addIndicators(StringBuilder sb, VariableField df) {
        if (this.fieldFormat != null && (this.fieldFormat.contains("%1") || this.fieldFormat.contains("%2"))) {
            this.sbReplace(sb, "%1", "" + ((DataField)df).getIndicator1());
            this.sbReplace(sb, "%2", "" + ((DataField)df).getIndicator2());
        } else if (this.indicatorFmt != null && this.indicatorFmt.length() > 0 && df instanceof DataField) {
            String result = this.indicatorFmt.replace("%1", "" + ((DataField)df).getIndicator1()).replace("%2", "" + ((DataField)df).getIndicator2());
            sb.append(result);
        }
    }

    @Override
    public void addCode(StringBuilder sb, String codeStr) {
    }

    @Override
    public Collection<String> handleMapping(Collection<String> cleaned) throws Exception {
        if (this.maps == null) {
            return cleaned;
        }
        Collection<String> mapped = cleaned;
        for (AbstractMultiValueMapping map : this.maps) {
            mapped = map.map(mapped);
        }
        return mapped;
    }

    @Override
    public String handleSubFieldFormat(String sfCode, VariableField vf, String mappedDataVal) {
        String ind2;
        if (this.sfCodeMap == null || !this.sfCodeMap.containsKey(sfCode) && !this.sfCodeMap.containsKey("*")) {
            return mappedDataVal;
        }
        String pattern = null;
        if (this.sfCodeMap.containsKey(sfCode)) {
            pattern = this.sfCodeMap.get(sfCode);
        } else if (this.sfCodeMap.containsKey("*")) {
            pattern = this.sfCodeMap.get("*");
        }
        String ind1 = vf instanceof DataField ? "" + ((DataField)vf).getIndicator1() : " ";
        String string = ind2 = vf instanceof DataField ? "" + ((DataField)vf).getIndicator2() : " ";
        if (pattern.contains("$" + sfCode)) {
            pattern = pattern.replace("$" + sfCode, "%d");
        }
        pattern = pattern.replace("%tag", vf.getTag()).replace("%1", ind1).replace("%2", ind2).replace("%sf", sfCode).replace("%d", mappedDataVal);
        return pattern;
    }

    private final String getSubstring(String data) {
        try {
            if (this.substringStart != -1) {
                if (this.substringEnd != -1) {
                    return data.substring(this.substringStart, this.substringEnd);
                }
                return data.substring(this.substringStart);
            }
            return data;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return "";
        }
    }

    @Override
    public String cleanData(VariableField vf, boolean isSubfieldA, String data) {
        EnumSet<FieldFormatter.eCleanVal> cleanVal = this.getCleanVal();
        int numToDel = 0;
        String trimmed = data;
        if ((cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR_1) || cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR_2) || cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR)) && isSubfieldA && vf instanceof DataField) {
            DataField df = (DataField)vf;
            char indVal = this.getIndicatorValueToStrip(df, cleanVal);
            int n = numToDel = indVal >= '0' && indVal <= '9' ? indVal - 48 : 0;
            if (numToDel > trimmed.length()) {
                numToDel = trimmed.length();
            }
            if (numToDel > 0) {
                trimmed = trimmed.substring(numToDel);
            }
        }
        trimmed = cleanVal.contains((Object)FieldFormatter.eCleanVal.UNTRIMMED) ? this.getSubstring(trimmed) : this.getSubstring(trimmed).trim();
        String str = DataUtil.cleanByVal(trimmed, cleanVal);
        return str;
    }

    private char getIndicatorValueToStrip(DataField df, EnumSet<FieldFormatter.eCleanVal> cleanVal) {
        String ind1Fields = "130:630:730:740";
        String ind2Fields = "222:240:242:243:245:440:830";
        if (cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR) || cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR_1) && cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR_2)) {
            if ("130:630:730:740".contains(df.getTag())) {
                return df.getIndicator1();
            }
            if ("222:240:242:243:245:440:830".contains(df.getTag())) {
                return df.getIndicator2();
            }
            return '\u0000';
        }
        if (cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR_1)) {
            return df.getIndicator1();
        }
        if (cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR_2)) {
            return df.getIndicator2();
        }
        return '\u0000';
    }

    @Override
    public void addVal(StringBuilder sb, String sfcode, String data) {
        if (this.fieldFormat != null && sfcode != null) {
            this.sbReplace(sb, "$" + sfcode, data);
        } else {
            sb.append(data);
        }
    }

    @Override
    public void addSeparator(StringBuilder sb, int cnt) {
        if (this.fieldFormat == null && this.joinVal == FieldFormatter.eJoinVal.JOIN && this.getSeparator() != null && cnt != 0) {
            sb.append(this.getSeparator());
        }
    }

    @Override
    public void addAfterSubfield(StringBuilder sb, Collection<String> result) {
        if (this.fieldFormat == null && this.joinVal == FieldFormatter.eJoinVal.SEPARATE) {
            String field;
            if (sb.length() == 0) {
                return;
            }
            String string = field = this.getCleanVal().contains((Object)FieldFormatter.eCleanVal.CLEAN_END) ? DataUtil.cleanData(sb.toString()) : sb.toString();
            if (field.length() > 0) {
                result.add(field);
            }
            sb.setLength(0);
        }
    }

    @Override
    public void addAfterField(StringBuilder sb, Collection<String> result) {
        if (this.fieldFormat != null) {
            String field;
            String fieldVal = sb.toString().replaceAll("\\$[a-z0-9]", "");
            if (fieldVal.length() == 0) {
                return;
            }
            String string = field = this.getCleanVal().contains((Object)FieldFormatter.eCleanVal.CLEAN_END) ? DataUtil.cleanData(fieldVal) : fieldVal;
            if (field.length() > 0) {
                result.add(field);
            }
            sb.setLength(0);
        } else if (this.joinVal == FieldFormatter.eJoinVal.JOIN) {
            String field;
            if (sb.length() == 0) {
                return;
            }
            String string = field = this.getCleanVal().contains((Object)FieldFormatter.eCleanVal.CLEAN_END) ? DataUtil.cleanData(sb.toString()) : sb.toString();
            if (field.length() > 0) {
                result.add(field);
            }
            sb.setLength(0);
        }
    }

    @Override
    public Collection<String> prepData(VariableField vf, boolean isSubfieldA, String data) throws Exception {
        String cleaned = this.cleanData(vf, isSubfieldA, data);
        List<String> cleanedDataAsList = cleaned == null || cleaned.length() == 0 ? Collections.EMPTY_LIST : Collections.singletonList(cleaned);
        Collection<String> result = this.handleMapping(cleanedDataAsList);
        return result;
    }

    @Override
    public boolean isThreadSafe() {
        if (this.maps == null) {
            return true;
        }
        for (AbstractMultiValueMapping map : this.maps) {
            if (!(map instanceof ExternalMethod) || ((ExternalMethod)((Object)map)).isThreadSafe()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new FieldFormatterBase(this);
    }
}

