/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.collector;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.tools.SolrMarcIndexerException;
import org.solrmarc.tools.StringNaturalCompare;

public class MultiValueCollector {
    boolean isUnique = false;
    eAction ifFieldEmpty = eAction.NOACTION;
    eAction ifFieldNotEmpty = eAction.NOACTION;
    eNormalize normalize = eNormalize.NOCHANGE;
    Comparator<String> sortComparator = null;
    eFirstVal first = eFirstVal.ALL;

    public static eFirstVal fromString(String str) {
        if (str.equals("first")) {
            return eFirstVal.FIRST;
        }
        if (str.equals("notfirst")) {
            return eFirstVal.NOTFIRST;
        }
        return eFirstVal.ALL;
    }

    public MultiValueCollector(String comp, String dir, boolean unique, String first) {
        this.isUnique = unique;
        this.first = MultiValueCollector.fromString(first);
        this.sortComparator = this.setComparator(comp, dir);
    }

    public MultiValueCollector(boolean unique, String first) {
        this.isUnique = unique;
        this.first = MultiValueCollector.fromString(first);
        this.sortComparator = null;
    }

    public MultiValueCollector() {
        this.isUnique = false;
        this.first = eFirstVal.ALL;
        this.sortComparator = null;
    }

    private Comparator<String> setComparator(String compStr, String dir) {
        Comparator<String> comp = null;
        if (compStr == null) {
            return null;
        }
        if (compStr.equals("str") && dir.equals("desc")) {
            comp = Collections.reverseOrder();
        } else if (compStr.equals("str") && dir.equals("asc")) {
            comp = new NaturalComp();
        } else if (compStr.equals("num") && dir.equals("asc")) {
            comp = new StringNaturalCompare();
        } else if (compStr.equals("num") && dir.equals("desc")) {
            comp = Collections.reverseOrder(new StringNaturalCompare());
        } else if (compStr.equals("length") && dir.equals("asc")) {
            comp = new LengthComp();
        } else if (compStr.equals("length") && dir.equals("desc")) {
            comp = Collections.reverseOrder(new LengthComp());
        } else {
            if (!(compStr.equals("length") || compStr.equals("num") || compStr.equals("str"))) {
                throw new IndexerSpecException("Invalid sort specification, valid values are \"str\"  \"num\"  \"length\" ");
            }
            throw new IndexerSpecException("Invalid sort direction, valid values are \"asc\"  \"desc\" ");
        }
        return comp;
    }

    public Collection<String> collect(Collection<String> values) {
        Collection<Object> result;
        if ((!this.isUnique || values instanceof Set) && this.sortComparator == null && this.first == eFirstVal.ALL && this.ifFieldEmpty == eAction.NOACTION && this.ifFieldNotEmpty == eAction.NOACTION && this.normalize == eNormalize.NOCHANGE) {
            return values;
        }
        if (this.isUnique) {
            result = this.sortComparator == null ? new LinkedHashSet<String>() : new TreeSet<String>(this.sortComparator);
            this.addAllNormalized(result, values, this.normalize);
        } else if (this.sortComparator != null) {
            ArrayList<String> resultL = new ArrayList<String>();
            this.addAllNormalized(resultL, values, this.normalize);
            Collections.sort(resultL, this.sortComparator);
            result = resultL;
        } else {
            result = values;
        }
        if (result == null || result.isEmpty()) {
            if (this.ifFieldEmpty == eAction.DELETE) {
                throw new SolrMarcIndexerException(2);
            }
            if (this.ifFieldEmpty == eAction.SKIP) {
                throw new SolrMarcIndexerException(1);
            }
            return result;
        }
        if (this.ifFieldNotEmpty == eAction.DELETE) {
            throw new SolrMarcIndexerException(2);
        }
        if (this.ifFieldNotEmpty == eAction.SKIP) {
            throw new SolrMarcIndexerException(1);
        }
        if (this.first == eFirstVal.FIRST) {
            return Collections.singletonList(result.iterator().next());
        }
        if (this.first == eFirstVal.NOTFIRST) {
            result = result instanceof List ? ((List)result).subList(1, result.size()) : Collections.list(Collections.enumeration(result)).subList(1, result.size());
        }
        if (result.isEmpty() && this.ifFieldEmpty != eAction.NOACTION) {
            if (this.ifFieldEmpty == eAction.DELETE) {
                throw new SolrMarcIndexerException(2);
            }
            if (this.ifFieldEmpty == eAction.SKIP) {
                throw new SolrMarcIndexerException(1);
            }
        }
        if (!result.isEmpty() && this.ifFieldNotEmpty != eAction.NOACTION) {
            if (this.ifFieldNotEmpty == eAction.DELETE) {
                throw new SolrMarcIndexerException(2);
            }
            if (this.ifFieldNotEmpty == eAction.SKIP) {
                throw new SolrMarcIndexerException(1);
            }
        }
        return result;
    }

    private void addAllNormalized(Collection<String> result, Collection<String> values, eNormalize normalize) {
        block3: {
            block4: {
                block2: {
                    if (normalize != eNormalize.NOCHANGE) break block2;
                    result.addAll(values);
                    break block3;
                }
                if (normalize != eNormalize.COMPOSE) break block4;
                for (String value : values) {
                    String normedValue = Normalizer.normalize(value, Normalizer.Form.NFC);
                    result.add(normedValue);
                }
                break block3;
            }
            if (normalize != eNormalize.DECOMPOSE) break block3;
            for (String value : values) {
                String normedValue = Normalizer.normalize(value, Normalizer.Form.NFD);
                result.add(normedValue);
            }
        }
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public MultiValueCollector setUnique(boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    public Comparator<String> getSortComparator() {
        return this.sortComparator;
    }

    public MultiValueCollector setSortComparator(String comp, String dir) {
        this.sortComparator = this.setComparator(comp, dir);
        return this;
    }

    public MultiValueCollector setFirst(eFirstVal first) {
        this.first = first;
        return this;
    }

    public MultiValueCollector setFirst(String firstStr) {
        this.first = MultiValueCollector.fromString(firstStr);
        return this;
    }

    public void setIfFieldEmpty(eAction action) {
        this.ifFieldEmpty = action;
    }

    public void setIfFieldNotEmpty(eAction action) {
        this.ifFieldNotEmpty = action;
    }

    public void setNormalize(String normVal) {
        this.normalize = normVal.equals("C") ? eNormalize.COMPOSE : (normVal.equals("D") ? eNormalize.DECOMPOSE : eNormalize.NOCHANGE);
    }

    private class NaturalComp
    implements Comparator<String> {
        private NaturalComp() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }

    private class LengthComp
    implements Comparator<String> {
        private LengthComp() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.length() - s2.length();
        }
    }

    public static enum eFirstVal {
        ALL,
        FIRST,
        NOTFIRST;

    }

    public static enum eNormalize {
        NOCHANGE,
        COMPOSE,
        DECOMPOSE;

    }

    public static enum eAction {
        NOACTION,
        SKIP,
        DELETE;

    }
}

