/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.indexer.AbstractValueIndexer;
import org.solrmarc.index.indexer.MultiValueIndexer;
import org.solrmarc.index.indexer.ValueIndexerFactory;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.tools.DataUtil;
import org.solrmarc.tools.Utils;

@Deprecated
public class SolrIndexerShim {
    private ThreadLocal<Map<String, AbstractValueIndexer<?>>> indexerCache = new ThreadLocal<Map<String, AbstractValueIndexer<?>>>(){

        @Override
        protected Map<String, AbstractValueIndexer<?>> initialValue() {
            return new HashMap();
        }
    };
    private ConcurrentMap<String, Object> transMapMap = new ConcurrentHashMap<String, Object>();
    private static SolrIndexerShim theSolrIndexer;

    private SolrIndexerShim() {
    }

    public static SolrIndexerShim instance() {
        if (theSolrIndexer == null) {
            theSolrIndexer = new SolrIndexerShim();
        }
        return theSolrIndexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractValueIndexer<?> getOrCreateIndexerFullSpec(String fullSpec) {
        MultiValueIndexer indexer;
        if (this.indexerCache.get().containsKey(fullSpec)) {
            return this.indexerCache.get().get(fullSpec);
        }
        ValueIndexerFactory valueIndexerFactory = ValueIndexerFactory.instance();
        synchronized (valueIndexerFactory) {
            indexer = ValueIndexerFactory.instance().createValueIndexer("", fullSpec);
            this.indexerCache.get().put(fullSpec, indexer);
        }
        return indexer;
    }

    private AbstractValueIndexer<?> getOrCreateIndexerMapped(String tagStr, String map) {
        String key = map == null ? tagStr : tagStr + ", " + map;
        return this.getOrCreateIndexerFullSpec(key);
    }

    private AbstractValueIndexer<?> getOrCreateIndexer(String tagStr, String separator) {
        String key = separator == null ? tagStr : tagStr + ", join(\"" + separator + "\")";
        return this.getOrCreateIndexerFullSpec(key);
    }

    private AbstractValueIndexer<?> getOrCreateIndexer(String tagStr, int start, int end) {
        String key = start == -1 && end == -1 ? tagStr : tagStr + "[" + start + "-" + end + "]";
        return this.getOrCreateIndexerFullSpec(key);
    }

    private void getFieldListCollector(Record record, AbstractValueIndexer<?> indexer, Collection<String> collector) {
        try {
            indexer.getFieldData(record, collector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getFieldListCollector(Record record, String tagStr, String mapStr, Collection<String> collector) {
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexerMapped(tagStr, mapStr);
        this.getFieldListCollector(record, indexer, collector);
    }

    public Set<String> getFieldList(Record record, String tagStr) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.getFieldListCollector(record, tagStr, null, result);
        return result;
    }

    public Set<String> getMappedFieldList(Record record, String tagStr, String mapStr) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.getFieldListCollector(record, tagStr, mapStr, result);
        return result;
    }

    public List<String> getFieldListAsList(Record record, String tagStr) {
        ArrayList<String> result = new ArrayList<String>();
        this.getFieldListCollector(record, tagStr, null, result);
        return result;
    }

    public String getFieldVals(Record record, String tagStr, String separator) {
        Set<String> result = this.getFieldList(record, tagStr);
        return Utils.join(result, separator);
    }

    public String getFirstFieldVal(Record record, String tagStr) {
        Set<String> result = this.getFieldList(record, tagStr);
        Iterator<String> iter = result.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public String getFirstFieldVal(Record record, String mapName, String tagStr) {
        Set<String> result = this.getMappedFieldList(record, tagStr, mapName);
        Iterator<String> iter = result.iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    public boolean isControlField(String fieldTag) {
        return fieldTag.matches("00[0-9]");
    }

    public void getSubfieldDataCollector(Record record, String fldTag, String subfldsStr, String separator, Collection<String> collector) {
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexer(fldTag + subfldsStr, separator);
        this.getFieldListCollector(record, indexer, collector);
    }

    public void getSubfieldDataCollector(Record record, String fldTag, String subfldStr, int beginIx, int endIx, Collection<String> collector) {
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexer(fldTag + subfldStr, beginIx, endIx);
        this.getFieldListCollector(record, indexer, collector);
    }

    public Set<String> getSubfieldDataAsSet(Record record, String fldTag, String subfldsStr, String separator) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.getSubfieldDataCollector(record, fldTag, subfldsStr, separator, result);
        return result;
    }

    public Set<String> getSubfieldDataAsSet(Record record, String fldTag, String subfldStr, int beginIx, int endIx) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.getSubfieldDataCollector(record, fldTag, subfldStr, beginIx, endIx, result);
        return result;
    }

    public Set<String> removeTrailingPunct(Record record, String fieldSpec) {
        Set<String> result = this.getFieldList(record, fieldSpec);
        LinkedHashSet<String> newResult = new LinkedHashSet<String>();
        for (String s : result) {
            newResult.add(DataUtil.cleanData(s));
        }
        return newResult;
    }

    public String getPublicationDate(Record record) {
        ArrayList<String> result = new ArrayList<String>();
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexerFullSpec("008[7-10]:008[11-14]:260c:264c?(ind2=1||ind2=4),clean, first, map(\"(^|.*[^0-9])((20|1[5-9])[0-9][0-9])([^0-9]|$)=>$2\",\".*[^0-9].*=>\")");
        this.getFieldListCollector(record, indexer, result);
        return result.size() == 0 ? "" : (String)result.iterator().next();
    }

    public Set<String> getFullTextUrls(Record record) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexer("{856uz3}?((ind1 = 4 || (ind1 = 7 & $x startsWith \"http\")) && (ind2 = 0 || (ind2 = 1 )))", "||");
        this.getFieldListCollector(record, indexer, result);
        return result;
    }

    public Set<String> getSupplUrls(Record record) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexer("{856uz3}?((ind1 = 4 || (ind1 = 7 & $x startsWith \"http\")) && (ind2 = 2 || (ind2 = 1)))", "||");
        this.getFieldListCollector(record, indexer, result);
        return result;
    }

    public Set<String> getAllSubfields(Record record, String fieldSpec, String separator) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexer(fieldSpec, separator);
        this.getFieldListCollector(record, indexer, result);
        return result;
    }

    public Set<String> getAllAlphaSubfields(Record record, String fieldSpec, String firstAllJoin) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String[] pieces = fieldSpec.split(":");
        String fieldSpecWithAll = Utils.join(pieces, "[a-z]:") + "[a-z], " + firstAllJoin;
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexerFullSpec(fieldSpecWithAll);
        this.getFieldListCollector(record, indexer, result);
        return result;
    }

    public Set<String> getAllAlphaExcept(Record record, String fieldSpec) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String[] pieces = fieldSpec.split(":");
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece.substring(0, 3)).append("[^").append(piece.substring(3)).append("0-9]:");
        }
        sb.setLength(sb.length() - 1);
        String fieldSpecWithAll = sb.toString();
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexerFullSpec(fieldSpecWithAll);
        this.getFieldListCollector(record, indexer, result);
        return result;
    }

    public List<String> getAllSubfieldsAsList(Record record, String fieldSpec, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexer(fieldSpec, separator);
        this.getFieldListCollector(record, indexer, result);
        return result;
    }

    public String getAllSearchableFields(Record record, String lowerBoundStr, String upperBoundStr) {
        StringBuffer buffer = new StringBuffer("");
        int lowerBound = this.localParseInt(lowerBoundStr, 100);
        int upperBound = this.localParseInt(upperBoundStr, 900);
        List fields = record.getDataFields();
        for (DataField field : fields) {
            int tag = this.localParseInt(field.getTag(), -1);
            if (tag < lowerBound || tag >= upperBound) continue;
            List subfields = field.getSubfields();
            for (Subfield subfield : subfields) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(subfield.getData());
            }
        }
        return buffer.toString();
    }

    public Set<String> getAllSearchableFieldsAsSet(Record record, String lowerBoundStr, String upperBoundStr) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int lowerBound = this.localParseInt(lowerBoundStr, 100);
        int upperBound = this.localParseInt(upperBoundStr, 900);
        List fields = record.getDataFields();
        for (DataField field : fields) {
            int tag = this.localParseInt(field.getTag(), -1);
            if (tag < lowerBound || tag >= upperBound) continue;
            StringBuffer buffer = new StringBuffer("");
            List subfields = field.getSubfields();
            for (Subfield subfield : subfields) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(subfield.getData());
            }
            result.add(buffer.toString());
        }
        return result;
    }

    public String getSortableTitle(Record record) {
        ArrayList<String> result = new ArrayList<String>();
        AbstractValueIndexer<?> indexer = this.getOrCreateIndexerFullSpec("245abkp,titleSortLower,first");
        this.getFieldListCollector(record, indexer, result);
        return result.size() == 0 ? "" : (String)result.iterator().next();
    }

    private int localParseInt(String str, int defValue) {
        int value = defValue;
        try {
            value = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public List<VariableField> getFieldSetMatchingTagList(Record record, String tagList) {
        String[] tags = tagList.split(":");
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i].substring(0, 3);
            if (tag == "LNK") {
                tag = tags[i].substring(0, 6);
            }
            tags[i] = tag;
        }
        return record.getVariableFields(tags);
    }

    public String loadTranslationMap(String translationMapSpec) {
        if (this.findMap(translationMapSpec) == null) {
            AbstractMultiValueMapping map = ValueIndexerFactory.instance().createMultiValueMapping(translationMapSpec);
            this.transMapMap.putIfAbsent(translationMapSpec, map);
        }
        return translationMapSpec;
    }

    public String loadTranslationMap(String ignore, String translationMapSpec) {
        return this.loadTranslationMap(translationMapSpec);
    }

    public Object findMap(String mapName) {
        if (this.transMapMap.containsKey(mapName)) {
            return this.transMapMap.get(mapName);
        }
        return null;
    }

    public Collection<String> remap(Collection<String> valuesToMap, Object translationMap, boolean b) throws Exception {
        if (translationMap instanceof AbstractMultiValueMapping) {
            AbstractMultiValueMapping map = (AbstractMultiValueMapping)translationMap;
            return map.map(valuesToMap);
        }
        return null;
    }

    public String remap(String valueToMap, Object translationMap, boolean b) throws Exception {
        if (translationMap instanceof AbstractMultiValueMapping) {
            AbstractMultiValueMapping map = (AbstractMultiValueMapping)translationMap;
            return map.mapSingle(valueToMap);
        }
        return null;
    }

    public String getDataFromVariableField(VariableField vf, String subfldTags, String separator, boolean cleanIt) {
        if (subfldTags.length() > 1 && !subfldTags.startsWith("[")) {
            subfldTags = '[' + subfldTags + ']';
        }
        Pattern subfieldPattern = Pattern.compile(subfldTags.length() == 0 ? "." : subfldTags);
        DataField marcField = (DataField)vf;
        StringBuffer buffer = new StringBuffer("");
        List subfields = marcField.getSubfields();
        for (Subfield subfield : subfields) {
            Matcher matcher = subfieldPattern.matcher("" + subfield.getCode());
            if (!matcher.matches()) continue;
            if (buffer.length() > 0) {
                buffer.append(separator != null ? separator : " ");
            }
            buffer.append(subfield.getData().trim());
        }
        if (buffer.length() > 0) {
            return cleanIt ? DataUtil.cleanData(buffer.toString()) : buffer.toString();
        }
        return null;
    }
}

