/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.SolrIndexerShim;
import org.solrmarc.index.extractor.impl.custom.Mixin;

public class SolrIndexer
implements Mixin {
    private static ThreadLocal<SolrIndexer[]> indexerCache = new ThreadLocal<SolrIndexer[]>(){

        @Override
        protected SolrIndexer[] initialValue() {
            return new SolrIndexer[1];
        }
    };
    private static SolrIndexer theDefaultBaseIndexer = null;
    private static SolrIndexer theDefaultIndexer = null;

    public static SolrIndexer instance() {
        SolrIndexer result = indexerCache.get()[0];
        if (result == null && (result = theDefaultIndexer) != null) {
            SolrIndexer.indexerCache.get()[0] = result;
        }
        if (result == null) {
            result = theDefaultBaseIndexer;
        }
        return result;
    }

    public SolrIndexer() {
        SolrIndexer[] perThreadCache = indexerCache.get();
        if (perThreadCache[0] == null) {
            perThreadCache[0] = this;
        }
        if (theDefaultBaseIndexer == null) {
            theDefaultBaseIndexer = this;
        }
    }

    public SolrIndexer(String propertiesMapFile, String[] propertyDirs) {
        SolrIndexer[] perThreadCache = indexerCache.get();
        perThreadCache[0] = this;
        if (theDefaultIndexer == null) {
            theDefaultIndexer = this;
        }
    }

    public void getFieldListCollector(Record record, String tagStr, String mapStr, Collection<String> collector) {
        SolrIndexerShim.instance().getFieldListCollector(record, tagStr, mapStr, collector);
    }

    public Set<String> getFieldList(Record record, String tagStr) {
        return SolrIndexerShim.instance().getFieldList(record, tagStr);
    }

    public Set<String> getMappedFieldList(Record record, String tagStr, String mapStr) {
        return SolrIndexerShim.instance().getMappedFieldList(record, tagStr, mapStr);
    }

    public List<String> getFieldListAsList(Record record, String tagStr) {
        return SolrIndexerShim.instance().getFieldListAsList(record, tagStr);
    }

    public String getFieldVals(Record record, String tagStr, String separator) {
        return SolrIndexerShim.instance().getFieldVals(record, tagStr, separator);
    }

    public String getFirstFieldVal(Record record, String tagStr) {
        return SolrIndexerShim.instance().getFirstFieldVal(record, tagStr);
    }

    public String getFirstFieldVal(Record record, String mapName, String tagStr) {
        return SolrIndexerShim.instance().getFirstFieldVal(record, mapName, tagStr);
    }

    public void getSubfieldDataCollector(Record record, String fldTag, String subfldsStr, String separator, Collection<String> collector) {
        SolrIndexerShim.instance().getSubfieldDataCollector(record, fldTag, subfldsStr, separator, collector);
    }

    public void getSubfieldDataCollector(Record record, String fldTag, String subfldStr, int beginIx, int endIx, Collection<String> collector) {
        SolrIndexerShim.instance().getSubfieldDataCollector(record, fldTag, subfldStr, beginIx, endIx, collector);
    }

    public Set<String> getSubfieldDataAsSet(Record record, String fldTag, String subfldsStr, String separator) {
        return SolrIndexerShim.instance().getSubfieldDataAsSet(record, fldTag, subfldsStr, separator);
    }

    public Set<String> getSubfieldDataAsSet(Record record, String fldTag, String subfldStr, int beginIx, int endIx) {
        return SolrIndexerShim.instance().getSubfieldDataAsSet(record, fldTag, subfldStr, beginIx, endIx);
    }

    public Set<String> removeTrailingPunct(Record record, String fieldSpec) {
        return SolrIndexerShim.instance().removeTrailingPunct(record, fieldSpec);
    }

    public String getPublicationDate(Record record) {
        return SolrIndexerShim.instance().getPublicationDate(record);
    }

    public Set<String> getFullTextUrls(Record record) {
        return SolrIndexerShim.instance().getFullTextUrls(record);
    }

    public Set<String> getSupplUrls(Record record) {
        return SolrIndexerShim.instance().getSupplUrls(record);
    }

    public Set<String> getAllSubfields(Record record, String fieldSpec, String separator) {
        return SolrIndexerShim.instance().getAllSubfields(record, fieldSpec, separator);
    }

    public Set<String> getAllAlphaSubfields(Record record, String fieldSpec, String firstAllJoin) {
        return SolrIndexerShim.instance().getAllAlphaSubfields(record, fieldSpec, firstAllJoin);
    }

    public Set<String> getAllAlphaExcept(Record record, String fieldSpec) {
        return SolrIndexerShim.instance().getAllAlphaExcept(record, fieldSpec);
    }

    public List<String> getAllSubfieldsAsList(Record record, String fieldSpec, String separator) {
        return SolrIndexerShim.instance().getAllSubfieldsAsList(record, fieldSpec, separator);
    }

    public String getAllSearchableFields(Record record, String lowerBoundStr, String upperBoundStr) {
        return SolrIndexerShim.instance().getAllSearchableFields(record, lowerBoundStr, upperBoundStr);
    }

    public Set<String> getAllSearchableFieldsAsSet(Record record, String lowerBoundStr, String upperBoundStr) {
        return SolrIndexerShim.instance().getAllSearchableFieldsAsSet(record, lowerBoundStr, upperBoundStr);
    }

    public String getSortableTitle(Record record) {
        return SolrIndexerShim.instance().getSortableTitle(record);
    }

    public List<VariableField> getFieldSetMatchingTagList(Record record, String tagList) {
        return SolrIndexerShim.instance().getFieldSetMatchingTagList(record, tagList);
    }

    public String loadTranslationMap(String translationMapSpec) {
        return SolrIndexerShim.instance().loadTranslationMap(translationMapSpec);
    }

    public String loadTranslationMap(String ignore, String translationMapSpec) {
        return SolrIndexerShim.instance().loadTranslationMap(ignore, translationMapSpec);
    }

    public Object findMap(String mapName) {
        return SolrIndexerShim.instance().findMap(mapName);
    }

    public Collection<String> remap(Collection<String> valuesToMap, Object translationMap, boolean b) throws Exception {
        return SolrIndexerShim.instance().remap(valuesToMap, translationMap, b);
    }

    public String remap(String valueToMap, Object translationMap, boolean b) throws Exception {
        return SolrIndexerShim.instance().remap(valueToMap, translationMap, b);
    }

    public String getDataFromVariableField(VariableField vf, String subfldTags, String separator, boolean cleanIt) {
        return SolrIndexerShim.instance().getDataFromVariableField(vf, subfldTags, separator, cleanIt);
    }
}

