/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.marc4j.MarcReader;
import org.solrmarc.driver.ChunkIndexerWorker;
import org.solrmarc.driver.Indexer;
import org.solrmarc.driver.IndexerWorker;
import org.solrmarc.driver.MarcReaderThread;
import org.solrmarc.driver.RecordAndCnt;
import org.solrmarc.driver.RecordAndDoc;
import org.solrmarc.index.indexer.AbstractValueIndexer;
import org.solrmarc.solr.SolrProxy;

public class ThreadedIndexer
extends Indexer {
    private static final Logger logger = Logger.getLogger(ThreadedIndexer.class);
    private final BlockingQueue<RecordAndCnt> readQ;
    private final BlockingQueue<RecordAndDoc> docQ;
    private final int numThreadIndexers;
    private final int numSolrjWorkers;
    MarcReaderThread readerThread = null;
    Thread thisThread = null;
    ExecutorService indexerExecutor;
    ThreadPoolExecutor solrExecutor;
    IndexerWorker[] workers = null;
    boolean doneReading = false;
    final int chunksize;
    final AtomicInteger[] cnts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadedIndexer(List<AbstractValueIndexer<?>> indexers, SolrProxy solrProxy, int buffersize, int chunkSize) {
        super(indexers, solrProxy);
        this.readQ = new ArrayBlockingQueue<RecordAndCnt>(buffersize);
        this.docQ = new ArrayBlockingQueue<RecordAndDoc>(buffersize * 3);
        this.cnts = new AtomicInteger[]{new AtomicInteger(0), new AtomicInteger(0), new AtomicInteger(0)};
        int num = 1;
        try {
            num = Integer.parseInt(System.getProperty("solrmarc.indexer.threadcount", "1"));
        }
        catch (NumberFormatException nfe) {
            num = 1;
        }
        finally {
            this.numThreadIndexers = num;
        }
        num = 4;
        try {
            num = Integer.parseInt(System.getProperty("solrmarc.solrj.threadcount", "4"));
        }
        catch (NumberFormatException nfe) {
            num = 4;
        }
        finally {
            this.numSolrjWorkers = num;
        }
        this.indexerExecutor = Executors.newFixedThreadPool(this.numThreadIndexers);
        this.solrExecutor = new ThreadPoolExecutor(this.numSolrjWorkers, this.numSolrjWorkers * 3, 10000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.numSolrjWorkers * 4));
        this.chunksize = chunkSize;
    }

    private ThreadedIndexer(ThreadedIndexer toClone) {
        super(toClone);
        this.readQ = toClone.readQ;
        this.docQ = toClone.docQ;
        this.cnts = toClone.cnts;
        this.chunksize = toClone.chunksize;
        this.numThreadIndexers = toClone.numThreadIndexers;
        this.numSolrjWorkers = toClone.numSolrjWorkers;
    }

    @Override
    public Indexer makeThreadSafeCopy() {
        return new ThreadedIndexer(this);
    }

    @Override
    void shutDown(boolean viaInterrupt) {
        logger.warn((Object)"ThreadedIndexer ShutDown Called!");
        this.viaInterrupt = viaInterrupt;
        this.shuttingDown = true;
        if (this.readerThread != null) {
            this.readerThread.interrupt();
        }
        if (this.workers != null) {
            for (IndexerWorker worker : this.workers) {
                worker.setInterrupted();
            }
        }
        this.thisThread.interrupt();
        logger.warn((Object)"ThreadedIndexer ShutDown Exits");
    }

    @Override
    void resetCnts() {
        this.cnts[0].set(0);
        this.cnts[1].set(0);
        this.cnts[2].set(0);
    }

    @Override
    int incrementCnt(int cntNum) {
        return this.cnts[cntNum].incrementAndGet();
    }

    @Override
    int addToCnt(int cntNum, int amount) {
        return this.cnts[cntNum].addAndGet(amount);
    }

    @Override
    public int[] indexToSolr(MarcReader reader) {
        int i;
        this.thisThread = Thread.currentThread();
        this.resetCnts();
        this.readerThread = new MarcReaderThread(reader, this, this.readQ, this.cnts);
        this.readerThread.start();
        this.theReaderThread = this.readerThread;
        this.workers = new IndexerWorker[this.numThreadIndexers];
        for (i = 0; i < this.numThreadIndexers; ++i) {
            this.workers[i] = new IndexerWorker(this.readerThread, this.readQ, this.docQ, this, i);
        }
        for (i = 0; i < this.numThreadIndexers; ++i) {
            this.indexerExecutor.execute(this.workers[i]);
        }
        while (!this.done(this.workers)) {
            if (this.shuttingDown) {
                logger.warn((Object)"ThreadedIndexer at top of loop, shutting down");
            }
            if (this.docQ.size() > this.chunksize || this.indexerThreadsAreDone(this.workers) || this.shuttingDown && this.docQ.size() > 0 || this.readerThread.isPaused() && this.docQ.size() > 0) {
                int curProgress = this.cnts[2].get();
                if (this.trackOverallProgress > 0 && curProgress > this.lastProgress + this.trackOverallProgress) {
                    this.lastProgress = curProgress;
                    logger.info((Object)("ThreadedIndexer current progress: " + curProgress + " records"));
                }
                int curChunkSize = Math.min(this.chunksize, this.docQ.size());
                ArrayList<RecordAndDoc> chunk = new ArrayList<RecordAndDoc>(curChunkSize);
                if (this.shuttingDown) {
                    logger.warn((Object)("ThreadedIndexer flushing " + curChunkSize + " docs from docQ, which contains " + this.docQ.size() + " documents"));
                }
                if (this.docQ.drainTo(chunk, curChunkSize) <= 0) continue;
                RecordAndDoc firstDoc = (RecordAndDoc)chunk.get(0);
                String threadName = null;
                try {
                    String firstID = firstDoc.getRec().getControlNumber();
                    String lastID = ((RecordAndDoc)chunk.get(chunk.size() - 1)).getRec().getControlNumber();
                    threadName = "SolrUpdate-" + firstID + "-" + lastID;
                }
                catch (Exception e) {
                    threadName = "Anonymous";
                }
                BlockingQueue errQVal = this.isSet(Indexer.eErrorHandleVal.RETURN_ERROR_RECORDS) ? this.errQ : null;
                ChunkIndexerWorker runnableChunk = new ChunkIndexerWorker(threadName, chunk, errQVal, this);
                logger.debug((Object)("Starting IndexerThread: " + threadName));
                logger.debug((Object)("   approx number in solrj executor service: " + this.solrExecutor.getQueue().size()));
                while (runnableChunk != null) {
                    try {
                        this.solrExecutor.execute(runnableChunk);
                        runnableChunk = null;
                    }
                    catch (RejectedExecutionException rje) {
                        try {
                            logger.debug((Object)"Solrj thread pool full, blocking");
                            this.solrExecutor.getQueue().put(runnableChunk);
                            logger.debug((Object)"Solrj thread pool no longer full, un-blocking");
                            runnableChunk = null;
                        }
                        catch (InterruptedException e) {
                            logger.debug((Object)"Solrj thread pool interrupted, re-trying");
                        }
                    }
                }
                continue;
            }
            if (this.shuttingDown && this.docQ.size() == 0) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"ThreadedIndexer Interrupted!");
            }
        }
        if (this.shuttingDown) {
            logger.warn((Object)"ThreadedIndexer exited main while loop");
        }
        if (Thread.interrupted() || this.shuttingDown) {
            this.indexerExecutor.shutdownNow();
        } else {
            this.indexerExecutor.shutdown();
        }
        try {
            this.indexerExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info((Object)"Done with all indexing, finishing writing records to solr");
        this.solrExecutor.shutdown();
        boolean done = false;
        while (!done) {
            try {
                done = this.solrExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info((Object)"Done writing records to solr");
        return this.getCounts();
    }

    @Override
    int[] getCounts() {
        int[] intCnts = new int[]{this.cnts[0].get(), this.cnts[1].get(), this.cnts[2].get()};
        return intCnts;
    }

    public ExecutorService getSolrExecutor() {
        return this.solrExecutor;
    }

    private boolean indexerThreadsAreDone(IndexerWorker[] workers) {
        for (IndexerWorker worker : workers) {
            if (worker.isDoneWorking()) continue;
            return false;
        }
        return true;
    }

    private boolean done(IndexerWorker[] workers) {
        if (!this.readerThread.isDoneReading(this.shuttingDown) || !this.readQ.isEmpty()) {
            return false;
        }
        if (!this.docQ.isEmpty()) {
            return false;
        }
        return this.indexerThreadsAreDone(workers);
    }
}

