/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.marc4j.MarcError;
import org.marc4j.MarcException;
import org.marc4j.MarcJsonWriter;
import org.marc4j.MarcReader;
import org.marc4j.MarcReaderConfig;
import org.marc4j.MarcReaderFactory;
import org.marc4j.MarcStreamWriter;
import org.marc4j.MarcWriter;
import org.marc4j.MarcXmlWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.UnicodeToAnsel;
import org.marc4j.marc.Record;
import org.solrmarc.driver.BootableMain;
import org.solrmarc.driver.IndexDriver;
import org.solrmarc.driver.Indexer;
import org.solrmarc.index.indexer.AbstractValueIndexer;
import org.solrmarc.index.indexer.ValueIndexerFactory;
import org.solrmarc.solr.SolrProxy;
import org.solrmarc.tools.PropertyUtils;

public class RecordFixer
extends BootableMain {
    public static final Logger logger = Logger.getLogger(IndexDriver.class);
    Properties readerProps;
    MarcReaderConfig readerConfig;
    List<AbstractValueIndexer<?>> indexers;
    Indexer indexer;
    MarcReader reader;
    SolrProxy solrProxy;
    boolean verbose;
    int[] numIndexed;
    String[] args;
    long startTime;
    Thread shutdownSimulator = null;
    private MarcWriter writer;

    public static void main(String[] args) {
        RecordFixer driver = new RecordFixer(args);
        driver.execute();
    }

    public RecordFixer(String[] args) {
        this.args = args;
    }

    public void execute() {
        this.processArgs(this.args, true);
        ValueIndexerFactory.initialize(this.homeDirStrs);
        this.initializeFromOptions();
        List inputFiles = this.options.valuesOf(this.files);
        logger.info((Object)("Opening input files: " + Arrays.toString(inputFiles.toArray())));
        this.configureReader(inputFiles);
        this.processInput();
    }

    public void initializeFromOptions() {
        String[] inputSource = new String[1];
        String propertyFileAsURLStr = PropertyUtils.getPropertyFileAbsoluteURL(this.homeDirStrs, (String)this.options.valueOf(this.readOpts), true, inputSource);
        try {
            this.configureReaderProps(propertyFileAsURLStr);
        }
        catch (IOException e1) {
            logger.fatal((Object)("Fatal error: Exception opening reader properties input stream: " + inputSource[0]));
            logger.error((Object)"Exiting...");
            System.exit(1);
        }
        String outputType = this.options.has("solrURL") ? this.options.valueOf("solrURL").toString() : (this.options.has("null") ? "devnull" : "stdout");
        this.configureOutput(outputType);
    }

    public void configureReaderProps(String propertyFileURLStr) throws FileNotFoundException, IOException {
        this.readerProps = new Properties();
        if (propertyFileURLStr != null) {
            this.readerProps.load(PropertyUtils.getPropertyFileInputStream(propertyFileURLStr));
        }
        this.readerConfig = new MarcReaderConfig(this.readerProps);
    }

    public void configureReader(List<String> inputFilenames) {
        try {
            this.reader = MarcReaderFactory.makeReader((MarcReaderConfig)this.readerConfig, (String[])ValueIndexerFactory.instance().getHomeDirs(), inputFilenames);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void configureOutput(String mode) {
        PrintStream marcOut = null;
        try {
            String sysoutRedir = System.getProperty("solrmarc.output.redirect", null);
            marcOut = sysoutRedir != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(sysoutRedir)), true) : System.out;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (mode.equals("to_xml")) {
            this.writer = new MarcXmlWriter((OutputStream)marcOut, "UTF-8", true);
        } else if (mode.equals("to_json")) {
            this.writer = new MarcJsonWriter((OutputStream)marcOut, 0);
        } else if (mode.equals("to_utf8")) {
            this.writer = new MarcStreamWriter((OutputStream)marcOut, "UTF-8", true);
        } else if (mode.equals("to_marc8")) {
            this.writer = new MarcStreamWriter((OutputStream)marcOut, "ISO8859_1", true);
            this.writer.setConverter((CharConverter)new UnicodeToAnsel());
        } else if (mode.equals("to_ncr")) {
            this.writer = new MarcStreamWriter((OutputStream)marcOut, "ISO8859_1", true);
            this.writer.setConverter((CharConverter)new UnicodeToAnsel(true));
        }
    }

    public void processInput() {
        while (true) {
            Record record = null;
            try {
                if (!this.reader.hasNext()) break;
                record = this.reader.next();
            }
            catch (MarcException me) {
                logger.error((Object)"Unrecoverable Error in MARC record data", (Throwable)me);
                if (Boolean.parseBoolean(System.getProperty("solrmarc.terminate.on.marc.exception", "true"))) break;
                logger.warn((Object)"Trying to continue after MARC record data error");
                continue;
            }
            if (record.hasErrors()) {
                this.reportMarcErrors(record, record.getErrors());
            }
            this.writer.write(record);
        }
        this.writer.close();
    }

    private void reportMarcErrors(Record record, List<MarcError> errors) {
        String id = record.getControlNumber();
        if (id == null) {
            id = "No_001_Field";
        }
        for (MarcError err : errors) {
            logger.info((Object)(id + " : " + err.toString()));
        }
    }
}

