/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.util.EnumSet;
import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.marc4j.MarcError;
import org.marc4j.marc.Record;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.tools.SolrMarcIndexerException;

public class RecordAndDoc {
    final Record rec;
    SolrInputDocument doc;
    IndexerSpecException.eErrorSeverity errLvl;
    SolrMarcIndexerException smie;
    IndexerSpecException ise;
    EnumSet<eErrorLocationVal> errLocs = EnumSet.noneOf(eErrorLocationVal.class);

    RecordAndDoc(Record record) {
        this.rec = record;
        this.doc = null;
        this.errLocs = this.rec.hasErrors() ? EnumSet.of(eErrorLocationVal.MARC_ERROR) : EnumSet.noneOf(eErrorLocationVal.class);
        this.errLvl = this.rec.hasErrors() ? RecordAndDoc.errLvlForMarcError(this.rec.getErrors()) : IndexerSpecException.eErrorSeverity.NONE;
    }

    void setDoc(SolrInputDocument doc) {
        this.doc = doc;
    }

    SolrMarcIndexerException getSolrMarcIndexerException() {
        return this.smie;
    }

    void setSolrMarcIndexerException(SolrMarcIndexerException smie) {
        if (this.smie == null || this.smie.getLevel() < smie.getLevel()) {
            this.smie = smie;
        }
    }

    void setIndexerSpecException(IndexerSpecException ise) {
        if (this.ise == null || this.ise.getErrLvl().compareTo(ise.getErrLvl()) < 0) {
            this.ise = ise;
        }
    }

    private static IndexerSpecException.eErrorSeverity errLvlForMarcError(List<MarcError> errors) {
        int maxSeverity = -1;
        for (MarcError err : errors) {
            if (err.severity <= maxSeverity) continue;
            maxSeverity = err.severity;
        }
        if (maxSeverity == -1) {
            return IndexerSpecException.eErrorSeverity.NONE;
        }
        switch (maxSeverity) {
            case 0: {
                return IndexerSpecException.eErrorSeverity.INFO;
            }
            case 1: {
                return IndexerSpecException.eErrorSeverity.WARN;
            }
            case 2: {
                return IndexerSpecException.eErrorSeverity.WARN;
            }
            case 3: {
                return IndexerSpecException.eErrorSeverity.ERROR;
            }
            case 4: {
                return IndexerSpecException.eErrorSeverity.FATAL;
            }
        }
        return IndexerSpecException.eErrorSeverity.NONE;
    }

    public Record getRec() {
        return this.rec;
    }

    public SolrInputDocument getDoc() {
        return this.doc;
    }

    void setMaxErrLvl(IndexerSpecException.eErrorSeverity errLvl) {
        this.errLvl = IndexerSpecException.eErrorSeverity.max(this.errLvl, errLvl);
    }

    IndexerSpecException.eErrorSeverity getErrLvl() {
        return this.errLvl;
    }

    void addErrLoc(eErrorLocationVal solrError) {
        this.errLocs.add(solrError);
    }

    public static enum eErrorLocationVal {
        MARC_ERROR,
        INDEXING_ERROR,
        SOLR_ERROR;

    }
}

