/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.marc4j.MarcReader;
import org.solrmarc.driver.Indexer;
import org.solrmarc.driver.RecordAndCnt;

public class MarcReaderThread
extends Thread {
    private static final Logger logger = Logger.getLogger(MarcReaderThread.class);
    private final MarcReader reader;
    private final Indexer indexer;
    private final BlockingQueue<RecordAndCnt> readQ;
    private boolean doneReading = false;

    public MarcReaderThread(MarcReader reader, Indexer indexer, BlockingQueue<RecordAndCnt> readQ, AtomicInteger[] cnts) {
        super("MarcReader-Thread");
        this.reader = reader;
        this.indexer = indexer;
        this.readQ = readQ;
    }

    @Override
    public void run() {
        RecordAndCnt recordAndCnt = null;
        while (!Thread.currentThread().isInterrupted() && (recordAndCnt = this.indexer.getRecord(this.reader)) != null) {
            logger.debug((Object)("record read : " + recordAndCnt.getRecord().getControlNumber()));
            try {
                this.readQ.put(recordAndCnt);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            this.flushReadQueue(recordAndCnt);
        }
        this.doneReading = true;
    }

    private void flushReadQueue(RecordAndCnt recordAndCnt) {
        ArrayList discardedRecords = new ArrayList();
        this.readQ.drainTo(discardedRecords);
        if (discardedRecords.size() > 0) {
            String id = ((RecordAndCnt)discardedRecords.iterator().next()).getRecord().getControlNumber();
            logger.warn((Object)("Reader Thread: discarding " + discardedRecords.size() + " unprocessed records starting with record: " + id));
        } else {
            String id = recordAndCnt != null && recordAndCnt.getRecord() != null ? recordAndCnt.getRecord().getControlNumber() : "<none>";
            logger.warn((Object)("Reader Thread Interrupted, no records in queue: last record processed was: " + id));
        }
        this.indexer.addToCnt(0, -discardedRecords.size());
    }

    public boolean isDoneReading(boolean shuttingDown) {
        if (shuttingDown && this.doneReading && this.readQ.size() > 0) {
            this.flushReadQueue(null);
        }
        return this.doneReading;
    }

    public boolean isPaused() {
        if (this.reader != null && this.reader.getClass().getName().contains("SQS")) {
            return this.readQ.size() == 0;
        }
        return false;
    }
}

