/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.solrmarc.driver.Boot;

public class LoggerDelegator {
    private static Logger logger = null;
    private static List<Object[]> preLogDebug = new ArrayList<Object[]>();
    private static boolean initialized = false;
    private String className;
    private static final int DEBUG_INT = 10000;
    private static final int INFO_INT = 20000;
    private static final int WARN_INT = 30000;
    private static final int ERROR_INT = 40000;
    private static final int FATAL_INT = 50000;

    public LoggerDelegator(String className) {
        this.className = className;
    }

    public LoggerDelegator(Class<?> clazz) {
        this(clazz.getName());
    }

    public static void reInit(String[] homeDirs) {
        String[] arrayOfString = homeDirs;
        int j = homeDirs.length;
        for (int i = 0; i < j; ++i) {
            String dir = arrayOfString[i];
            File log4jProps = new File(dir, "log4j.properties");
            if (!log4jProps.exists()) continue;
            try {
                Class<?> propManClazz = Boot.classForName("org.apache.log4j.LogManager");
                propManClazz.getMethod("resetConfiguration", new Class[0]).invoke(null, new Object[0]);
                Class<?> propConfigClazz = Boot.classForName("org.apache.log4j.PropertyConfigurator");
                propConfigClazz.getMethod("configure", String.class).invoke(null, log4jProps.getAbsolutePath());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            initialized = true;
            break;
        }
        LoggerDelegator.flushToLog();
    }

    public static void flushToLog() {
        try {
            Boot.classForName("org.apache.log4j.Logger");
            if (!initialized) {
                BasicConfigurator.configure();
            }
            for (Object[] msg : preLogDebug) {
                logger = Logger.getLogger((String)msg[0].toString());
                int level = (Integer)msg[1];
                String levelStr = LoggerDelegator.levelToString(level);
                Object msgStr = msg[2];
                Object levelObj = LoggerDelegator.intToLevel(level);
                StackTraceElement stack = (StackTraceElement)msg[5];
                String callerFQCN = "";
                String threadName = msg[4].toString();
                String loggerClass = stack.getFileName();
                String delegatedMsg = "(" + loggerClass + ":" + stack.getLineNumber() + ") - " + msgStr;
                Method logMethod = logger.getClass().getMethod("log", String.class, Boot.classForName("org.apache.log4j.Priority"), Object.class, Throwable.class);
                logMethod.invoke((Object)logger, callerFQCN, levelObj, delegatedMsg, msg[3]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException ncd) {
            for (Object[] msg : preLogDebug) {
                String loggerClass = msg[0].toString();
                int level = (Integer)msg[1];
                String levelStr = LoggerDelegator.levelToString(level);
                Object msgStr = msg[2];
                String threadName = msg[4].toString();
                StackTraceElement stack = (StackTraceElement)msg[5];
                System.err.println(levelStr + " [" + threadName + "] (" + stack.getFileName() + ":" + stack.getLineNumber() + ") - " + msgStr);
                if (msg[3] == null) continue;
                Throwable th = (Throwable)msg[3];
                th.printStackTrace(System.err);
            }
        }
    }

    private static String levelToString(int level) {
        switch (level) {
            case 10000: {
                return "DEBUG";
            }
            case 20000: {
                return "INFO";
            }
            case 30000: {
                return "WARN";
            }
            case 40000: {
                return "ERROR";
            }
            case 50000: {
                return "FATAL";
            }
        }
        return "UNKNOWN";
    }

    private static Object intToLevel(int level) {
        Object levelObj = null;
        try {
            Class<?> clazz = Boot.classForName("org.apache.log4j.Level");
            Method method = clazz.getMethod("toLevel", Integer.TYPE);
            levelObj = method.invoke(null, level);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return levelObj;
    }

    private void push(int level, Object message, Throwable th) {
        Object[] msg = new Object[6];
        String threadName = Thread.currentThread().getName();
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        msg[0] = this.className;
        msg[1] = level;
        msg[2] = message;
        msg[3] = th;
        msg[4] = threadName;
        msg[5] = stack.length > 3 ? stack[3] : null;
        preLogDebug.add(msg);
    }

    private boolean log4jexists() {
        try {
            Boot.classForName("org.apache.log4j.LogManager");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private void delegateMessageToLog4j(int level, Object message, Throwable th) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String callingClassname = stack[3].getClassName();
        if (callingClassname.contains("$")) {
            callingClassname = callingClassname.replaceFirst("\\$.*$", "");
        }
        try {
            Class<?> loggerClazz = Boot.classForName("org.apache.log4j.Logger");
            Object logger = loggerClazz.getMethod("getLogger", String.class).invoke(null, callingClassname);
            Method logMethod = logger.getClass().getMethod("log", String.class, Boot.classForName("org.apache.log4j.Priority"), Object.class, Throwable.class);
            String callerFQCN = "org.solrmarc.driver.LoggerDelegator";
            Object levelObj = LoggerDelegator.intToLevel(level);
            logMethod.invoke(logger, callerFQCN, levelObj, message, th);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void debug(Object message) {
        if (!this.log4jexists() || !initialized) {
            this.push(10000, message, null);
        } else {
            this.delegateMessageToLog4j(10000, message, null);
        }
    }

    public void info(Object message) {
        if (!this.log4jexists() || !initialized) {
            this.push(20000, message, null);
        } else {
            this.delegateMessageToLog4j(20000, message, null);
        }
    }

    public void warn(Object message) {
        if (!this.log4jexists() || !initialized) {
            this.push(30000, message, null);
        } else {
            this.delegateMessageToLog4j(30000, message, null);
        }
    }

    public void error(Object message) {
        if (!this.log4jexists() || !initialized) {
            this.push(40000, message, null);
        } else {
            this.delegateMessageToLog4j(40000, message, null);
        }
    }

    public void fatal(Object message) {
        if (!this.log4jexists() || !initialized) {
            this.push(50000, message, null);
        } else {
            this.delegateMessageToLog4j(50000, message, null);
        }
    }

    public void fatal(Object message, Throwable th) {
        if (!this.log4jexists() || !initialized) {
            this.push(50000, message, th);
        } else {
            this.delegateMessageToLog4j(50000, message, th);
        }
    }

    public void info_multi(String string) {
        String[] lines;
        for (String line : lines = string.split("\n")) {
            this.info(line);
        }
    }
}

