/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.marc4j.marc.Record;
import org.solrmarc.driver.Indexer;
import org.solrmarc.driver.MarcReaderThread;
import org.solrmarc.driver.RecordAndCnt;
import org.solrmarc.driver.RecordAndDoc;
import org.solrmarc.tools.SolrMarcIndexerException;

public class IndexerWorker
implements Runnable {
    private static final Logger logger = Logger.getLogger(IndexerWorker.class);
    private final BlockingQueue<RecordAndCnt> readQ;
    private final BlockingQueue<RecordAndDoc> docQ;
    private Indexer indexer;
    private MarcReaderThread readerThread;
    private int threadCount;
    private boolean doneWorking = false;
    private boolean interrupted = false;

    public IndexerWorker(MarcReaderThread readerThread, BlockingQueue<RecordAndCnt> readQ, BlockingQueue<RecordAndDoc> docQ, Indexer indexer, int threadCount) {
        this.readerThread = readerThread;
        this.readQ = readQ;
        this.docQ = docQ;
        this.indexer = indexer;
        this.threadCount = threadCount;
        this.doneWorking = false;
    }

    public boolean isDoneWorking() {
        return this.doneWorking;
    }

    public void setInterrupted() {
        this.interrupted = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void run() {
        if (this.threadCount > 0) {
            this.indexer = this.threadCount == 0 ? this.indexer : this.indexer.makeThreadSafeCopy();
        }
        Thread.currentThread().setName("RecordIndexer-Thread-" + this.threadCount);
        while (!(this.readerThread.isDoneReading(false) && this.readQ.isEmpty() || this.readerThread.isInterrupted() || this.isInterrupted())) {
            try {
                RecordAndCnt recordAndCnt = this.readQ.poll(100L, TimeUnit.MILLISECONDS);
                if (recordAndCnt == null) continue;
                int count = recordAndCnt.getCnt();
                Record record = recordAndCnt.getRecord();
                if (this.isInterrupted()) break;
                RecordAndDoc recDoc = null;
                try {
                    recDoc = this.indexer.getIndexDoc(record, count);
                }
                catch (SolrMarcIndexerException smie) {
                    this.indexer.shutDown(false);
                    break;
                }
                if (recDoc == null) continue;
                if (this.isInterrupted()) break;
                try {
                    this.docQ.put(recDoc);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Interrupted while waiting for a record to appear in the read queue.");
                this.interrupted = true;
                Thread.currentThread().interrupt();
            }
        }
        this.doneWorking = true;
    }
}

