/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.marc4j.MarcError;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.marc.Record;
import org.solrmarc.driver.Boot;
import org.solrmarc.driver.RecordAndCnt;
import org.solrmarc.driver.RecordAndDoc;
import org.solrmarc.index.indexer.AbstractValueIndexer;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.indexer.ValueIndexerFactory;
import org.solrmarc.solr.SolrProxy;
import org.solrmarc.solr.SolrRuntimeException;
import org.solrmarc.tools.SolrMarcDataException;
import org.solrmarc.tools.SolrMarcIndexerException;

public class Indexer {
    private static final Logger logger = Logger.getLogger(Indexer.class);
    private static final Logger dataExceptionlogger = Logger.getLogger(SolrMarcDataException.class);
    protected final List<AbstractValueIndexer<?>> indexers;
    protected SolrProxy solrProxy;
    protected final BlockingQueue<RecordAndDoc> errQ;
    protected final BlockingQueue<String> delQ;
    protected boolean shuttingDown = false;
    protected boolean viaInterrupt = false;
    protected boolean isShutDown = false;
    protected Thread theReaderThread = null;
    protected int trackOverallProgress = -1;
    protected int lastProgress = 0;
    private int[] cnts = new int[]{0, 0, 0};
    EnumSet<eErrorHandleVal> errHandle = EnumSet.noneOf(eErrorHandleVal.class);

    public Indexer(List<AbstractValueIndexer<?>> indexers, SolrProxy solrProxy) {
        this.indexers = indexers;
        this.solrProxy = solrProxy;
        this.errQ = new LinkedBlockingQueue<RecordAndDoc>();
        this.delQ = new LinkedBlockingQueue<String>();
        try {
            this.trackOverallProgress = Integer.parseInt(System.getProperty("solrmarc.track.progress", "-1"));
        }
        catch (NumberFormatException nfe) {
            this.trackOverallProgress = Boolean.parseBoolean(System.getProperty("solrmarc.track.progress", "false")) ? 10000 : -1;
        }
    }

    protected Indexer(Indexer toClone) {
        this.indexers = new ArrayList();
        for (AbstractValueIndexer<?> indexer : toClone.indexers) {
            this.indexers.add(ValueIndexerFactory.makeThreadSafeCopy(indexer));
        }
        this.solrProxy = toClone.solrProxy;
        this.errQ = toClone.errQ;
        this.delQ = toClone.delQ;
        this.errHandle = toClone.errHandle;
    }

    protected Indexer makeThreadSafeCopy() {
        return new Indexer(this);
    }

    boolean isSet(eErrorHandleVal val) {
        return this.errHandle.contains((Object)val);
    }

    void setErr(eErrorHandleVal val) {
        this.errHandle.add(val);
    }

    public int[] indexToSolr(MarcReader reader) {
        RecordAndCnt recordAndCnt;
        this.resetCnts();
        this.theReaderThread = Thread.currentThread();
        while (!this.shuttingDown && (recordAndCnt = this.getRecord(reader)) != null) {
            logger.debug((Object)("record read : " + recordAndCnt.getRecord().getControlNumber()));
            RecordAndDoc recDoc = null;
            try {
                recDoc = this.getIndexDoc(recordAndCnt.getRecord(), recordAndCnt.getCnt());
            }
            catch (SolrMarcIndexerException smie) {
                break;
            }
            if (recDoc != null) {
                this.indexSingleDocument(recDoc);
            }
            int curProgress = this.cnts[2];
            if (this.trackOverallProgress <= 0 || curProgress <= this.lastProgress + this.trackOverallProgress) continue;
            this.lastProgress = curProgress;
            logger.info((Object)("Indexer current progress: " + curProgress + " records"));
        }
        if (this.shuttingDown) {
            this.endProcessing();
        }
        return this.cnts;
    }

    protected void indexSingleDocument(RecordAndDoc recDoc) {
        try {
            if (recDoc.getDoc() != null) {
                this.solrProxy.addDoc(recDoc);
                this.incrementCnt(2);
                if (recDoc.getErrLvl() != IndexerSpecException.eErrorSeverity.NONE && this.isSet(eErrorHandleVal.RETURN_ERROR_RECORDS) && this.isSet(eErrorHandleVal.RETURN_ERROR_RECORDS)) {
                    this.errQ.add(recDoc);
                }
            }
        }
        catch (SolrRuntimeException sse) {
            this.singleRecordSolrError(recDoc, sse, this.errQ);
        }
        catch (Exception e) {
            this.singleRecordSolrError(recDoc, e, this.errQ);
        }
    }

    void resetCnts() {
        this.cnts[2] = 0;
        this.cnts[1] = 0;
        this.cnts[0] = 0;
    }

    int incrementCnt(int cntNum) {
        int n = cntNum;
        int n2 = this.cnts[n] + 1;
        this.cnts[n] = n2;
        return n2;
    }

    int addToCnt(int cntNum, int amount) {
        int n = cntNum;
        this.cnts[n] = this.cnts[n] + amount;
        return this.cnts[cntNum];
    }

    int[] getCounts() {
        return this.cnts;
    }

    public RecordAndCnt getRecord(MarcReader reader) {
        Record record = null;
        while (record == null) {
            try {
                if (reader.hasNext()) {
                    record = reader.next();
                    continue;
                }
                return null;
            }
            catch (MarcException me) {
                logger.error((Object)"Unrecoverable Error in MARC record data", (Throwable)me);
                if (Boolean.parseBoolean(System.getProperty("solrmarc.terminate.on.marc.exception", "true"))) {
                    return null;
                }
                logger.warn((Object)"Trying to continue after MARC record data error");
                record = null;
            }
            catch (Exception e) {
                logger.error((Object)"Unknown Error in MARC record data", (Throwable)e);
                if (Boolean.parseBoolean(System.getProperty("solrmarc.terminate.on.marc.exception", "true"))) {
                    return null;
                }
                logger.warn((Object)"Trying to continue after MARC record data error");
                record = null;
            }
        }
        int cnt = this.incrementCnt(0);
        return new RecordAndCnt(record, cnt);
    }

    public RecordAndDoc getIndexDoc(Record record, int count) {
        RecordAndDoc recDoc = null;
        recDoc = this.indexToSolrDoc(record);
        if (recDoc.getSolrMarcIndexerException() != null) {
            String idMessage;
            SolrMarcIndexerException smie = recDoc.getSolrMarcIndexerException();
            String recCtrlNum = recDoc.rec.getControlNumber();
            String string = idMessage = smie.getMessage() != null ? smie.getMessage() : "";
            if (smie.getLevel() == 1) {
                logger.info((Object)("Record will be Ignored " + (recCtrlNum != null ? recCtrlNum : "") + " " + idMessage + " (record count " + count + ")"));
                return null;
            }
            if (smie.getLevel() == 2) {
                logger.info((Object)("Record will be Deleted " + (recCtrlNum != null ? recCtrlNum : "") + " " + idMessage + " (record count " + count + ")"));
                this.delQ.add(recCtrlNum);
                return null;
            }
            if (smie.getLevel() == 3) {
                logger.info((Object)("Serious Error flagged in record " + (recCtrlNum != null ? recCtrlNum : "") + " " + idMessage + " (record count " + count + ")"));
                logger.info((Object)"Terminating indexing.");
                throw new SolrMarcIndexerException(3);
            }
        }
        if (recDoc.getErrLvl() != IndexerSpecException.eErrorSeverity.NONE) {
            if (this.isSet(eErrorHandleVal.RETURN_ERROR_RECORDS) && !this.isSet(eErrorHandleVal.INDEX_ERROR_RECORDS)) {
                this.errQ.add(recDoc);
            }
            if (recDoc.getErrLvl() == IndexerSpecException.eErrorSeverity.FATAL && recDoc.ise != null) {
                String recCtrlNum = recDoc.rec.getControlNumber();
                String idMessage = recDoc.ise.getMessage() != null ? recDoc.ise.getMessage() : "";
                String indSpec = recDoc.ise.getSpecMessage() != null ? recDoc.ise.getSpecMessage() : "";
                logger.info((Object)("Fatal Error returned for record " + (recCtrlNum != null ? recCtrlNum : "") + " : " + idMessage + " (record count " + count + ")"));
                logger.info((Object)("Fatal Error from by index spec  " + (recCtrlNum != null ? recCtrlNum : "") + " : " + indSpec + " (record count " + count + ")"));
                logger.info((Object)"Terminating indexing.");
                throw new SolrMarcIndexerException(3);
            }
            if (!this.isSet(eErrorHandleVal.INDEX_ERROR_RECORDS)) {
                logger.debug((Object)("Skipping error record: " + recDoc.rec.getControlNumber()));
                return null;
            }
        }
        this.incrementCnt(1);
        return recDoc;
    }

    protected SolrInputDocument combineDocWithErrors(SolrInputDocument[] documentParts, boolean includeErrors) {
        SolrInputDocument result = documentParts[0];
        if (includeErrors) {
            if (!documentParts[1].isEmpty()) {
                result.putAll((Map)documentParts[1]);
            }
            if (!documentParts[2].isEmpty()) {
                result.putAll((Map)documentParts[2]);
            }
        }
        return result;
    }

    private IndexerSpecException.eErrorSeverity addExceptionsToMap(SolrInputDocument document, Collection<IndexerSpecException> perRecordExceptions, IndexerSpecException.eErrorSeverity errLvl) {
        if (perRecordExceptions != null) {
            for (IndexerSpecException e : perRecordExceptions) {
                String specMessage = e.getSpecMessage();
                document.addField("marc_error", (Object)e.getMessage());
                errLvl = IndexerSpecException.eErrorSeverity.max(errLvl, e.getErrLvl());
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    document.addField("marc_error", (Object)(e.getSolrField() + " : " + cause.getMessage()));
                }
            }
        }
        return errLvl;
    }

    private void addMarcErrorsToMap(SolrInputDocument document, List<MarcError> errors) {
        for (MarcError err : errors) {
            document.addField("marc_error", (Object)err.toString());
        }
    }

    protected RecordAndDoc indexToSolrDoc(Record record) {
        Set<IndexerSpecException> perRecordExceptions;
        LinkedHashMap emptyMap = new LinkedHashMap();
        SolrInputDocument[] inputDocs = new SolrInputDocument[]{new SolrInputDocument(emptyMap), new SolrInputDocument(emptyMap), new SolrInputDocument(emptyMap)};
        RecordAndDoc recDoc = new RecordAndDoc(record);
        IndexerSpecException.eErrorSeverity errLvl = IndexerSpecException.eErrorSeverity.NONE;
        ValueIndexerFactory.instance().clearPerRecordErrors();
        for (AbstractValueIndexer<?> indexer : this.indexers) {
            try {
                if (indexer.getOnlyIfEmpty()) {
                    String fieldname = indexer.getSolrFieldNames().iterator().next();
                    if (indexer.getSolrFieldNames().size() == 1 && inputDocs[0].containsKey((Object)fieldname)) continue;
                }
                Collection<String> data = indexer.getFieldData(record);
                for (String fieldName : indexer.getSolrFieldNames()) {
                    if (data.size() == 0 || indexer.getOnlyIfEmpty() && inputDocs[0].containsKey((Object)fieldName)) continue;
                    for (String dataVal : data) {
                        Collection values;
                        if (indexer.getOnlyIfUnique() && (values = inputDocs[0].getFieldValues(fieldName)) != null && values.contains(dataVal)) continue;
                        inputDocs[0].addField(fieldName, (Object)dataVal);
                    }
                }
            }
            catch (OutOfMemoryError oome) {
                logger.error((Object)("OOMError in record: " + recDoc.rec.getControlNumber()));
                logger.error((Object)("while processing index specification: " + indexer.getSpecLabel()));
                logger.error((Object)("number of per record exceptions: " + (ValueIndexerFactory.instance().getPerRecordErrors() != null ? ValueIndexerFactory.instance().getPerRecordErrors().size() : 0)));
                inputDocs[2].addField("marc_error", (Object)(indexer.getSolrFieldNames().toString() + oome.getMessage()));
                errLvl = IndexerSpecException.eErrorSeverity.FATAL;
                recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.INDEXING_ERROR);
            }
            catch (InvocationTargetException ioe) {
                Throwable wrapped = ioe.getTargetException();
                if (wrapped != null && wrapped instanceof IndexerSpecException) {
                    logger.debug((Object)("Exception in record: " + recDoc.rec.getControlNumber()));
                    logger.debug((Object)("while processing index specification: " + indexer.getSpecLabel()));
                    errLvl = IndexerSpecException.eErrorSeverity.max(errLvl, ((IndexerSpecException)wrapped).getErrLvl());
                    ((IndexerSpecException)wrapped).setSolrFieldAndSpec(indexer.getSolrFieldNamesStr(), indexer.getSpecLabel());
                    recDoc.setIndexerSpecException((IndexerSpecException)wrapped);
                } else if (wrapped != null && wrapped instanceof OutOfMemoryError) {
                    logger.error((Object)("OOMError in record: " + recDoc.rec.getControlNumber()));
                    logger.error((Object)("while processing index specification: " + indexer.getSpecLabel()));
                    inputDocs[2].addField("marc_error", (Object)(indexer.getSolrFieldNames().toString() + wrapped.getMessage()));
                    errLvl = IndexerSpecException.eErrorSeverity.FATAL;
                    recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.INDEXING_ERROR);
                } else if (wrapped != null && wrapped instanceof SolrMarcDataException) {
                    SolrMarcDataException.eDataErrorLevel level = ((SolrMarcDataException)wrapped).getLevel();
                    Priority priority = this.levelToPriority(level);
                    dataExceptionlogger.log(priority, (Object)("Data Exception in record: " + recDoc.rec.getControlNumber()));
                    dataExceptionlogger.log(priority, (Object)(" while processing index specification: " + indexer.getSpecLabel()));
                    if (wrapped != null) {
                        dataExceptionlogger.log(priority, (Object)wrapped.getMessage());
                    }
                    errLvl = this.levelToSeverity(level);
                } else if (wrapped != null && wrapped instanceof IllegalArgumentException) {
                    logger.warn((Object)("Exception in record: " + recDoc.rec.getControlNumber()));
                    logger.warn((Object)("while processing index specification: " + indexer.getSpecLabel()));
                    if (wrapped != null) {
                        logger.debug((Object)wrapped);
                    }
                    errLvl = IndexerSpecException.eErrorSeverity.ERROR;
                } else {
                    logger.warn((Object)("Exception in record: " + recDoc.rec.getControlNumber()));
                    logger.warn((Object)("while processing index specification: " + indexer.getSpecLabel()));
                    if (wrapped != null) {
                        logger.warn((Object)wrapped);
                    }
                    errLvl = IndexerSpecException.eErrorSeverity.ERROR;
                }
                inputDocs[2].addField("marc_error", (Object)(indexer.getSolrFieldNames().toString() + wrapped.getMessage()));
                recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.INDEXING_ERROR);
            }
            catch (SolrMarcIndexerException e) {
                recDoc.setSolrMarcIndexerException(e);
            }
            catch (IndexerSpecException e) {
                logger.warn((Object)("Exception in record: " + recDoc.rec.getControlNumber()));
                logger.warn((Object)("while processing index specification: " + indexer.getSpecLabel()));
                inputDocs[2].addField("marc_error", (Object)(indexer.getSolrFieldNames().toString() + e.getMessage()));
                errLvl = IndexerSpecException.eErrorSeverity.max(errLvl, e.getErrLvl());
                recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.INDEXING_ERROR);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception in record: " + recDoc.rec.getControlNumber()));
                logger.warn((Object)("while processing index specification: " + indexer.getSpecLabel()));
                boolean targetError = false;
                try {
                    Class<?> targetErrorClazz = Boot.classForName("bsh.TargetError");
                    if (targetErrorClazz.isInstance(e)) {
                        targetError = true;
                        inputDocs[2].addField("marc_error", (Object)(indexer.getSolrFieldNames().toString() + e.toString()));
                        errLvl = IndexerSpecException.eErrorSeverity.ERROR;
                        recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.INDEXING_ERROR);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (targetError) continue;
                inputDocs[2].addField("marc_error", (Object)(indexer.getSolrFieldNames().toString() + e.getMessage()));
                errLvl = IndexerSpecException.eErrorSeverity.ERROR;
                recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.INDEXING_ERROR);
            }
        }
        if (record.hasErrors()) {
            this.addMarcErrorsToMap(inputDocs[1], record.getErrors());
            recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.MARC_ERROR);
        }
        if ((perRecordExceptions = ValueIndexerFactory.instance().getPerRecordErrors()) != null) {
            errLvl = this.addExceptionsToMap(inputDocs[2], perRecordExceptions, errLvl);
            recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.INDEXING_ERROR);
        }
        recDoc.setDoc(this.combineDocWithErrors(inputDocs, this.isSet(eErrorHandleVal.INDEX_ERROR_RECORDS)));
        recDoc.setMaxErrLvl(errLvl);
        ValueIndexerFactory.instance().doneWithRecord(record);
        return recDoc;
    }

    private IndexerSpecException.eErrorSeverity levelToSeverity(SolrMarcDataException.eDataErrorLevel level) {
        switch (level) {
            case TRACE: {
                return IndexerSpecException.eErrorSeverity.NONE;
            }
            case DEBUG: {
                return IndexerSpecException.eErrorSeverity.NONE;
            }
            case INFO: {
                return IndexerSpecException.eErrorSeverity.INFO;
            }
            case WARN: {
                return IndexerSpecException.eErrorSeverity.WARN;
            }
            case ERROR: {
                return IndexerSpecException.eErrorSeverity.ERROR;
            }
            case FATAL: {
                return IndexerSpecException.eErrorSeverity.FATAL;
            }
        }
        return IndexerSpecException.eErrorSeverity.WARN;
    }

    private Priority levelToPriority(SolrMarcDataException.eDataErrorLevel level) {
        switch (level) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case FATAL: {
                return Level.FATAL;
            }
        }
        return Level.WARN;
    }

    protected void singleRecordSolrError(RecordAndDoc recDoc, Exception e1, BlockingQueue<RecordAndDoc> errQ) {
        logger.error((Object)("Failed on single doc with id : " + recDoc.getRec().getControlNumber()));
        if (e1 instanceof SolrRuntimeException && e1.getCause() instanceof SolrException) {
            SolrException cause = (SolrException)e1.getCause();
            logger.error((Object)cause.getMessage());
        } else if (e1 instanceof SolrRuntimeException && e1.getCause() instanceof InvocationTargetException) {
            InvocationTargetException cause = (InvocationTargetException)e1.getCause();
            Throwable target = cause.getTargetException();
            logger.error((Object)target.getMessage());
        } else {
            logger.error((Object)e1);
        }
        if (errQ != null) {
            recDoc.addErrLoc(RecordAndDoc.eErrorLocationVal.SOLR_ERROR);
            recDoc.errLvl = IndexerSpecException.eErrorSeverity.ERROR;
            errQ.add(recDoc);
        }
    }

    boolean isShutDown() {
        return this.isShutDown;
    }

    void setIsShutDown() {
        this.isShutDown = true;
    }

    void shutDown(boolean viaInterrupt) {
        this.viaInterrupt = viaInterrupt;
        if (viaInterrupt && this.theReaderThread != null) {
            this.theReaderThread.interrupt();
        }
        this.shuttingDown = true;
    }

    void endProcessing() {
        boolean commitAtEnd = Boolean.parseBoolean(System.getProperty("solrmarc.commit.at.end", "true"));
        if (this.delQ.size() > 0) {
            logger.info((Object)("Deleting " + this.delQ.size() + " records "));
        }
        for (String recCtrlNum : this.delQ) {
            logger.debug((Object)("Deleting record " + (recCtrlNum != null ? recCtrlNum : "")));
            try {
                this.solrProxy.delete(recCtrlNum);
            }
            catch (SolrRuntimeException e) {
                e.printStackTrace();
            }
        }
        try {
            if (commitAtEnd) {
                logger.info((Object)"Commmiting updates to Solr");
                this.solrProxy.commit(false);
            } else {
                logger.info((Object)"Not commmiting updates to Solr");
            }
        }
        catch (SolrRuntimeException solrRuntimeException) {
            // empty catch block
        }
    }

    private static long time(long time, TimeUnit unit) {
        return unit.convert(time, TimeUnit.NANOSECONDS);
    }

    void reportPerMethodTime() {
        logger.info((Object)"Elapsed time per indexing method:");
        for (AbstractValueIndexer<?> indexer : this.indexers) {
            long elaspedTime = indexer.getTotalElapsedTime();
            long minutes = Indexer.time(elaspedTime, TimeUnit.MINUTES);
            long seconds = Indexer.time(elaspedTime, TimeUnit.SECONDS);
            long millis = Indexer.time(elaspedTime, TimeUnit.MILLISECONDS);
            millis -= seconds * 1000L;
            String elapsedStr = String.format("%d min, %d.%03d sec", minutes, seconds -= minutes * 60L, millis);
            logger.info((Object)(elapsedStr + "  ---" + indexer.getSolrFieldNames().toString() + ":" + indexer.getSpecLabel()));
        }
    }

    public static enum eErrorHandleVal {
        RETURN_ERROR_RECORDS,
        INDEX_ERROR_RECORDS;

    }
}

