/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import joptsimple.OptionSet;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.marc4j.MarcReader;
import org.marc4j.MarcReaderConfig;
import org.marc4j.MarcReaderFactory;
import org.solrmarc.driver.BootableMain;
import org.solrmarc.driver.Indexer;
import org.solrmarc.driver.RecordAndDoc;
import org.solrmarc.driver.ThreadedIndexer;
import org.solrmarc.index.indexer.AbstractValueIndexer;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.indexer.ValueIndexerFactory;
import org.solrmarc.marc.SolrMarcMarcReaderFactory;
import org.solrmarc.solr.DevNullProxy;
import org.solrmarc.solr.SolrCoreLoader;
import org.solrmarc.solr.SolrProxy;
import org.solrmarc.solr.SolrRuntimeException;
import org.solrmarc.solr.StdOutProxy;
import org.solrmarc.solr.XMLOutProxy;
import org.solrmarc.tools.PropertyUtils;

public class IndexDriver
extends BootableMain {
    private static Logger logger = null;
    protected Properties readerProps;
    protected MarcReaderConfig readerConfig;
    protected ValueIndexerFactory indexerFactory = null;
    protected List<AbstractValueIndexer<?>> indexers;
    protected Indexer indexer;
    protected MarcReader reader;
    protected SolrProxy solrProxy;
    protected int[] numIndexed;
    protected String[] args;
    protected long startTime;
    protected Thread shutdownSimulator = null;
    static final String[] solrmarcPropertyStrings = new String[]{"solrmarc.indexer.chunksize", "solrmarc.indexer.buffersize", "solrmarc.indexer.threadcount", "solrmarc.solrj.threadcount", "solrmarc.track.solr.progress", "solrmarc.terminate.on.marc.exception", "solrmarc.output.redirect", "solrmarc.indexer.test.fire.method", "solrmarc.method.report"};

    public static void main(String[] args) {
        IndexDriver driver = new IndexDriver(args);
        driver.execute();
    }

    public IndexDriver(String[] args) {
        logger = Logger.getLogger(IndexDriver.class);
        this.args = args;
    }

    public void execute() {
        this.processArgs(this.args, true);
        this.indexerFactory = ValueIndexerFactory.initialize(this.homeDirStrs);
        this.initializeFromOptions();
        List inputFiles = this.options.valuesOf(this.files);
        logger.info((Object)("Opening input files: " + Arrays.toString(inputFiles.toArray())));
        this.configureReader(inputFiles);
        if (this.deleteRecordByIdFile.value(this.options) != null) {
            this.processDeletes();
        }
        this.processInput();
    }

    private void processDeletes() {
        File deleteFile = (File)this.deleteRecordByIdFile.value(this.options);
        if (deleteFile.exists() && deleteFile.canRead()) {
            try {
                String line;
                BufferedReader delReader = new BufferedReader(new FileReader(deleteFile));
                while ((line = delReader.readLine()) != null) {
                    this.indexer.delQ.add(line.trim());
                }
                delReader.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void initializeFromOptions() {
        String[] inputSource = new String[1];
        String propertyFileAsURLStr = PropertyUtils.getPropertyFileAbsoluteURL(this.homeDirStrs, (String)this.options.valueOf(this.readOpts), true, inputSource);
        try {
            this.configureReaderProps(propertyFileAsURLStr);
        }
        catch (IOException e1) {
            logger.fatal((Object)("Fatal error: Exception opening reader properties input stream: " + inputSource[0]));
            logger.error((Object)"Exiting...");
            System.exit(1);
        }
        boolean multithread = this.options.has("solrURL") && !this.options.has("debug");
        try {
            this.configureOutput(this.options);
        }
        catch (SolrRuntimeException sre) {
            logger.debug((Object)"", (Throwable)sre);
            logger.error((Object)"Exiting...");
            System.exit(6);
        }
        String specs = (String)this.options.valueOf(this.configSpecs);
        try {
            logger.info((Object)("Reading and compiling index specifications: " + specs));
            this.configureIndexer(specs, multithread);
        }
        catch (IOException | IllegalAccessException | InstantiationException e1) {
            logger.error((Object)("Error opening or reading index configurations: " + specs), (Throwable)e1);
            logger.error((Object)"Exiting...");
            System.exit(2);
        }
        List<IndexerSpecException> exceptions = this.indexerFactory.getValidationExceptions();
        if (!exceptions.isEmpty()) {
            logger.error((Object)("Error processing index configurations: " + specs));
            this.logTextForExceptions(exceptions);
            logger.error((Object)"Exiting...");
            System.exit(5);
        }
    }

    private void configureReaderProps(String propertyFileURLStr) throws FileNotFoundException, IOException {
        List<String> propertyStringsToCopy = Arrays.asList(solrmarcPropertyStrings);
        this.readerProps = new Properties();
        if (propertyFileURLStr != null) {
            this.readerProps.load(PropertyUtils.getPropertyFileInputStream(propertyFileURLStr));
            Enumeration<?> iter = this.readerProps.propertyNames();
            while (iter.hasMoreElements()) {
                String propertyName = iter.nextElement().toString();
                if (propertyName.startsWith("solrmarc.") && propertyStringsToCopy.contains(propertyName) && System.getProperty(propertyName) == null) {
                    System.setProperty(propertyName, this.readerProps.getProperty(propertyName));
                }
                if (!propertyName.startsWith("org.marc4j.marc") || System.getProperty(propertyName) != null) continue;
                System.setProperty(propertyName, this.readerProps.getProperty(propertyName));
            }
            try {
                this.readerConfig = new MarcReaderConfig(this.readerProps);
            }
            catch (NoClassDefFoundError ncdfe) {
                this.readerConfig = null;
            }
        }
    }

    private void configureReader(List<String> inputFilenames) {
        try {
            this.reader = MarcReaderFactory.makeReader((MarcReaderConfig)this.readerConfig, (String[])ValueIndexerFactory.instance().getHomeDirs(), inputFilenames);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (NoClassDefFoundError ncdfe) {
            logger.warn((Object)"Using SolrMarc with a marc4j version < 2.8 uses deprecated code in SolrMarc");
            this.reader = SolrMarcMarcReaderFactory.instance().makeReader(this.readerProps, ValueIndexerFactory.instance().getHomeDirs(), inputFilenames);
        }
    }

    protected void configureIndexer(String indexSpecifications, boolean multiThreaded) throws IllegalAccessException, InstantiationException, IOException {
        String[] indexSpecs = indexSpecifications.split("[ ]*[,;][ ]*");
        File[] specFiles = new File[indexSpecs.length];
        int i = 0;
        for (String indexSpec : indexSpecs) {
            File specFile = new File(indexSpec);
            if (!specFile.isAbsolute()) {
                specFile = PropertyUtils.findFirstExistingFile(this.homeDirStrs, indexSpec);
            }
            logger.info((Object)("Opening index spec file: " + specFile));
            specFiles[i++] = specFile;
        }
        this.indexers = this.indexerFactory.createValueIndexers(specFiles);
        boolean includeErrors = Boolean.parseBoolean(PropertyUtils.getProperty(this.readerProps, "marc.include_errors", "false"));
        boolean returnErrors = Boolean.parseBoolean(PropertyUtils.getProperty(this.readerProps, "marc.return_errors", "false"));
        int chunkSize = Integer.parseInt(System.getProperty("solrmarc.indexer.chunksize", "640"));
        int bufferSize = Integer.parseInt(System.getProperty("solrmarc.indexer.buffersize", "640"));
        this.indexer = null;
        this.indexer = multiThreaded ? new ThreadedIndexer(this.indexers, this.solrProxy, bufferSize, chunkSize) : new Indexer(this.indexers, this.solrProxy);
        if (returnErrors) {
            this.indexer.setErr(Indexer.eErrorHandleVal.RETURN_ERROR_RECORDS);
        }
        if (includeErrors) {
            this.indexer.setErr(Indexer.eErrorHandleVal.INDEX_ERROR_RECORDS);
        }
    }

    protected void configureOutput(OptionSet options) {
        String solrURL;
        String solrJClassName = (String)this.solrjClass.value(options);
        String string = options.has("solrURL") ? options.valueOf("solrURL").toString() : (solrURL = options.has("null") ? "devnull" : "stdout");
        if (solrURL.equals("stdout")) {
            try {
                PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
                System.setOut(out);
                this.solrProxy = new StdOutProxy(out);
            }
            catch (UnsupportedEncodingException out) {}
        } else if (solrURL.equals("xml")) {
            try {
                PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
                System.setOut(out);
                this.solrProxy = new XMLOutProxy(out);
            }
            catch (UnsupportedEncodingException out) {}
        } else if (solrURL.equals("devnull")) {
            this.solrProxy = new DevNullProxy();
        } else {
            try {
                this.solrProxy = SolrCoreLoader.loadRemoteSolrServer(solrURL, solrJClassName, true);
            }
            catch (SolrRuntimeException sre) {
                logger.error((Object)("Error connecting to solr at URL " + solrURL + " : " + sre.getMessage()));
                throw sre;
            }
        }
    }

    protected void processInput() {
        String inEclipseStr = System.getProperty("runInEclipse");
        boolean inEclipse = "true".equalsIgnoreCase(inEclipseStr);
        String systemClassPath = System.getProperty("java.class.path");
        logger.debug((Object)("System Class Path = " + systemClassPath));
        if (!systemClassPath.contains("solrmarc_core")) {
            inEclipse = true;
        }
        this.shutdownSimulator = new ShutdownSimulator(inEclipse, this.indexer);
        this.shutdownSimulator.start();
        MyShutdownThread shutdownHook = new MyShutdownThread(this.indexer, this.shutdownSimulator);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        long endTime = this.startTime = System.currentTimeMillis();
        try {
            this.numIndexed = this.indexer.indexToSolr(this.reader);
        }
        catch (Exception e) {
            if (!this.indexer.viaInterrupt) {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            logger.fatal((Object)"ERROR: Error while invoking indexToSolr");
            logger.fatal((Object)e);
        }
        endTime = System.currentTimeMillis();
        if (!this.indexer.viaInterrupt) {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        this.indexer.endProcessing();
        boolean perMethodReport = Boolean.parseBoolean(PropertyUtils.getProperty(this.readerProps, "solrmarc.method.report", "false"));
        this.reportResultsAndTime(this.numIndexed, this.startTime, endTime, this.indexer, this.indexer.shuttingDown ? false : perMethodReport);
        if (!this.indexer.viaInterrupt && this.indexer.errQ.size() > 0) {
            this.handleRecordErrors();
        }
        if (!this.indexer.viaInterrupt && this.shutdownSimulator != null) {
            this.shutdownSimulator.interrupt();
        }
        this.indexer.setIsShutDown();
        if (this.indexer.shuttingDown && this.indexer.viaInterrupt) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                endTime = this.startTime;
            }
        }
    }

    protected void reportResultsAndTime(int[] numIndexed, long startTime, long endTime, Indexer indexer, boolean perMethodReport) {
        logger.info((Object)("" + numIndexed[0] + " records read"));
        logger.info((Object)("" + numIndexed[1] + " records indexed  and "));
        long minutes = (endTime - startTime) / 1000L / 60L;
        long seconds = (endTime - startTime) / 1000L - minutes * 60L;
        long hundredths = (endTime - startTime) / 10L - minutes * 6000L - seconds * 100L + 100L;
        String hundredthsStr = ("" + hundredths).substring(1);
        String minutesStr = minutes > 0L ? "" + minutes + " minute" + (minutes != 1L ? "s " : " ") : "";
        String secondsStr = "" + seconds + "." + hundredthsStr + " seconds";
        logger.info((Object)("" + numIndexed[2] + " records sent to Solr in " + minutesStr + secondsStr));
        if (perMethodReport) {
            indexer.reportPerMethodTime();
        }
    }

    private void handleRecordErrors() {
        BlockingQueue<RecordAndDoc> errQ = this.indexer.errQ;
        int[][] errTypeCnt = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}};
        for (RecordAndDoc entry : errQ) {
            if (!entry.errLocs.isEmpty()) {
                logger.debug((Object)("Error Rec id = " + entry.rec.getControlNumber()));
            }
            if (entry.errLocs.contains((Object)RecordAndDoc.eErrorLocationVal.MARC_ERROR)) {
                int[] nArray = errTypeCnt[0];
                int n = entry.getErrLvl().ordinal();
                nArray[n] = nArray[n] + 1;
            }
            if (entry.errLocs.contains((Object)RecordAndDoc.eErrorLocationVal.INDEXING_ERROR)) {
                int[] nArray = errTypeCnt[1];
                int n = entry.getErrLvl().ordinal();
                nArray[n] = nArray[n] + 1;
            }
            if (!entry.errLocs.contains((Object)RecordAndDoc.eErrorLocationVal.SOLR_ERROR)) continue;
            int[] nArray = errTypeCnt[2];
            int n = entry.getErrLvl().ordinal();
            nArray[n] = nArray[n] + 1;
        }
        this.showErrReport("MARC", errTypeCnt[0]);
        this.showErrReport("Index", errTypeCnt[1]);
        this.showErrReport("Solr", errTypeCnt[2]);
    }

    private void showErrReport(String errLocStr, int[] errorLvlCnt) {
        for (int i = 0; i < errorLvlCnt.length; ++i) {
            if (errorLvlCnt[i] <= 0) continue;
            logger.info((Object)(errorLvlCnt[i] + " records have " + errLocStr + " errors of level: " + IndexerSpecException.eErrorSeverity.values()[i].toString()));
        }
    }

    private String getTextForExceptions(List<IndexerSpecException> exceptions) {
        StringBuilder text = new StringBuilder();
        String lastSpec = "";
        for (IndexerSpecException e : exceptions) {
            String specMessage = e.getSpecMessage();
            if (!specMessage.equals(lastSpec)) {
                text.append(specMessage).append("\n");
            }
            text.append(e.getMessage()).append("\n");
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                text.append(e.getSolrField()).append(" : ").append(cause.getMessage()).append("\n");
            }
        }
        return text.toString();
    }

    protected void logTextForExceptions(List<IndexerSpecException> exceptions) {
        String lastSpec = "";
        for (IndexerSpecException e : exceptions) {
            IndexerSpecException.eErrorSeverity level = e.getErrLvl();
            Priority priority = this.getPriorityForSeverity(level);
            String specMessage = e.getSpecMessage();
            if (!specMessage.equals(lastSpec)) {
                logger.log(priority, (Object)specMessage);
            }
            logger.log(priority, (Object)e.getMessage());
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                logger.log(priority, (Object)(e.getSolrField() + " : " + cause.getMessage()));
            }
        }
    }

    private Priority getPriorityForSeverity(IndexerSpecException.eErrorSeverity level) {
        switch (level) {
            case NONE: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case FATAL: {
                return Level.FATAL;
            }
        }
        return Level.DEBUG;
    }

    class ShutdownSimulator
    extends Thread {
        boolean inEclipse;
        Indexer indexerInUse;

        public ShutdownSimulator(boolean inEclipse, Indexer indexer) {
            this.inEclipse = inEclipse;
            this.indexerInUse = indexer;
        }

        @Override
        public void run() {
            this.setName("Eclipse-Shutdown-Simulator-Thread");
            if (this.inEclipse) {
                System.out.println("You're using Eclipse; click in this console and press ENTER to call System.exit() and run the shutdown routine.");
            }
            try {
                while (true) {
                    if (this.inEclipse && System.in.available() > 0) {
                        System.in.read();
                        if (!(IndexDriver.this.indexer instanceof ThreadedIndexer)) {
                            IndexDriver.this.indexer.shutDown(true);
                        }
                        System.exit(0);
                        continue;
                    }
                    ShutdownSimulator.sleep(2000L);
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
            }
        }
    }

    class MyShutdownThread
    extends Thread {
        private Indexer indexer;
        private Thread killItToDie;

        public MyShutdownThread(Indexer ind, Thread shutdownSimulator) {
            this.indexer = ind;
            this.killItToDie = shutdownSimulator;
        }

        @Override
        public void run() {
            logger.info((Object)"Starting Shutdown hook");
            if (!this.indexer.isShutDown()) {
                logger.info((Object)"Stopping main indexer loop");
                this.indexer.shutDown(true);
            }
            while (!this.indexer.isShutDown()) {
                try {
                    MyShutdownThread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.info((Object)"Finished Shutdown hook");
            LogManager.shutdown();
            try {
                MyShutdownThread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.indexer = null;
            }
            this.killItToDie.interrupt();
        }
    }
}

