/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.solrmarc.driver.Boot;
import org.solrmarc.driver.BootableMain;
import org.solrmarc.driver.LoggerDelegator;
import org.solrmarc.tools.PropertyUtils;
import org.solrmarc.tools.Utils;

public class ConfigDriver
extends BootableMain {
    private static LoggerDelegator logger = new LoggerDelegator(ConfigDriver.class);

    public static void main(String[] args) {
        String[] stringArray;
        String[] urlArg;
        String[] stringArray2;
        String[] stringArray3;
        String configProps = args[0];
        logger.debug("Using config " + configProps + " to initialize SolrMarc");
        String homeDirStr = Boot.getDefaultHomeDir();
        String configDirStr = null;
        File configFile = new File(configProps);
        boolean configEqHomeDir = false;
        if (configFile.exists()) {
            configDirStr = configFile.getAbsoluteFile().getParentFile().getAbsolutePath();
            configEqHomeDir = configDirStr.equals(homeDirStr);
        } else if (!configFile.isAbsolute()) {
            configFile = new File(homeDirStr, configProps);
            configEqHomeDir = true;
        }
        Properties configProperties = new Properties();
        try {
            configProperties.load(new FileInputStream(configFile.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            logger.fatal("Unable to find old-style solrmarc config file named: " + configFile.getAbsolutePath());
            LoggerDelegator.flushToLog();
            System.exit(2);
        }
        catch (IOException e) {
            logger.fatal("Unable to read old-style solrmarc config file named: " + configFile.getAbsolutePath());
            LoggerDelegator.flushToLog();
            System.exit(2);
        }
        String marcreaderProperties = configFile.getName();
        String solrHosturl = PropertyUtils.getProperty(configProperties, "solr.hosturl");
        String solrCommit = PropertyUtils.getProperty(configProperties, "solrmarc.commit.at.end");
        String solrIndexerProperties = PropertyUtils.getProperty(configProperties, "solr.indexer.properties");
        String solrmarcPath = PropertyUtils.getProperty(configProperties, "solrmarc.path");
        if (configDirStr != null) {
            String localDirStr;
            File localDir = new File(".");
            try {
                localDirStr = localDir.getCanonicalPath();
            }
            catch (IOException ioe) {
                localDirStr = localDir.getAbsolutePath();
            }
            Path pathAbsolute = Paths.get(configDirStr, new String[0]);
            Path pathBase = Paths.get(localDirStr, new String[0]);
            Path pathRelative = pathBase.relativize(pathAbsolute);
            String dirParm = pathRelative.toString();
            if (pathRelative.toString().length() == 0 && !configEqHomeDir) {
                dirParm = ".";
            }
            solrmarcPath = solrmarcPath == null || solrmarcPath.length() == 0 || solrmarcPath.equals(".") && !configEqHomeDir ? dirParm : solrmarcPath + ";" + dirParm;
        }
        String solrCore = configProperties.getProperty("solr.core.name");
        String systemSolrCore = PropertyUtils.getProperty(configProperties, "solr.core.name");
        if (solrCore != null && systemSolrCore != null && !solrCore.equals(systemSolrCore) && solrHosturl.contains(solrCore)) {
            logger.debug("Replacing corename " + solrCore + " with corename " + systemSolrCore);
            solrHosturl = solrHosturl.replace(solrCore, systemSolrCore);
            logger.debug("New Solr URL is " + solrHosturl);
        }
        if (solrmarcPath == null || solrmarcPath.length() == 0 || solrmarcPath.equals(".") && configEqHomeDir) {
            stringArray3 = new String[]{};
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "-dir";
            stringArray3 = stringArray4;
            stringArray4[1] = solrmarcPath;
        }
        String[] dirArg = stringArray3;
        if (solrIndexerProperties == null) {
            logger.error("The provided old-style SolrMarc config.properties file doesn't define the value \"solr.indexer.properties\"");
            LoggerDelegator.flushToLog();
            System.exit(1);
        }
        String[] configArg = new String[]{"-config", solrIndexerProperties};
        if (solrHosturl != null) {
            String[] stringArray5 = new String[2];
            stringArray5[0] = "-solrURL";
            stringArray2 = stringArray5;
            stringArray5[1] = solrHosturl;
        } else {
            stringArray2 = urlArg = new String[]{};
        }
        if (solrCommit != null) {
            String[] stringArray6 = new String[2];
            stringArray6[0] = "-solrCommit";
            stringArray = stringArray6;
            stringArray6[1] = solrCommit;
        } else {
            stringArray = new String[]{};
        }
        String[] commitArg = stringArray;
        String[] marcReaderArg = new String[]{"-reader_opts", marcreaderProperties};
        ArrayList<String> driverArgs = new ArrayList<String>();
        driverArgs.addAll(Arrays.asList(marcReaderArg));
        driverArgs.addAll(Arrays.asList(dirArg));
        driverArgs.addAll(Arrays.asList(configArg));
        driverArgs.addAll(Arrays.asList(urlArg));
        driverArgs.addAll(Arrays.asList(commitArg));
        for (int i = 1; i < args.length; ++i) {
            driverArgs.add(args[i]);
        }
        String effectiveCommandLine = "java -jar solrmarc_core.jar IndexDriver " + Utils.join(ConfigDriver.quoteIfHasSpace(driverArgs), " ");
        logger.info("Effective Command Line is:");
        logger.info("   " + effectiveCommandLine);
        Boot.invokeMain("org.solrmarc.driver.IndexDriver", driverArgs.toArray(new String[0]));
    }

    public ConfigDriver(String[] args, List<String> driverArgs) {
    }

    private static String[] quoteIfHasSpace(List<String> driverArgs) {
        String[] result = new String[driverArgs.size()];
        int i = 0;
        for (String arg : driverArgs) {
            result[i++] = arg.contains(" ") ? "\"" + arg + "\"" : arg;
        }
        return result;
    }
}

