/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;
import org.marc4j.marc.Record;
import org.solrmarc.driver.Indexer;
import org.solrmarc.driver.RecordAndDoc;

public class ChunkIndexerWorker
implements Runnable {
    private static final Logger logger = Logger.getLogger(ChunkIndexerWorker.class);
    final String threadName;
    final Collection<RecordAndDoc> recordAndDocs;
    final Indexer indexer;
    final BlockingQueue<RecordAndDoc> errQ;
    String firstDocId = null;
    String lastDocId = null;
    boolean trackProgress = false;

    public ChunkIndexerWorker(String threadName, Collection<RecordAndDoc> recordAndDocs, BlockingQueue<RecordAndDoc> errQ, Indexer indexer) {
        this.threadName = threadName;
        this.recordAndDocs = recordAndDocs;
        this.setFirstAndLastID(recordAndDocs);
        this.errQ = errQ;
        this.indexer = indexer;
        this.trackProgress = Boolean.parseBoolean(System.getProperty("solrmarc.track.solr.progress", "false"));
    }

    private void setFirstAndLastID(Collection<RecordAndDoc> recordAndDocs) {
        ArrayList docs = new ArrayList(recordAndDocs.size());
        for (RecordAndDoc recDoc : recordAndDocs) {
            String docID = this.controlNumOrDefault(recDoc.getRec(), "Rec with No 001");
            if (this.firstDocId == null) {
                this.firstDocId = docID;
            }
            this.lastDocId = docID;
        }
    }

    private final String controlNumOrDefault(Record rec, String label) {
        String docID = rec.getControlNumber();
        if (docID == null) {
            docID = label;
        }
        return docID;
    }

    @Override
    public void run() {
        block12: {
            Thread.currentThread().setName(this.threadName);
            int inChunk = this.recordAndDocs.size();
            logger.debug((Object)("Adding chunk of " + inChunk + " documents -- starting with id : " + this.firstDocId));
            try {
                int cnt = this.indexer.solrProxy.addDocs(this.recordAndDocs);
                this.indexer.addToCnt(2, cnt);
                logger.debug((Object)("Added chunk of " + cnt + " documents -- starting with id : " + this.firstDocId));
                if (this.trackProgress || logger.isDebugEnabled()) {
                    logger.info((Object)("Total sent so far: " + this.indexer.getCounts()[2]));
                }
                if (this.errQ == null) break block12;
                for (RecordAndDoc recDoc : this.recordAndDocs) {
                    if (recDoc.errLocs.isEmpty()) continue;
                    this.errQ.add(recDoc);
                }
            }
            catch (Exception e) {
                Iterator<RecordAndDoc> recDocI = this.recordAndDocs.iterator();
                if (inChunk == 1) {
                    RecordAndDoc recDoc = recDocI.next();
                    this.indexer.singleRecordSolrError(recDoc, e, this.errQ);
                } else if (inChunk > 20) {
                    logger.warn((Object)("Failed on chunk of " + inChunk + " documents -- starting with id : " + this.firstDocId));
                    logger.info((Object)"   exception reported is: ", (Throwable)e);
                    int newChunkSize = inChunk / 4;
                    Runnable[] subChunk = new Runnable[4];
                    for (int i = 0; i < 4; ++i) {
                        ArrayList<RecordAndDoc> newRecDoc = new ArrayList<RecordAndDoc>(newChunkSize);
                        String id1 = null;
                        String id2 = null;
                        for (int j = 0; j < newChunkSize; ++j) {
                            if (!recDocI.hasNext()) continue;
                            RecordAndDoc recDoc = recDocI.next();
                            newRecDoc.add(recDoc);
                            String docID = this.controlNumOrDefault(recDoc.getRec(), "RecCnt_" + (newChunkSize * 4 + j));
                            if (id1 == null) {
                                id1 = docID;
                            }
                            id2 = docID;
                        }
                        subChunk[i] = new ChunkIndexerWorker("SolrUpdateOnError_" + id1 + "_" + id2, newRecDoc, this.errQ, this.indexer);
                        subChunk[i].run();
                    }
                } else {
                    logger.warn((Object)("Failed on chunk of " + inChunk + " documents -- starting with id : " + this.firstDocId));
                    logger.warn((Object)"   exception reported is: ", (Throwable)e);
                    while (recDocI.hasNext()) {
                        RecordAndDoc recDoc = recDocI.next();
                        this.indexer.indexSingleDocument(recDoc);
                    }
                }
            }
        }
    }
}

