/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.solrmarc.driver.Boot;
import org.solrmarc.driver.LoggerDelegator;
import org.solrmarc.index.indexer.IndexerSpecException;

public class BootableMain {
    private static final LoggerDelegator logger = new LoggerDelegator(BootableMain.class);
    protected String[] homeDirStrs;
    protected String[] addnlLibDirStrs;
    protected OptionSpec<String> readOpts;
    protected OptionSpec<String> configSpecs;
    protected OptionSpec<String> homeDirs;
    protected OptionSpec<String> addnlLibDirs;
    protected OptionSpec<File> solrjDir;
    protected OptionSpec<String> solrjClass;
    protected OptionSpec<File> deleteRecordByIdFile;
    protected OptionSpec<File> errorMarcErrOutFile;
    protected OptionSpec<File> errorIndexErrOutFile;
    protected OptionSpec<File> errorSolrErrOutFile;
    protected OptionSpec<String> files;
    protected OptionSet options = null;

    protected void processArgs(String[] args, boolean failOnZeroArgs) {
        OptionParser parser = new OptionParser();
        this.readOpts = parser.acceptsAll(Arrays.asList("r", "reader_opts"), "file containing MARC Reader options").withRequiredArg().defaultsTo((Object)"marcreader.properties", (Object[])new String[0]);
        this.configSpecs = parser.acceptsAll(Arrays.asList("c", "config"), "index specification file to use").withRequiredArg();
        this.homeDirs = parser.accepts("dir", "directory to look in for scripts, mixins, and translation maps").withRequiredArg().ofType(String.class);
        this.addnlLibDirs = parser.accepts("lib_local", "directory to look in for additional jars and libraries").withRequiredArg().defaultsTo((Object)"lib_local", (Object[])new String[0]);
        this.solrjDir = parser.accepts("solrj", "directory to look in for jars required for SolrJ").withRequiredArg().ofType(File.class);
        this.solrjClass = parser.accepts("solrjClassName", "Classname of class to use for talking to solr").withRequiredArg();
        this.errorMarcErrOutFile = parser.accepts("marcerr", "File to write records with errors.(not yet implemented)").withRequiredArg().ofType(File.class);
        this.errorIndexErrOutFile = parser.accepts("indexerr", "File to write the solr documents for records with errors.(not yet implemented)").withRequiredArg().ofType(File.class);
        this.errorSolrErrOutFile = parser.accepts("solrerr", "File to write the solr documents for records with errors.(not yet implemented)").withRequiredArg().ofType(File.class);
        this.deleteRecordByIdFile = parser.accepts("del", "File to read list of document ids that are to be deleted").withRequiredArg().ofType(File.class);
        parser.accepts("debug", "non-multithreaded debug mode");
        parser.acceptsAll(Arrays.asList("solrURL", "u"), "URL of Remote Solr to use").withRequiredArg();
        parser.acceptsAll(Arrays.asList("solrCommit", "c"), "Whether to commit, true or false").withRequiredArg();
        parser.acceptsAll(Arrays.asList("?", "help"), "show this usage information").forHelp();
        this.processAddnlArgs(parser);
        this.files = parser.nonOptions().ofType(String.class);
        this.options = null;
        try {
            this.options = parser.parse(args);
        }
        catch (OptionException uoe) {
            try {
                System.err.println(uoe.getMessage());
                parser.printHelpOn((OutputStream)System.err);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.exit(1);
        }
        if (failOnZeroArgs && args.length == 0 || this.options.has("help")) {
            try {
                parser.printHelpOn((OutputStream)System.err);
            }
            catch (IOException uoe) {
                // empty catch block
            }
            System.exit(0);
        }
        if (this.options.has("dir")) {
            File defDir = new File(Boot.getDefaultHomeDir());
            ArrayList<String> homeDirList = new ArrayList<String>();
            boolean hasDefDir = false;
            for (String dir : ((String)this.options.valueOf(this.homeDirs)).replaceAll("[,;]", "|").split("[|]")) {
                File dirAsFile = new File(dir);
                if (dirAsFile.getAbsolutePath().equals(defDir.getAbsolutePath())) {
                    hasDefDir = true;
                }
                if (homeDirList.contains(dirAsFile.getAbsolutePath())) continue;
                homeDirList.add(dirAsFile.getAbsolutePath());
                logger.debug("Adding directory: " + dirAsFile.getAbsolutePath());
            }
            if (!hasDefDir) {
                homeDirList.add(defDir.getAbsolutePath());
            }
            this.homeDirStrs = homeDirList.toArray(new String[0]);
        } else {
            this.homeDirStrs = new String[]{Boot.getDefaultHomeDir()};
        }
        System.setProperty("solrmarc.home.dir", this.homeDirStrs[0]);
        LoggerDelegator.reInit(this.homeDirStrs);
        if (this.needsSolrJ() && !this.hasSolrJ()) {
            File solrJPath = this.options.has(this.solrjDir) ? (File)this.options.valueOf(this.solrjDir) : new File("lib-solrj");
            try {
                if (solrJPath.isAbsolute()) {
                    Boot.extendClasspathWithSolJJarDir(null, solrJPath);
                } else {
                    Boot.extendClasspathWithSolJJarDir(this.homeDirStrs, solrJPath);
                }
            }
            catch (IndexerSpecException ise) {
                logger.fatal("Fatal error: Failure to load SolrJ", ise);
                logger.error("Exiting...");
                System.exit(10);
            }
        }
        try {
            if (this.addnlLibDirs.value(this.options) != null) {
                this.addnlLibDirStrs = ((String)this.addnlLibDirs.value(this.options)).split("[,;|]");
                Boot.extendClasspathWithLocalJarDirs(this.homeDirStrs, this.addnlLibDirStrs);
            }
        }
        catch (IndexerSpecException ise) {
            logger.fatal("Fatal error: Failure to load SolrJ", ise);
            logger.error("Exiting...");
            System.exit(10);
        }
    }

    protected void processAddnlArgs(OptionParser parser) {
    }

    private boolean hasSolrJ() {
        try {
            Boot.classForName("org.apache.solr.common.SolrInputDocument");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    protected boolean needsSolrJ() {
        return true;
    }
}

