/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.driver;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.solrmarc.driver.BootableMain;
import org.solrmarc.driver.LoggerDelegator;
import org.solrmarc.index.utils.ClasspathUtils;

public class Boot
extends URLClassLoader {
    private static LoggerDelegator logger = null;
    private static URLClassLoader classLoaderToUse = null;
    private Hashtable<String, Class<?>> classes = new Hashtable();

    public static void main(String[] args) {
        logger.info("Starting SolrMarc boot loader shim");
        logger.info_multi("Command line: \n" + Boot.getCommandLine());
        if (args.length == 0) {
            Boot.findExecutables();
        } else {
            String[] otherArgs;
            String classname = null;
            if (args[0].endsWith(".properties")) {
                classname = "org.solrmarc.driver.ConfigDriver";
                otherArgs = args;
            } else {
                otherArgs = new String[args.length - 1];
                System.arraycopy(args, 1, otherArgs, 0, args.length - 1);
                try {
                    classname = Boot.classnamefromArg(args[0]);
                }
                catch (ClassNotFoundException e1) {
                    logger.fatal("ERROR: Unable to find main class for specified short name: " + args[0]);
                    Boot.findExecutables();
                    LoggerDelegator.flushToLog();
                    System.exit(3);
                }
            }
            Boot.invokeMain(classname, otherArgs);
        }
    }

    public Boot(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    private static String getCommandLine() {
        String sep = "" + File.pathSeparatorChar;
        StringBuilder sb = new StringBuilder().append("java ");
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = bean.getInputArguments();
        for (int i = 0; i < jvmArgs.size(); ++i) {
            sb.append(jvmArgs.get(i)).append("\n    ");
        }
        sb.append("-classpath " + System.getProperty("java.class.path").replaceAll(sep, sep + "\n               "));
        sb.append("\n    " + System.getProperty("sun.java.command").replaceFirst(" ", "\n        ").replaceAll(" -", "\n        -"));
        return sb.toString().replaceAll("\n[ ]*\n", "\n");
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> result = null;
            if (className.endsWith(".Boot") || className.endsWith(".LoggerDelegator")) {
                return super.loadClass(className, resolve);
            }
            result = this.classes.get(className);
            if (result != null) {
                return result;
            }
            URL[] urls = super.getURLs();
            if (urls != null) {
                for (URL jarFileURL : urls) {
                    String jarFile = jarFileURL.toURI().getPath();
                    JarFile jar = null;
                    try {
                        jar = new JarFile(jarFile);
                        JarEntry entry = jar.getJarEntry(className.replace(".", "/") + ".class");
                        InputStream is = jar.getInputStream(entry);
                        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                        int nextValue = is.read();
                        while (nextValue != -1) {
                            byteStream.write(nextValue);
                            nextValue = is.read();
                        }
                        byte[] classByte = byteStream.toByteArray();
                        result = this.defineClass(className, classByte, 0, classByte.length);
                        this.classes.put(className, result);
                        jar.close();
                    }
                    catch (Exception e) {
                        if (jar == null) continue;
                        try {
                            jar.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            if ((result = this.classes.get(className)) != null) {
                return result;
            }
            throw new ClassNotFoundException("Not found " + className);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(className, resolve);
        }
        catch (URISyntaxException e1) {
            return super.loadClass(className, resolve);
        }
    }

    public static void invokeMain(String classname, String[] otherArgs) {
        logger.info_multi("Invoking main program: \n" + Boot.getEffectiveCommandLine(classname, otherArgs));
        try {
            Class<?> mainClass = Boot.classForName(classname);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            if (!Modifier.isStatic(mainMethod.getModifiers())) {
                logger.fatal("ERROR: Main method is not static in class: " + classname);
                LoggerDelegator.flushToLog();
                System.exit(1);
            }
            mainMethod.invoke(null, new Object[]{otherArgs});
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.fatal("ERROR: Unable to invoke main method in specified class: " + classname, e);
            LoggerDelegator.flushToLog();
            System.exit(2);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            logger.fatal("ERROR: Error while invoking main method in specified class: " + classname, t);
            LoggerDelegator.flushToLog();
            System.exit(2);
        }
        catch (ClassNotFoundException e) {
            logger.fatal("ERROR: Unable to find specified main class: " + classname, e);
            Boot.findExecutables();
            LoggerDelegator.flushToLog();
            System.exit(3);
        }
        catch (NoSuchMethodException e) {
            logger.fatal("ERROR: Unable to find main method in specified class: " + classname, e);
            LoggerDelegator.flushToLog();
            System.exit(4);
        }
        catch (SecurityException e) {
            logger.fatal("ERROR: Unable to access main method in specified class: " + classname, e);
            LoggerDelegator.flushToLog();
            System.exit(5);
        }
    }

    private static String getEffectiveCommandLine(String classname, String[] otherargs) {
        StringBuilder sb = new StringBuilder().append("java ").append("-classpath <CLASSPATH>").append("\n        ").append(classname).append("\n");
        boolean wasDash = false;
        for (String arg : otherargs) {
            if (wasDash) {
                sb.append(" ").append(arg);
            } else {
                sb.append("\n        ").append(arg);
            }
            wasDash = arg.startsWith("-");
        }
        return sb.toString().replaceAll("\n[ ]*\n", "\n");
    }

    private static String classnamefromArg(String string) throws ClassNotFoundException {
        Class<?> clazzUtil = Boot.classForName("org.solrmarc.index.utils.ClasspathUtils");
        Set mainClasses = new LinkedHashSet();
        try {
            Object instance = clazzUtil.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            Method getBootableMain = instance.getClass().getMethod("getBootableMainClasses", new Class[0]);
            mainClasses = (Set)getBootableMain.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        for (Class clazz : mainClasses) {
            if (string.equals(clazz.getName())) {
                return clazz.getName();
            }
            if (!clazz.getName().endsWith("." + string)) continue;
            return clazz.getName();
        }
        for (Class clazz : mainClasses) {
            String shortNameStr = null;
            try {
                Field shortName = clazz.getDeclaredField("shortName");
                shortNameStr = shortName.get(null).toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
            if (shortNameStr == null || !string.equals(shortNameStr)) continue;
            return clazz.getName();
        }
        throw new ClassNotFoundException("can't find class");
    }

    private static void findExecutables() {
        Set<Class<? extends BootableMain>> mainClasses = ClasspathUtils.instance().getBootableMainClasses();
        logger.info("This class  org.solrmarc.driver.Boot  dynamically loads all of the jars in the lib directory");
        logger.info("and then calls the main method of a class that requires those jars");
        logger.info("The first argument provided to this class specifies the name of the class to load and execute");
        logger.info("all of the subsequent arguments are then passed to that class's main method");
        logger.info("");
        logger.info("Known classes that can be bootstrapped in tha manner are:");
        for (Class<? extends BootableMain> mainClass : mainClasses) {
            try {
                Method mainMethod = mainClass.getMethod("main", String[].class);
                String shortNameStr = null;
                try {
                    Field shortName = mainClass.getDeclaredField("shortName");
                    shortNameStr = shortName.get(null).toString();
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
                if (!Modifier.isStatic(mainMethod.getModifiers())) continue;
                logger.info("    " + mainClass.getName() + (shortNameStr != null ? "  (" + shortNameStr + ")" : ""));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public static String getDefaultHomeDir() {
        CodeSource codeSource = Boot.class.getProtectionDomain().getCodeSource();
        File jarFile = null;
        try {
            jarFile = new File(codeSource.getLocation().toURI().getPath());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String jarDir = jarFile.getName().endsWith(".jar") ? jarFile.getParentFile().getPath() : new File(".").getAbsoluteFile().getParentFile().getAbsolutePath();
        System.setProperty("solrmarc.jar.dir", jarDir);
        return jarDir;
    }

    private static void addLibDirJarstoClassPath() {
        try {
            Class.forName("org.solrmarc.driver.LoggerDelegator");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        logger = new LoggerDelegator(Boot.class);
        String homePath = Boot.getDefaultHomeDir();
        File homeDir = new File(homePath);
        boolean alreadyHasRequiredClasses = true;
        alreadyHasRequiredClasses &= Boot.hasRequired("org.marc4j.marc.Record");
        alreadyHasRequiredClasses &= Boot.hasRequired("org.apache.log4j.Logger");
        alreadyHasRequiredClasses &= Boot.hasRequired("java_cup.runtime.Symbol");
        if (alreadyHasRequiredClasses &= Boot.hasRequired("joptsimple.OptionSet")) {
            logger.info("Required classes provided statically.  Proceeding and hoping for the best");
            return;
        }
        CodeSource codeSource = Boot.class.getProtectionDomain().getCodeSource();
        File jarFile = null;
        try {
            jarFile = new File(codeSource.getLocation().toURI().getPath());
            URLClassLoader loader = Boot.getURLClassLoaderToUse();
            if (loader != ClassLoader.getSystemClassLoader()) {
                Boot.extendClasspathWithJar(loader, jarFile);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        File libPath = new File(homeDir, "lib");
        try {
            Boot.extendClasspathWithLibJarDir(libPath, "marc4j.*[.]jar");
        }
        catch (RuntimeException ise) {
            logger.fatal("Fatal error: Failure while loading jars from lib directory" + ise.getMessage());
            LoggerDelegator.flushToLog();
            System.exit(10);
        }
        boolean hasRequiredClasses = true;
        hasRequiredClasses &= Boot.require("org.marc4j.marc.Record", "Fatal error: Unable to find required marc4j Record class.");
        hasRequiredClasses &= Boot.require("org.apache.log4j.Logger", "Fatal error: Unable to find required log4j Logging class.");
        hasRequiredClasses &= Boot.require("java_cup.runtime.Symbol", "Fatal error: Unable to find required parser runtime library:  java-cup-runtime.jar ");
        if (!(hasRequiredClasses &= Boot.require("joptsimple.OptionSet", "Fatal error: Unable to find required JoptionSimple class library."))) {
            LoggerDelegator.flushToLog();
            System.exit(11);
        }
    }

    public static Class<?> classForName(String classname) throws ClassNotFoundException {
        if (classLoaderToUse == null) {
            Boot.getURLClassLoaderToUse();
        }
        return Class.forName(classname, true, classLoaderToUse);
    }

    private static boolean hasRequired(String requiredClass) {
        try {
            Boot.classForName(requiredClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private static boolean require(String requiredClass, String errMsg) {
        try {
            Boot.classForName(requiredClass);
        }
        catch (ClassNotFoundException e) {
            try {
                logger.fatal(errMsg);
            }
            catch (Exception e1) {
                System.err.println(errMsg);
            }
            return false;
        }
        return true;
    }

    private static void extendClasspathWithJar(URLClassLoader classLoader, File jarfile) {
        URL ujar;
        URL[] urls = classLoader.getURLs();
        try {
            ujar = jarfile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        String ujars = ujar.toString();
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].toString().equalsIgnoreCase(ujars)) continue;
            return;
        }
        try {
            if (classLoader instanceof Boot) {
                ((Boot)classLoader).addURL(ujar);
            } else {
                Class<URLClassLoader> urlClassLoaderClazz = URLClassLoader.class;
                Method method = urlClassLoaderClazz.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, ujar);
                logger.debug("Adding Jar file: " + jarfile.getAbsolutePath());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static boolean extendClasspathWithJarDir(URLClassLoader sysLoader, File dir, String patternToLoad, String specialMatch) {
        boolean foundSpecial = false;
        if (dir == null || !dir.isDirectory() || dir.listFiles().length == 0) {
            return false;
        }
        for (File file : dir.listFiles()) {
            if (!file.getName().matches(patternToLoad)) continue;
            Boot.extendClasspathWithJar(sysLoader, file);
            if (specialMatch == null || !file.getName().matches(specialMatch)) continue;
            foundSpecial = true;
        }
        return foundSpecial;
    }

    private static void extendClasspathWithDirOfClasses(URLClassLoader classLoader, File dir) {
        URI u = dir.toURI();
        try {
            if (classLoader instanceof Boot) {
                ((Boot)classLoader).addURL(u.toURL());
            } else {
                Class<URLClassLoader> urlClassLoaderClazz = URLClassLoader.class;
                Method method = urlClassLoaderClazz.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, u.toURL());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private static void extendClasspathWithDirOfClasses(File dir) {
        URLClassLoader sysLoader = Boot.getURLClassLoaderToUse();
        Boot.extendClasspathWithDirOfClasses(sysLoader, dir);
    }

    private static boolean extendClasspathWithLibJarDir(File dir, String patternForSpecial) {
        URLClassLoader sysLoader = Boot.getURLClassLoaderToUse();
        boolean foundIt = Boot.extendClasspathWithJarDir(sysLoader, dir, ".*[.]jar", patternForSpecial);
        return foundIt;
    }

    public static void extendClasspathWithSolJJarDir(String[] homeDirStrs, File dir) {
        URLClassLoader sysLoader = Boot.getURLClassLoaderToUse();
        boolean foundSolrj = false;
        File dirWithJars = Boot.getDirToStartFrom(homeDirStrs, dir);
        foundSolrj = Boot.extendClasspathWithJarDir(sysLoader, dirWithJars, ".*[.]jar", ".*solrj.*[.]jar");
        File parentDir = null;
        if (!foundSolrj && (parentDir = dirWithJars.getParentFile()) != null) {
            foundSolrj = Boot.extendClasspathWithJarDir(sysLoader, parentDir, ".*solrj.*[.]jar", ".*solrj.*[.]jar");
        }
        if (!foundSolrj) {
            throw new RuntimeException("Unable to find a solrj jar file in directory: " + dir.getAbsolutePath() + (parentDir != null ? "( or " + parentDir.getAbsolutePath() + ")" : ""));
        }
    }

    public static URLClassLoader getURLClassLoaderToUse() {
        if (classLoaderToUse != null) {
            return classLoaderToUse;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        String forceCustomClassLoaderProperty = System.getProperty("solrmarc.force.custom.classloader", "false");
        if (systemClassLoader instanceof URLClassLoader && !forceCustomClassLoaderProperty.equalsIgnoreCase("true")) {
            classLoaderToUse = (URLClassLoader)systemClassLoader;
        } else {
            classLoaderToUse = new Boot(new URL[0], systemClassLoader);
            Thread.currentThread().setContextClassLoader(classLoaderToUse);
        }
        return classLoaderToUse;
    }

    private static File getDirToStartFrom(String[] homeDirStrs, File dir) {
        if (homeDirStrs == null) {
            return dir;
        }
        for (int i = 0; i < homeDirStrs.length; ++i) {
            String homeDirStr = homeDirStrs[i];
            File dirSolrJ = new File(homeDirStr, dir.getPath());
            if (!dirSolrJ.exists()) continue;
            return dirSolrJ;
        }
        return dir;
    }

    public static void extendClasspathWithLocalJarDirs(String[] homeDirStrs, String[] addnlLibDirStrs) {
        FilenameFilter jarsOrClassesOnly = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith("*.class");
            }
        };
        for (String libdirname : addnlLibDirStrs) {
            File libDir = new File(libdirname);
            if (!libDir.isAbsolute()) {
                logger.debug("Number of homeDirStrs: " + homeDirStrs.length);
                if (homeDirStrs.length >= 1) {
                    logger.debug("homeDirStrs[0]: " + homeDirStrs[0]);
                }
                if (homeDirStrs.length >= 2) {
                    logger.debug("homeDirStrs[1]: " + homeDirStrs[1]);
                }
                for (int i = homeDirStrs.length - 1; i >= 0; --i) {
                    String homeDir = homeDirStrs[i];
                    logger.debug("Checking for jars files in directory: " + homeDir + "/" + libdirname);
                    libDir = new File(homeDir, libdirname);
                    if (!libDir.exists() || !libDir.isDirectory() || libDir.listFiles(jarsOrClassesOnly).length <= 0) continue;
                    logger.debug("Adding jars files in directory: " + libDir.getAbsolutePath());
                    Boot.extendClasspathWithLibJarDir(libDir, null);
                    Boot.extendClasspathWithDirOfClasses(libDir);
                }
                continue;
            }
            if (!libDir.exists() || !libDir.isDirectory() || libDir.listFiles(jarsOrClassesOnly).length <= 0) continue;
            logger.debug("Adding jars files in directory: " + libDir.getAbsolutePath());
            Boot.extendClasspathWithLibJarDir(libDir, null);
            Boot.extendClasspathWithDirOfClasses(libDir);
        }
    }

    static {
        Boot.getURLClassLoaderToUse();
        Boot.addLibDirJarstoClassPath();
    }
}

