/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import org.marc4j.MarcError;
import org.marc4j.MarcReader;
import org.marc4j.MarcReaderConfig;
import org.marc4j.MarcReaderFactory;
import org.marc4j.marc.Record;
import org.solrmarc.debug.CompoundUndoManager;
import org.solrmarc.driver.BootableMain;
import org.solrmarc.index.indexer.AbstractValueIndexer;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.indexer.ValueIndexerFactory;
import org.solrmarc.tools.PropertyUtils;
import org.solrmarc.tools.SolrMarcIndexerException;

public class SolrMarcDebug
extends BootableMain {
    private JFrame frmSolrmarcIndexSpecification;
    private Map<String, Record> recordMap;
    private JTextPane configPane;
    private JTextPane outputPane;
    private JTextPane errorPane;
    private JTextPane recordPane;
    ValueIndexerFactory indexerFactory = null;
    JComboBox<String> marcIdentifier = null;
    protected Action undoAction;
    protected Action redoAction;
    protected CompoundUndoManager undo = null;
    HashMap<Object, Action> actions;
    String previousConfigText = "";
    List<AbstractValueIndexer<?>> indexers = null;
    Properties readerProps = new Properties();
    MarcReaderConfig readerConfig;
    static int[] fontSizeArray = new int[]{8, 10, 12, 14, 18, 22, 28, 36, 42};

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SolrMarcDebug window = new SolrMarcDebug(args);
                    window.frmSolrmarcIndexSpecification.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SolrMarcDebug(String[] args) {
        super.processArgs(args, false);
        this.initialize();
    }

    @Override
    protected boolean needsSolrJ() {
        return false;
    }

    private void initialize() {
        this.indexerFactory = ValueIndexerFactory.initialize(this.homeDirStrs);
        System.setProperty("solrmarc.indexer.test.fire.method", "true");
        String[] inputSource = new String[1];
        String propertyFileAsURLStr = PropertyUtils.getPropertyFileAbsoluteURL(this.homeDirStrs, (String)this.options.valueOf(this.readOpts), true, inputSource);
        try {
            this.readerProps.load(PropertyUtils.getPropertyFileInputStream(propertyFileAsURLStr));
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        try {
            this.readerConfig = new MarcReaderConfig(this.readerProps);
        }
        catch (NoClassDefFoundError cnf) {
            this.readerConfig = null;
        }
        this.recordMap = new LinkedHashMap<String, Record>();
        this.frmSolrmarcIndexSpecification = new JFrame();
        this.frmSolrmarcIndexSpecification.setTitle("SolrMarc Index Specification Debugger");
        this.frmSolrmarcIndexSpecification.setBounds(100, 100, 1024, 828);
        this.frmSolrmarcIndexSpecification.setDefaultCloseOperation(3);
        this.frmSolrmarcIndexSpecification.getContentPane().setLayout((LayoutManager)new MigLayout("", "[512px,grow][][512px,grow]", "[42.00][361.00px,grow][::-2.00px][141.00px,grow][][100.00px,grow]"));
        JPanel panel_1 = new JPanel();
        this.frmSolrmarcIndexSpecification.getContentPane().add((Component)panel_1, "cell 0 0 3 1,grow");
        panel_1.setLayout((LayoutManager)new MigLayout("", "[grow][][][]", "[][grow][]"));
        this.marcIdentifier = new JComboBox();
        panel_1.add(this.marcIdentifier, "flowx,cell 0 0,grow");
        JButton btnNextRecord = new JButton("Next >");
        btnNextRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SolrMarcDebug.this.marcIdentifier.getSelectedIndex();
                int cnt = SolrMarcDebug.this.marcIdentifier.getItemCount();
                if (index >= 0 && index < cnt - 1) {
                    SolrMarcDebug.this.marcIdentifier.setSelectedIndex(index + 1);
                }
            }
        });
        JButton btnApply = new JButton("Apply");
        btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SolrMarcDebug.this.marcIdentifier.getSelectedIndex();
                SolrMarcDebug.this.marcIdentifier.setSelectedIndex(index);
            }
        });
        panel_1.add((Component)btnApply, "cell 1 0");
        JButton btnPrevRecord = new JButton("< Prev");
        btnPrevRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SolrMarcDebug.this.marcIdentifier.getSelectedIndex();
                if (index > 0) {
                    SolrMarcDebug.this.marcIdentifier.setSelectedIndex(index - 1);
                }
            }
        });
        panel_1.add((Component)btnPrevRecord, "cell 2 0,alignx left");
        btnPrevRecord.setMnemonic('<');
        panel_1.add((Component)btnNextRecord, "cell 3 0");
        btnNextRecord.setMnemonic('>');
        this.marcIdentifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                Object selected = source.getSelectedItem();
                if (selected != null) {
                    String fKey = selected.toString();
                    Record rec = (Record)SolrMarcDebug.this.recordMap.get(fKey);
                    SolrMarcDebug.this.recordPane.setText(rec.toString());
                    SolrMarcDebug.this.recordPane.setCaretPosition(0);
                    SolrMarcDebug.this.processRecordToOutput(rec);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        this.frmSolrmarcIndexSpecification.getContentPane().add((Component)scrollPane, "cell 0 1,grow");
        this.recordPane = new JTextPane();
        this.recordPane.setEditable(false);
        scrollPane.setViewportView(this.recordPane);
        JScrollPane scrollPane_1 = new JScrollPane();
        this.frmSolrmarcIndexSpecification.getContentPane().add((Component)scrollPane_1, "cell 0 3 3 1,grow");
        this.configPane = new JTextPane();
        scrollPane_1.setViewportView(this.configPane);
        this.undo = new CompoundUndoManager(this.configPane);
        this.configPane.getDocument().addUndoableEditListener(this.undo);
        JScrollPane scrollPane_2 = new JScrollPane();
        this.frmSolrmarcIndexSpecification.getContentPane().add((Component)scrollPane_2, "cell 2 1,grow");
        this.outputPane = new JTextPane();
        this.outputPane.setEditable(false);
        scrollPane_2.setViewportView(this.outputPane);
        JSeparator separator_1 = new JSeparator();
        this.frmSolrmarcIndexSpecification.getContentPane().add((Component)separator_1, "cell 0 4 3 1");
        JScrollPane scrollPane_3 = new JScrollPane();
        this.frmSolrmarcIndexSpecification.getContentPane().add((Component)scrollPane_3, "cell 0 5 3 1,grow");
        this.errorPane = new JTextPane();
        this.errorPane.setEditable(false);
        scrollPane_3.setViewportView(this.errorPane);
        this.setFontSize(this.getCurFontSize());
        this.actions = this.createActionTable(this.configPane);
        JMenuBar menuBar = new JMenuBar();
        this.frmSolrmarcIndexSpecification.setJMenuBar(menuBar);
        JMenu mnNewMenu = new JMenu("File");
        menuBar.add(mnNewMenu);
        JMenuItem mntmOpenConfig = new JMenuItem("Open Config...");
        mnNewMenu.add(mntmOpenConfig);
        JMenuItem mntmOpenMarcRecord = new JMenuItem("Open Marc Record ...");
        mnNewMenu.add(mntmOpenMarcRecord);
        JMenu mnEdit = this.createEditMenu();
        menuBar.add(mnEdit);
        JMenu mnViewMenu = new JMenu("View");
        menuBar.add(mnViewMenu);
        JMenuItem mntmFontPlus = new JMenuItem("Increase Fontsize");
        mntmFontPlus.setEnabled(true);
        mntmFontPlus.setAccelerator(KeyStroke.getKeyStroke(61, 2));
        mnViewMenu.add(mntmFontPlus);
        mntmFontPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolrMarcDebug.this.increaseFontSize();
            }
        });
        JMenuItem mntmFontMinus = new JMenuItem("Decrease Fontsize");
        mntmFontMinus.setAccelerator(KeyStroke.getKeyStroke(45, 2));
        mnViewMenu.add(mntmFontMinus);
        mntmFontMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolrMarcDebug.this.decreaseFontSize();
            }
        });
        mntmOpenConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = null;
                JFileChooser chooser = new JFileChooser(SolrMarcDebug.this.homeDirStrs[0]);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Index Property Files", "properties");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showOpenDialog(SolrMarcDebug.this.frmSolrmarcIndexSpecification);
                if (returnVal != 0) {
                    return;
                }
                f = chooser.getSelectedFile();
                SolrMarcDebug.this.openSpecifiedConfig(f, true);
            }
        });
        mntmOpenMarcRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = null;
                JFileChooser chooser = new JFileChooser(SolrMarcDebug.this.homeDirStrs[0]);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("MARC Record Files", "mrc", "xml");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showOpenDialog(SolrMarcDebug.this.frmSolrmarcIndexSpecification);
                if (returnVal != 0) {
                    return;
                }
                f = chooser.getSelectedFile();
                SolrMarcDebug.this.openSpecifiedMarcFile(f, true);
            }
        });
        String specs = (String)this.options.valueOf(this.configSpecs);
        if (specs != null) {
            this.configureIndexer(specs);
        }
        List inputFiles = this.options.valuesOf(this.files);
        boolean first = true;
        for (String inputFile : inputFiles) {
            File marcFile = new File(inputFile);
            this.openSpecifiedMarcFile(marcFile, first);
            first = false;
        }
    }

    public void configureIndexer(String indexSpecifications) {
        String[] indexSpecs = indexSpecifications.split("[ ]*,[ ]*");
        File[] specFiles = new File[indexSpecs.length];
        int i = 0;
        int n = 0;
        String[] stringArray = indexSpecs;
        int n2 = stringArray.length;
        if (n < n2) {
            String indexSpec = stringArray[n];
            File specFile = new File(indexSpec);
            if (!specFile.isAbsolute()) {
                specFile = PropertyUtils.findFirstExistingFile(this.homeDirStrs, indexSpec);
            }
            specFiles[i++] = specFile;
        }
        if (specFiles.length > 0 && specFiles[0].exists() && specFiles[0].canRead()) {
            this.openSpecifiedConfig(specFiles[0], true);
        }
    }

    private int getCurFontSize() {
        Font currFont = this.recordPane.getFont();
        int fontSize = currFont.getSize();
        return fontSize;
    }

    private void increaseFontSize() {
        int fontSize = this.getCurFontSize();
        int fontSizeIndex = this.getFontSizeIndex(fontSizeArray, fontSize);
        if (fontSizeIndex < fontSizeArray.length - 2) {
            this.setFontSize(fontSizeArray[++fontSizeIndex]);
        }
    }

    private void decreaseFontSize() {
        int fontSize = this.getCurFontSize();
        int fontSizeIndex = this.getFontSizeIndex(fontSizeArray, fontSize);
        if (fontSizeIndex > 0) {
            this.setFontSize(fontSizeArray[--fontSizeIndex]);
        }
    }

    private int getFontSizeIndex(int[] fontSizeArray, int fontSize) {
        for (int i = 0; i < fontSizeArray.length; ++i) {
            if (fontSize < fontSizeArray[i] || i < fontSizeArray.length - 1 && fontSize >= fontSizeArray[i + 1]) continue;
            return i;
        }
        return 1;
    }

    private void setFontSize(int fontSize) {
        Font currFont = this.recordPane.getFont();
        this.recordPane.setFont(new Font("Courier New", currFont.getStyle(), fontSize));
        currFont = this.configPane.getFont();
        this.configPane.setFont(new Font("Courier New", currFont.getStyle(), fontSize));
        currFont = this.outputPane.getFont();
        this.outputPane.setFont(new Font("Courier New", currFont.getStyle(), fontSize));
        currFont = this.errorPane.getFont();
        this.errorPane.setFont(new Font("Courier New", currFont.getStyle(), fontSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSpecifiedConfig(File f, boolean clear) {
        InputStreamReader reader = null;
        try {
            this.configPane.read(new FileReader(f), null);
            this.configPane.getDocument().addUndoableEditListener(this.undo);
            this.undo.discardAllEdits();
            this.undoAction.setEnabled(false);
            this.redoAction.setEnabled(false);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void openSpecifiedMarcFile(File marcFile, boolean pointToFirst) {
        String firstId = null;
        try {
            MarcReader reader = MarcReaderFactory.makeReader((MarcReaderConfig)this.readerConfig, (InputStream)new FileInputStream(marcFile));
            while (reader.hasNext()) {
                Record record = reader.next();
                String id = record.getControlNumber();
                if (pointToFirst && firstId == null) {
                    firstId = id;
                }
                if (!this.recordMap.containsKey(id)) {
                    this.recordMap.put(id, record);
                    this.marcIdentifier.addItem(id);
                    continue;
                }
                this.recordMap.put(id, record);
            }
            if (pointToFirst) {
                this.marcIdentifier.setSelectedItem(firstId);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.errorPane.setText("Error: Cannot find the specified file: " + marcFile.getAbsolutePath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        this.undoAction = this.undo.getUndoAction();
        menu.add(this.undoAction);
        this.redoAction = this.undo.getRedoAction();
        menu.add(this.redoAction);
        menu.addSeparator();
        menu.add(this.getActionByName("cut-to-clipboard", "Cut", KeyStroke.getKeyStroke(88, 128)));
        menu.add(this.getActionByName("copy-to-clipboard", "Copy", KeyStroke.getKeyStroke(67, 128)));
        menu.add(this.getActionByName("paste-from-clipboard", "Paste", KeyStroke.getKeyStroke(86, 128)));
        return menu;
    }

    private HashMap<Object, Action> createActionTable(JTextComponent textComponent) {
        HashMap<Object, Action> actions2 = new HashMap<Object, Action>();
        Action[] actionsArray = textComponent.getActions();
        for (int i = 0; i < actionsArray.length; ++i) {
            Action a = actionsArray[i];
            actions2.put(a.getValue("Name"), a);
        }
        return actions2;
    }

    private Action getActionByName(String name, String label, KeyStroke keyStroke) {
        Action action = this.actions.get(name);
        action.putValue("Name", label);
        if (keyStroke != null) {
            action.putValue("AcceleratorKey", keyStroke);
        }
        return action;
    }

    private void processRecordToOutput(Record rec) {
        String currentConfigText = this.configPane.getText();
        if (!currentConfigText.equals(this.previousConfigText) || this.indexers == null) {
            try {
                currentConfigText = currentConfigText.replaceAll(",[ \t]*(\r)?\n[ \t]+", ",");
                this.indexers = this.indexerFactory.createValueIndexers(currentConfigText.split("\n"));
                this.previousConfigText = currentConfigText;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        List<IndexerSpecException> exceptions = this.indexerFactory.getValidationExceptions();
        this.errorPane.setText(this.getTextForExceptions(exceptions));
        this.indexerFactory.clearPerRecordErrors();
        this.outputPane.setText("");
        SimpleAttributeSet attributesErr = new SimpleAttributeSet();
        attributesErr = new SimpleAttributeSet();
        attributesErr.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
        attributesErr.addAttribute(StyleConstants.CharacterConstants.Italic, Boolean.FALSE);
        attributesErr.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.RED);
        Document doc = this.outputPane.getDocument();
        LinkedHashMap hasValueForField = new LinkedHashMap();
        for (AbstractValueIndexer<?> indexer : this.indexers) {
            String outLine;
            Collection<String> fieldNameList = indexer.getSolrFieldNames();
            Collection<String> results = null;
            try {
                if (indexer.getOnlyIfEmpty() && indexer.getSolrFieldNames().size() == 1 && hasValueForField.containsKey(indexer.getSolrFieldNames().iterator().next())) continue;
                results = indexer.getFieldData(rec);
                for (String fieldName : fieldNameList) {
                    for (String result : results) {
                        String outLine2 = fieldName + " : " + result + "\n";
                        if (indexer.getOnlyIfEmpty() && hasValueForField.containsKey(fieldName)) continue;
                        List resultList = hasValueForField.containsKey(fieldName) ? (List)hasValueForField.get(fieldName) : new ArrayList();
                        if (indexer.getOnlyIfUnique() && resultList.contains(result)) continue;
                        resultList.add(result);
                        hasValueForField.put(fieldName, resultList);
                        try {
                            doc.insertString(doc.getLength(), outLine2, null);
                        }
                        catch (BadLocationException exc) {
                            exc.printStackTrace();
                        }
                    }
                }
            }
            catch (InvocationTargetException ioe) {
                Throwable wrapped = ioe.getTargetException();
                if (wrapped instanceof SolrMarcIndexerException) {
                    SolrMarcIndexerException smie = (SolrMarcIndexerException)wrapped;
                    this.handleSolrMarcIndexerException(indexer, doc, attributesErr, smie);
                    continue;
                }
                String outLine3 = "marc_error : " + indexer.getSolrFieldNames().toString() + wrapped.getMessage() + "\n";
                try {
                    doc.insertString(doc.getLength(), outLine3, attributesErr);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            catch (IllegalArgumentException e) {
                outLine = "marc_error : " + indexer.getSolrFieldNames().toString() + e.getMessage() + "\n";
                try {
                    doc.insertString(doc.getLength(), outLine, attributesErr);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
            catch (IndexerSpecException e) {
                outLine = "marc_error : " + indexer.getSolrFieldNames().toString() + e.getMessage() + "\n";
                try {
                    doc.insertString(doc.getLength(), outLine, attributesErr);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
            catch (SolrMarcIndexerException smie) {
                this.handleSolrMarcIndexerException(indexer, doc, attributesErr, smie);
            }
            catch (Exception e) {
                outLine = "marc_error : " + indexer.getSolrFieldNames().toString() + e.getMessage() + "\n";
                try {
                    doc.insertString(doc.getLength(), outLine, attributesErr);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }
        Set<IndexerSpecException> perRecordExceptions = this.indexerFactory.getPerRecordErrors();
        try {
            doc.insertString(doc.getLength(), this.getTextForMarcErrorsAndExceptions(rec, perRecordExceptions), attributesErr);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        this.outputPane.setCaretPosition(0);
    }

    private void handleSolrMarcIndexerException(AbstractValueIndexer<?> indexer, Document doc, SimpleAttributeSet attributesErr, SolrMarcIndexerException smie) {
        String outLine = "";
        if (smie.getLevel() == 1) {
            outLine = indexer.getSolrFieldNames().toString() + "throws exception  Record would be Ignored \n";
        } else if (smie.getLevel() == 2) {
            outLine = indexer.getSolrFieldNames().toString() + "throws exception  Record would be Deleted \n";
        } else if (smie.getLevel() == 3) {
            outLine = indexer.getSolrFieldNames().toString() + "throws exception  Record would be Terminate Indexing \n";
        }
        try {
            doc.insertString(0, outLine, attributesErr);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String getTextForMarcErrorsAndExceptions(Record rec, Collection<IndexerSpecException> exceptions) {
        StringBuilder text = new StringBuilder();
        if (rec.hasErrors()) {
            for (MarcError err : rec.getErrors()) {
                text.append("Marc Record Error: ").append(err.toString()).append("\n");
            }
        }
        if (exceptions != null) {
            for (IndexerSpecException e : exceptions) {
                if (e.getSolrField() == null) {
                    e.setSolrFieldAndSpec("marc_error", null);
                }
                text.append(e.getMessage()).append("\n");
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    text.append(e.getSolrField()).append(" : ").append(cause.getMessage()).append("\n");
                }
            }
        }
        return text.toString();
    }

    private String getTextForExceptions(List<IndexerSpecException> exceptions) {
        StringBuilder text = new StringBuilder();
        String lastSpec = "";
        for (IndexerSpecException e : exceptions) {
            String specMessage = e.getSpecMessage();
            if (!specMessage.equals(lastSpec)) {
                text.append(specMessage).append("\n");
            }
            lastSpec = specMessage;
            text.append(e.getMessage()).append("\n");
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                text.append(e.getSolrField()).append(" : ").append(cause.getMessage()).append("\n");
            }
        }
        return text.toString();
    }
}

