/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.callnum;

import java.util.HashMap;
import java.util.Map;

public class Utils {
    private static Map<Character, Character> alphanumReverseMap = new HashMap<Character, Character>();
    public static char SORT_FIRST_CHAR;
    public static StringBuilder reverseDefault;

    public static void appendNumericallySortable(StringBuilder buf, CharSequence input) {
        StringBuilder numBuf = new StringBuilder();
        State state = State.START;
        InType inType = InType.END;
        block22: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                inType = InType.LETTER;
            } else if (c >= 'a' && c <= 'z') {
                inType = InType.LETTER;
                c = Character.toUpperCase(c);
            } else {
                inType = c >= '0' && c <= '9' ? InType.DIGIT : (c == '.' ? InType.PERIOD : (Character.isWhitespace(c) ? InType.SPACE : (c >= '!' && c <= '~' ? InType.PUNCT : InType.OTHER)));
            }
            switch (state) {
                case START: {
                    switch (inType) {
                        case LETTER: {
                            state = State.WORD;
                            buf.append(c);
                            continue block22;
                        }
                        case DIGIT: {
                            state = State.NUM;
                            numBuf.append(c);
                            continue block22;
                        }
                    }
                    continue block22;
                }
                case WORD: {
                    switch (inType) {
                        case LETTER: {
                            state = State.WORD;
                            buf.append(c);
                            continue block22;
                        }
                        case DIGIT: {
                            state = State.NUM;
                            buf.append(' ');
                            numBuf.append(c);
                            continue block22;
                        }
                    }
                    state = State.GAP;
                    buf.append(' ');
                    continue block22;
                }
                case GAP: {
                    switch (inType) {
                        case LETTER: {
                            state = State.WORD;
                            buf.append(c);
                            continue block22;
                        }
                        case DIGIT: {
                            state = State.NUM;
                            numBuf.append(c);
                            continue block22;
                        }
                    }
                    continue block22;
                }
                case NUM: {
                    switch (inType) {
                        case DIGIT: 
                        case PERIOD: {
                            numBuf.append(c);
                            continue block22;
                        }
                        case LETTER: {
                            state = State.WORD;
                            Utils.appendSortableNumber(buf, numBuf);
                            numBuf.setLength(0);
                            buf.append(c);
                            continue block22;
                        }
                    }
                    state = State.GAP;
                    Utils.appendSortableNumber(buf, numBuf);
                    numBuf.setLength(0);
                    buf.append(' ');
                    continue block22;
                }
            }
        }
        if (state == State.NUM) {
            Utils.appendSortableNumber(buf, numBuf);
            numBuf.setLength(0);
        }
    }

    public static void appendSortableNumber(StringBuilder buf, CharSequence num) {
        int intStart;
        int intEnd = 0;
        for (intStart = 0; intStart < num.length() && num.charAt(intStart) == '0'; ++intStart) {
        }
        while (intEnd < num.length() && num.charAt(intEnd) >= '0' && num.charAt(intEnd) <= '9') {
            ++intEnd;
        }
        buf.append(intEnd - intStart);
        buf.append(num.subSequence(intStart, num.length()));
    }

    public static String getCutterFromAuthor(String authorLastname) {
        StringBuilder sb = new StringBuilder();
        String uppername = authorLastname.toUpperCase().replaceAll("[^A-Z0-9]", "");
        char first = uppername.length() > 0 ? (char)uppername.charAt(0) : (char)' ';
        char second = uppername.length() > 1 ? (char)uppername.charAt(1) : (char)' ';
        char third = uppername.length() > 2 ? (char)uppername.charAt(2) : (char)' ';
        switch (first) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                sb.append(first);
                if (second < 'B') {
                    sb.append('1');
                } else if (second >= 'B' && second < 'D') {
                    sb.append('2');
                } else if (second >= 'D' && second < 'L') {
                    sb.append('3');
                } else if (second >= 'L' && second < 'N') {
                    sb.append('4');
                } else if (second >= 'N' && second < 'P') {
                    sb.append('5');
                } else if (second >= 'P' && second < 'R') {
                    sb.append('6');
                } else if (second >= 'R' && second < 'S') {
                    sb.append('7');
                } else if (second >= 'S' && second < 'U') {
                    sb.append('8');
                } else if (second >= 'U') {
                    sb.append('9');
                }
                Utils.addCutterExpansion(sb, third);
                break;
            }
            case 'S': {
                sb.append(first);
                if (second < 'C' || second == 'C' && third < 'H') {
                    sb.append('2');
                } else if (second >= 'C' && second < 'E') {
                    sb.append('3');
                } else if (second >= 'E' && second < 'H') {
                    sb.append('4');
                } else if (second >= 'H' && second < 'M') {
                    sb.append('5');
                } else if (second >= 'M' && second < 'T') {
                    sb.append('6');
                } else if (second >= 'T' && second < 'U') {
                    sb.append('7');
                } else if (second >= 'U' && second < 'W') {
                    sb.append('8');
                } else if (second >= 'W') {
                    sb.append('9');
                }
                Utils.addCutterExpansion(sb, third);
                break;
            }
            case 'Q': {
                sb.append(first);
                if (second >= 'U') {
                    if (third >= 'A' && third < 'E') {
                        sb.append('3');
                    } else if (third >= 'E' && third < 'I') {
                        sb.append('4');
                    } else if (third >= 'I' && third < 'O') {
                        sb.append('5');
                    } else if (third >= 'O' && third < 'R') {
                        sb.append('6');
                    } else if (third >= 'R' && third < 'T') {
                        sb.append('7');
                    } else if (third >= 'T' && third < 'Y') {
                        sb.append('8');
                    } else if (third >= 'Y') {
                        sb.append('9');
                    }
                    Utils.addCutterExpansion(sb, uppername.charAt(3));
                    break;
                }
                sb.append('2');
                Utils.addCutterExpansion(sb, third);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                sb.append("A1");
                sb.append(first);
                sb.append(second);
                break;
            }
            default: {
                sb.append(first);
                if (second >= 'A' && second < 'E') {
                    sb.append('3');
                } else if (second >= 'E' && second < 'I') {
                    sb.append('4');
                } else if (second >= 'I' && second < 'O') {
                    sb.append('5');
                } else if (second >= 'O' && second < 'R') {
                    sb.append('6');
                } else if (second >= 'R' && second < 'U') {
                    sb.append('7');
                } else if (second >= 'U' && second < 'Y') {
                    sb.append('8');
                } else if (second >= 'Y') {
                    sb.append('9');
                }
                Utils.addCutterExpansion(sb, third);
            }
        }
        return sb.toString();
    }

    private static void addCutterExpansion(StringBuilder sb, char third) {
        if (third >= 'A' && third < 'E') {
            sb.append('3');
        } else if (third >= 'E' && third < 'I') {
            sb.append('4');
        } else if (third >= 'I' && third < 'M') {
            sb.append('5');
        } else if (third >= 'M' && third < 'P') {
            sb.append('6');
        } else if (third >= 'P' && third < 'T') {
            sb.append('7');
        } else if (third >= 'T' && third < 'W') {
            sb.append('8');
        } else if (third >= 'W') {
            sb.append('9');
        }
    }

    public static String getReverseShelfKey(String shelfkey) {
        StringBuilder resultBuf = new StringBuilder(reverseDefault);
        if (shelfkey != null && shelfkey.length() > 0) {
            resultBuf.replace(0, shelfkey.length(), Utils.reverseAlphanum(shelfkey));
        }
        return resultBuf.toString();
    }

    static String reverseAlphanum(String orig) {
        char[] chs;
        StringBuilder reverse = new StringBuilder();
        for (int ix = 0; ix < orig.length(); ix += chs.length) {
            int codePoint = Character.toUpperCase(orig.codePointAt(ix));
            chs = Character.toChars(codePoint);
            if (Character.isLetterOrDigit(codePoint)) {
                if (chs.length == 1) {
                    char foldC;
                    char c = chs[0];
                    if (alphanumReverseMap.containsKey(Character.valueOf(c))) {
                        reverse.append(alphanumReverseMap.get(Character.valueOf(c)));
                        continue;
                    }
                    if (Character.UnicodeBlock.of(c) != Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS && Character.UnicodeBlock.of(c) != Character.UnicodeBlock.SPACING_MODIFIER_LETTERS && (foldC = org.solrmarc.tools.Utils.foldDiacriticLatinChar(c)) != '\u0000') {
                        reverse.append(alphanumReverseMap.get(Character.valueOf(foldC)));
                        continue;
                    }
                    reverse.append(SORT_FIRST_CHAR);
                    continue;
                }
                reverse.append(SORT_FIRST_CHAR);
                continue;
            }
            reverse.append(Utils.reverseNonAlphanum(chs[0]));
        }
        return new String(reverse);
    }

    public static char[] reverseNonAlphanum(char ch) {
        switch (ch) {
            case '.': {
                return Character.toChars(125);
            }
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return Character.toChars(32);
            }
        }
        return Character.toChars(126);
    }

    static {
        alphanumReverseMap.put(Character.valueOf('0'), Character.valueOf('Z'));
        alphanumReverseMap.put(Character.valueOf('1'), Character.valueOf('Y'));
        alphanumReverseMap.put(Character.valueOf('2'), Character.valueOf('X'));
        alphanumReverseMap.put(Character.valueOf('3'), Character.valueOf('W'));
        alphanumReverseMap.put(Character.valueOf('4'), Character.valueOf('V'));
        alphanumReverseMap.put(Character.valueOf('5'), Character.valueOf('U'));
        alphanumReverseMap.put(Character.valueOf('6'), Character.valueOf('T'));
        alphanumReverseMap.put(Character.valueOf('7'), Character.valueOf('S'));
        alphanumReverseMap.put(Character.valueOf('8'), Character.valueOf('R'));
        alphanumReverseMap.put(Character.valueOf('9'), Character.valueOf('Q'));
        alphanumReverseMap.put(Character.valueOf('A'), Character.valueOf('P'));
        alphanumReverseMap.put(Character.valueOf('B'), Character.valueOf('O'));
        alphanumReverseMap.put(Character.valueOf('C'), Character.valueOf('N'));
        alphanumReverseMap.put(Character.valueOf('D'), Character.valueOf('M'));
        alphanumReverseMap.put(Character.valueOf('E'), Character.valueOf('L'));
        alphanumReverseMap.put(Character.valueOf('F'), Character.valueOf('K'));
        alphanumReverseMap.put(Character.valueOf('G'), Character.valueOf('J'));
        alphanumReverseMap.put(Character.valueOf('H'), Character.valueOf('I'));
        alphanumReverseMap.put(Character.valueOf('I'), Character.valueOf('H'));
        alphanumReverseMap.put(Character.valueOf('J'), Character.valueOf('G'));
        alphanumReverseMap.put(Character.valueOf('K'), Character.valueOf('F'));
        alphanumReverseMap.put(Character.valueOf('L'), Character.valueOf('E'));
        alphanumReverseMap.put(Character.valueOf('M'), Character.valueOf('D'));
        alphanumReverseMap.put(Character.valueOf('N'), Character.valueOf('C'));
        alphanumReverseMap.put(Character.valueOf('O'), Character.valueOf('B'));
        alphanumReverseMap.put(Character.valueOf('P'), Character.valueOf('A'));
        alphanumReverseMap.put(Character.valueOf('Q'), Character.valueOf('9'));
        alphanumReverseMap.put(Character.valueOf('R'), Character.valueOf('8'));
        alphanumReverseMap.put(Character.valueOf('S'), Character.valueOf('7'));
        alphanumReverseMap.put(Character.valueOf('T'), Character.valueOf('6'));
        alphanumReverseMap.put(Character.valueOf('U'), Character.valueOf('5'));
        alphanumReverseMap.put(Character.valueOf('V'), Character.valueOf('4'));
        alphanumReverseMap.put(Character.valueOf('W'), Character.valueOf('3'));
        alphanumReverseMap.put(Character.valueOf('X'), Character.valueOf('2'));
        alphanumReverseMap.put(Character.valueOf('Y'), Character.valueOf('1'));
        alphanumReverseMap.put(Character.valueOf('Z'), Character.valueOf('0'));
        SORT_FIRST_CHAR = '\u0000';
        reverseDefault = new StringBuilder(75);
        for (int i = 0; i < 50; ++i) {
            reverseDefault.append(Character.toChars(126));
        }
    }

    public static enum InType {
        LETTER,
        SPACE,
        PERIOD,
        PUNCT,
        DIGIT,
        OTHER,
        END;

    }

    public static enum State {
        START,
        WORD,
        GAP,
        NUM;

    }
}

