/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.callnum;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.solrmarc.tools.Utils;

@Deprecated
public final class CallNumUtils {
    public static final Pattern DEWEY_PATTERN = Pattern.compile("^\\d{1,3}(\\.\\d+)?.*");
    public static final String LC_CLASS_REQ_REGEX = "(([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?";
    public static final String NOT_CUTTER = "([\\da-z]\\w*)|([A-Z]\\D+[\\w]*)";
    public static final String LC_CLASS_W_SUFFIX = "((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?)";
    public static final String CUTTER_REGEX = "[A-Z]\\d+";
    public static final String LC_CLASS_N_CUTTER = "((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?[A-Z]\\d+";
    public static final Pattern LC_CLASS_N_CUTTER_PATTERN = Pattern.compile("((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?[A-Z]\\d+.*");
    public static final String DEWEY_CLASS_REGEX = "\\d{1,3}(\\.\\d+)?";
    public static final String DEWEY_MIN_CUTTER_REGEX = "[A-Z]\\d{1,3}";
    public static final String DEWEY_CUTTER_TRAILING_LETTERS_REGEX = "[A-Z]\\d{1,3}[A-Z]+";
    public static final String DEWEY_CUTTER_SPACE_TRAILING_LETTERS_REGEX = "[A-Z]\\d{1,3} +[A-Z]+";
    public static final String DEWEY_FULL_CUTTER_REGEX = "[A-Z]\\d{1,3} *[A-Z]*+";
    public static final String DEWEY_CLASS_N_CUTTER_REGEX = "\\d{1,3}(\\.\\d+)? *\\.?[A-Z]\\d{1,3} *[A-Z]*+";
    public static final Pattern DEWEY_CLASS_N_CUTTER_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d+)? *\\.?[A-Z]\\d{1,3} *[A-Z]*+.*");
    private static Map<Character, Character> alphanumReverseMap = new HashMap<Character, Character>();
    public static char SORT_FIRST_CHAR;
    public static StringBuilder reverseDefault;
    private static String PUNCT_PREFIX;
    private static String NS_PREFIX;
    private static String MONTHS;
    private static String VOL_LETTERS;
    private static String VOL_NUMBERS;
    private static String VOL_NUMBERS_LOOSER;
    private static String VOL_NUM_AS_LETTERS;
    private static Pattern VOL_PATTERN;
    private static Pattern VOL_PATTERN_LOOSER;
    private static Pattern VOL_PATTERN_LETTERS;

    private CallNumUtils() {
    }

    public static final boolean isValidLC(String possLCval) {
        return possLCval != null && LC_CLASS_N_CUTTER_PATTERN.matcher(possLCval.trim()).matches();
    }

    public static final boolean isValidDeweyWithCutter(String possDeweyVal) {
        return possDeweyVal != null && DEWEY_CLASS_N_CUTTER_PATTERN.matcher(possDeweyVal.trim()).matches();
    }

    public static final boolean isValidDewey(String possDeweyVal) {
        return possDeweyVal != null && DEWEY_PATTERN.matcher(possDeweyVal.trim()).matches();
    }

    public static final String getPortionBeforeCutter(String callnum) {
        String beginCutterRegex = "( +|(\\.[A-Z])| */)";
        String[] pieces = callnum.split(beginCutterRegex);
        if (pieces.length == 0 || pieces[0] == null || pieces[0].length() == 0) {
            return null;
        }
        return pieces[0].trim();
    }

    public static final String getLCB4FirstCutter(String callnum) {
        String result = null;
        String cutter = CallNumUtils.getFirstLCcutter(callnum);
        if (cutter != null && cutter.length() > 0) {
            String lets;
            int ix = callnum.indexOf(cutter);
            if (ix < (lets = CallNumUtils.getLCstartLetters(callnum)).length()) {
                ix = callnum.indexOf(cutter, lets.length());
            }
            if (ix > 0) {
                result = callnum.substring(0, ix).trim();
                if (result.endsWith(".")) {
                    result = result.substring(0, result.length() - 1).trim();
                }
            } else {
                result = callnum;
            }
        } else {
            result = callnum;
        }
        return result;
    }

    public static String getLCstartLetters(String rawLCcallnum) {
        String[] lcClass;
        String result = null;
        if (rawLCcallnum != null && rawLCcallnum.length() > 0 && (lcClass = rawLCcallnum.split("[^A-Z]+")).length > 0) {
            result = lcClass[0];
        }
        return result;
    }

    public static String getLCClassDigits(String rawLCcallnum) {
        String[] pieces;
        String result = null;
        String rawClass = CallNumUtils.getLCB4FirstCutter(rawLCcallnum);
        if (rawClass != null && rawClass.length() > 0 && (pieces = rawClass.split("[A-Z ]+")).length > 1) {
            result = pieces[1].trim();
        }
        return result;
    }

    public static String getLCClassSuffix(String rawLCcallnum) {
        String result = null;
        String b4cutter = CallNumUtils.getLCB4FirstCutter(rawLCcallnum);
        if (b4cutter == null || b4cutter.length() == 0) {
            return null;
        }
        String classDigits = CallNumUtils.getLCClassDigits(rawLCcallnum);
        if (classDigits != null && classDigits.length() > 0) {
            int reqClassLen = b4cutter.indexOf(classDigits) + classDigits.length();
            if (b4cutter.length() > reqClassLen) {
                result = b4cutter.substring(reqClassLen).trim();
            }
        }
        return result;
    }

    public static String getFirstLCcutter(String rawCallnum) {
        String result = null;
        String regex = "((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?([A-Z]\\d+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(rawCallnum);
        if (matcher.find()) {
            result = matcher.group(9).trim();
        }
        if (result == null) {
            String possible;
            int i = rawCallnum.trim().lastIndexOf(46);
            if (i == -1) {
                i = rawCallnum.trim().lastIndexOf(32);
            }
            if (rawCallnum.trim().length() > i + 1 && Character.isLetter((possible = rawCallnum.trim().substring(i + 1).trim()).charAt(0))) {
                result = possible;
            }
        }
        return result;
    }

    public static String getFirstLCcutterSuffix(String rawLCcallnum) {
        String result = null;
        String regex = "((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?[A-Z]\\d+ *(([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(rawLCcallnum);
        if (matcher.find() && matcher.groupCount() > 5 && matcher.group(6) != null && matcher.group(6).length() > 0) {
            result = matcher.group(6).trim();
            int endLastIx = matcher.end(6);
            if (endLastIx < rawLCcallnum.length()) {
                Pattern cutterPat = Pattern.compile(" *\\.[A-Z]\\d+");
                matcher.usePattern(cutterPat);
                if (matcher.find(endLastIx)) {
                    if (endLastIx < matcher.start()) {
                        result = result.trim() + " " + rawLCcallnum.substring(endLastIx, matcher.start()).trim();
                    }
                } else {
                    result = result + rawLCcallnum.substring(endLastIx);
                }
            }
        } else {
            String afterLCclassNCutter = rawLCcallnum.replaceFirst("((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?[A-Z]\\d+ *", "");
            String cutterRegex = "((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?[A-Z]\\d+ *(.*)\\.[A-Z]\\d+";
            pattern = Pattern.compile(cutterRegex);
            matcher = pattern.matcher(rawLCcallnum);
            if (matcher.find() && matcher.groupCount() > 5 && matcher.group(6) != null && matcher.group(6).length() > 0) {
                result = matcher.group(6).trim();
            } else {
                regex = "((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?[A-Z]\\d+ \\.\\.\\.$";
                pattern = Pattern.compile(regex);
                matcher = pattern.matcher(rawLCcallnum);
                if (matcher.find()) {
                    result = " ...";
                }
            }
        }
        return result;
    }

    public static String getSecondLCcutter(String rawLCcallnum) {
        String result = null;
        String firstCutSuffix = CallNumUtils.getFirstLCcutterSuffix(rawLCcallnum);
        if (firstCutSuffix == null || firstCutSuffix.length() == 0) {
            String regex = "((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?[A-Z]\\d+ *\\.?([A-Z]\\d+)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(rawLCcallnum);
            if (matcher.find() && matcher.groupCount() > 5 && matcher.group(6) != null && matcher.group(6).length() > 0) {
                result = matcher.group(6).trim();
            }
        } else {
            Pattern pattern;
            Matcher matcher;
            int ix = rawLCcallnum.indexOf(firstCutSuffix) + firstCutSuffix.length();
            if (ix < rawLCcallnum.length()) {
                String remaining = rawLCcallnum.substring(ix).trim();
                Pattern pattern2 = Pattern.compile("([A-Z]\\d+)");
                Matcher matcher2 = pattern2.matcher(remaining);
                if (matcher2.find() && matcher2.group(1) != null && matcher2.group(1).length() > 0) {
                    result = matcher2.group(1).trim();
                }
            }
            if (result == null && (matcher = (pattern = Pattern.compile("\\.([A-Z]\\d+)")).matcher(firstCutSuffix)).find() && matcher.group(1) != null && matcher.group(1).length() > 0) {
                result = matcher.group(1).trim();
            }
        }
        return result;
    }

    public static String getSecondLCcutterSuffix(String rawLCcallnum) {
        int ix;
        String result = null;
        String secondCutter = CallNumUtils.getSecondLCcutter(rawLCcallnum);
        if (secondCutter != null && secondCutter.length() > 0 && (ix = rawLCcallnum.indexOf(secondCutter) + secondCutter.length()) < rawLCcallnum.length()) {
            result = rawLCcallnum.substring(ix).trim();
        }
        return result;
    }

    public static String getSecondLCcutterYearSuffix(String rawLCcallnum) {
        String result = null;
        String regex = "((([B-Z&&[^IOWXY]]{1}[A-Z]{0,2})|(A[CEGIMNPSYZ])) *\\d+(\\.\\d+)?( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))?) *\\.?[A-Z]\\d+ *(([\\da-z]\\w*)|([A-Z]\\D+[\\w]*))*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(rawLCcallnum);
        if (matcher.find() && matcher.groupCount() > 5 && matcher.group(6) != null && matcher.group(6).length() > 0) {
            result = matcher.group(6);
            int endLastIx = matcher.end(6);
            if (endLastIx < rawLCcallnum.length()) {
                Pattern cutterPat = Pattern.compile(" *\\.?[A-Z]\\d+.*");
                matcher.usePattern(cutterPat);
                if (matcher.find(endLastIx)) {
                    if (endLastIx < matcher.start()) {
                        result = result.trim() + " " + rawLCcallnum.substring(endLastIx, matcher.start()).trim();
                    }
                } else {
                    result = result.trim() + rawLCcallnum.substring(endLastIx);
                }
            }
        }
        return result;
    }

    public static final String getDeweyB4Cutter(String callnum) {
        String result = null;
        String entireCallNumRegex = "(\\d{1,3}(\\.\\d+)?).*";
        Pattern pattern = Pattern.compile(entireCallNumRegex);
        Matcher matcher = pattern.matcher(callnum);
        if (matcher.find()) {
            result = matcher.group(1).trim();
        }
        return result;
    }

    public static String getDeweyCutter(String rawCallnum) {
        String result = null;
        String regex1 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3}[A-Z]+)( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*).*)";
        String regex2 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3})( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*).*)";
        String regex3 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3} +[A-Z]+)( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*).*)";
        String regex4 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3}[A-Z]+)(.*)";
        String regex5 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3})(.*)";
        String regex6 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3} +[A-Z]+)(.*)";
        Pattern pat1 = Pattern.compile(regex1);
        Pattern pat2 = Pattern.compile(regex2);
        Pattern pat3 = Pattern.compile(regex3);
        Pattern pat4 = Pattern.compile(regex4);
        Pattern pat5 = Pattern.compile(regex5);
        Pattern pat6 = Pattern.compile(regex6);
        Matcher matcher = pat1.matcher(rawCallnum);
        if (!matcher.find() && !(matcher = pat2.matcher(rawCallnum)).find()) {
            matcher = pat3.matcher(rawCallnum);
        }
        if (matcher.find()) {
            int ix;
            String cutter = matcher.group(2);
            String suffix = matcher.group(3);
            result = suffix.length() == 0 ? cutter.trim() : (suffix.startsWith(" ") || cutter.endsWith(" ") ? cutter.trim() : ((ix = cutter.lastIndexOf(32)) != -1 ? cutter.substring(0, ix) : cutter.trim()));
        } else {
            matcher = pat4.matcher(rawCallnum);
            if (matcher.find()) {
                result = matcher.group(2);
            } else {
                matcher = pat5.matcher(rawCallnum);
                if (matcher.find()) {
                    result = matcher.group(2);
                } else {
                    matcher = pat6.matcher(rawCallnum);
                    if (matcher.find()) {
                        result = matcher.group(2);
                    }
                }
            }
        }
        if (result != null) {
            return result.trim();
        }
        return result;
    }

    public static String getDeweyCutterSuffix(String rawCallnum) {
        if (rawCallnum == null || rawCallnum.length() == 0) {
            return null;
        }
        String result = null;
        String cutter = CallNumUtils.getDeweyCutter(rawCallnum);
        if (cutter != null) {
            int ix = rawCallnum.indexOf(cutter) + cutter.length();
            result = rawCallnum.substring(ix).trim();
        }
        if (result == null || result.length() == 0) {
            String regex1 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3}[A-Z]+)( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*).*)";
            String regex2 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3})( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*).*)";
            String regex3 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3} +[A-Z]+)( +([\\da-z]\\w*)|([A-Z]\\D+[\\w]*).*)";
            String regex4 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3}[A-Z]+)(.*)";
            String regex5 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3})(.*)";
            String regex6 = "\\d{1,3}(\\.\\d+)? *\\.?([A-Z]\\d{1,3} +[A-Z]+)(.*)";
            Pattern pat1 = Pattern.compile(regex1);
            Pattern pat2 = Pattern.compile(regex2);
            Pattern pat3 = Pattern.compile(regex3);
            Pattern pat4 = Pattern.compile(regex4);
            Pattern pat5 = Pattern.compile(regex5);
            Pattern pat6 = Pattern.compile(regex6);
            Matcher matcher = pat1.matcher(rawCallnum);
            if (!(matcher.find() || (matcher = pat2.matcher(rawCallnum)).find() || (matcher = pat3.matcher(rawCallnum)).find() || (matcher = pat4.matcher(rawCallnum)).find() || (matcher = pat5.matcher(rawCallnum)).find())) {
                matcher = pat6.matcher(rawCallnum);
            }
            if (matcher.find(0)) {
                cutter = matcher.group(2);
                String suffix = matcher.group(3);
                if (suffix.trim().length() > 0) {
                    int ix;
                    result = suffix.startsWith(" ") || cutter.endsWith(" ") ? suffix : ((ix = cutter.lastIndexOf(32)) != -1 ? cutter.substring(ix) + suffix : suffix);
                }
            }
        }
        if (result != null) {
            result = result.trim();
        }
        if (result == null || result.trim().length() == 0) {
            return null;
        }
        return result;
    }

    public static String normalizeCallnum(String rawCallnum) {
        String normalizedCallnum = rawCallnum.trim().replaceAll("\\s\\s+", " ");
        normalizedCallnum = normalizedCallnum.replaceAll("\\. \\.", " .");
        if ((normalizedCallnum = normalizedCallnum.replaceAll("(\\d+\\.) ([A-Z])", "$1$2")).endsWith(".")) {
            normalizedCallnum = normalizedCallnum.substring(0, normalizedCallnum.length() - 1).trim();
        }
        return normalizedCallnum;
    }

    static String normalizeLCcallnum(String rawLCcallnum) {
        String normCallnum = CallNumUtils.normalizeCallnum(rawLCcallnum);
        return normCallnum.replaceAll("^([A-Z][A-Z]?[A-Z]?) ([0-9])", "$1$2");
    }

    public static String getLCShelfkey(String rawLCcallnum, String recid) {
        StringBuilder resultBuf = new StringBuilder();
        String upcaseLCcallnum = rawLCcallnum.toUpperCase();
        StringBuilder initLetBuf = new StringBuilder("    ");
        String lets = CallNumUtils.getLCstartLetters(upcaseLCcallnum);
        if (lets == null) {
            if (recid != null && !rawLCcallnum.startsWith("XX")) {
                throw new IllegalArgumentException("Problem creating shelfkey for record " + recid + "; call number: " + rawLCcallnum);
            }
            return rawLCcallnum + " ";
        }
        initLetBuf.replace(0, lets.length(), lets);
        resultBuf.append((CharSequence)initLetBuf);
        try {
            String firstCutter;
            String digitStr = CallNumUtils.getLCClassDigits(upcaseLCcallnum);
            if (digitStr != null && !digitStr.equals(".")) {
                resultBuf.append(CallNumUtils.normalizeFloat(digitStr, 4, 6));
            } else {
                resultBuf.append(CallNumUtils.normalizeFloat("0", 4, 6));
            }
            String classSuffix = CallNumUtils.getLCClassSuffix(upcaseLCcallnum);
            if (classSuffix != null) {
                resultBuf.append(" " + CallNumUtils.normalizeSuffix(classSuffix));
            }
            if ((firstCutter = CallNumUtils.getFirstLCcutter(upcaseLCcallnum)) != null) {
                String secondCutter;
                resultBuf.append(" " + CallNumUtils.normalizeCutter(firstCutter, 6));
                String firstCutterSuffix = CallNumUtils.getFirstLCcutterSuffix(upcaseLCcallnum);
                if (firstCutterSuffix != null) {
                    resultBuf.append(" " + CallNumUtils.normalizeSuffix(firstCutterSuffix));
                }
                if ((secondCutter = CallNumUtils.getSecondLCcutter(upcaseLCcallnum)) != null) {
                    resultBuf.append(" " + CallNumUtils.normalizeCutter(secondCutter, 6));
                    String secondCutterSuffix = CallNumUtils.getSecondLCcutterSuffix(upcaseLCcallnum);
                    if (secondCutterSuffix != null) {
                        resultBuf.append(" " + CallNumUtils.normalizeSuffix(secondCutterSuffix));
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            if (recid != null && !rawLCcallnum.startsWith("XX")) {
                throw new IllegalArgumentException("Problem creating shelfkey for record " + recid + "; call number: " + rawLCcallnum);
            }
            resultBuf = new StringBuilder();
        }
        if (resultBuf.length() == 0) {
            resultBuf.append(upcaseLCcallnum);
        }
        return resultBuf.toString().trim();
    }

    private static String normalizeCutter(String cutter, int numDigits) {
        String result = null;
        if (cutter != null && cutter.length() > 0) {
            String cutLets = CallNumUtils.getLCstartLetters(cutter);
            String cutDigs = cutter.substring(cutLets == null ? 0 : cutLets.length());
            String norm = null;
            if (cutDigs != null && cutDigs.length() > 0) {
                try {
                    Integer.parseInt(cutDigs);
                    norm = CallNumUtils.normalizeFloat("." + cutDigs, 1, numDigits);
                }
                catch (NumberFormatException e) {
                    norm = cutDigs;
                }
            } else if (cutDigs.length() == 0 && cutLets.length() == 1) {
                norm = CallNumUtils.normalizeFloat("0", 1, numDigits);
            }
            result = cutLets + norm;
        }
        return result;
    }

    public static String normalizeSuffix(String suffix) {
        if (suffix != null && suffix.length() > 0) {
            StringBuilder resultBuf = new StringBuilder(suffix.length());
            String[] digitStrs = suffix.split("[\\D]+");
            int len = digitStrs.length;
            if (digitStrs != null && len != 0) {
                int s = 0;
                for (int d = 0; d < len; ++d) {
                    String digitStr = digitStrs[d];
                    int ix = suffix.indexOf(digitStr, s);
                    if (s < ix) {
                        String text = suffix.substring(s, ix);
                        resultBuf.append(text);
                    }
                    if (digitStr == null || digitStr.length() == 0) continue;
                    resultBuf.append(CallNumUtils.normalizeFloat(digitStr, 6, 0));
                    s = ix + digitStr.length();
                }
                resultBuf.append(suffix.substring(s));
                return resultBuf.toString();
            }
        }
        return suffix;
    }

    public static String getReverseShelfKey(String shelfkey) {
        StringBuilder resultBuf = new StringBuilder(reverseDefault);
        if (shelfkey != null && shelfkey.length() > 0) {
            resultBuf.replace(0, shelfkey.length(), CallNumUtils.reverseAlphanum(shelfkey));
        }
        return resultBuf.toString();
    }

    static String reverseAlphanum(String orig) {
        char[] chs;
        StringBuilder reverse = new StringBuilder();
        for (int ix = 0; ix < orig.length(); ix += chs.length) {
            int codePoint = Character.toUpperCase(orig.codePointAt(ix));
            chs = Character.toChars(codePoint);
            if (Character.isLetterOrDigit(codePoint)) {
                if (chs.length == 1) {
                    char foldC;
                    char c = chs[0];
                    if (alphanumReverseMap.containsKey(Character.valueOf(c))) {
                        reverse.append(alphanumReverseMap.get(Character.valueOf(c)));
                        continue;
                    }
                    if (Character.UnicodeBlock.of(c) != Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS && Character.UnicodeBlock.of(c) != Character.UnicodeBlock.SPACING_MODIFIER_LETTERS && (foldC = Utils.foldDiacriticLatinChar(c)) != '\u0000') {
                        reverse.append(alphanumReverseMap.get(Character.valueOf(foldC)));
                        continue;
                    }
                    reverse.append(SORT_FIRST_CHAR);
                    continue;
                }
                reverse.append(SORT_FIRST_CHAR);
                continue;
            }
            reverse.append(CallNumUtils.reverseNonAlphanum(chs[0]));
        }
        return new String(reverse);
    }

    public static char[] reverseNonAlphanum(char ch) {
        switch (ch) {
            case '.': {
                return Character.toChars(125);
            }
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return Character.toChars(32);
            }
        }
        return Character.toChars(126);
    }

    public static String getDeweyShelfKey(String rawDeweyCallnum) {
        String cutterSuffix;
        StringBuilder resultBuf = new StringBuilder();
        String classNum = CallNumUtils.normalizeFloat(CallNumUtils.getDeweyB4Cutter(rawDeweyCallnum), 3, 8);
        resultBuf.append(classNum);
        String cutter = CallNumUtils.getDeweyCutter(rawDeweyCallnum);
        if (cutter != null) {
            resultBuf.append(" " + cutter);
        }
        if ((cutterSuffix = CallNumUtils.getDeweyCutterSuffix(rawDeweyCallnum)) != null) {
            resultBuf.append(" " + CallNumUtils.normalizeSuffix(cutterSuffix));
        }
        if (resultBuf.length() == 0) {
            resultBuf.append(rawDeweyCallnum);
        }
        return resultBuf.toString().trim();
    }

    public static String normalizeFloat(String floatStr, int digitsB4, int digitsAfter) {
        double value = Double.valueOf(floatStr);
        String formatStr = CallNumUtils.getFormatString(digitsB4) + '.' + CallNumUtils.getFormatString(digitsAfter);
        DecimalFormat normFormat = new DecimalFormat(formatStr);
        String norm = normFormat.format(value);
        if (norm.endsWith(".")) {
            norm = norm.substring(0, norm.length() - 1);
        }
        return norm;
    }

    public static String removeLCVolSuffix(String rawLCcallnum) {
        String cut1suffix;
        String suffix = CallNumUtils.getSecondLCcutterSuffix(rawLCcallnum);
        if ((suffix == null || suffix.length() == 0) && (cut1suffix = CallNumUtils.getFirstLCcutterSuffix(rawLCcallnum)) != null) {
            int ix;
            String cut2 = CallNumUtils.getSecondLCcutter(rawLCcallnum);
            suffix = cut2 != null ? ((ix = cut1suffix.indexOf(cut2)) != -1 ? cut1suffix.substring(0, ix) : cut1suffix) : cut1suffix;
        }
        if (suffix != null && suffix.length() > 0) {
            int ix;
            Matcher matcher = VOL_PATTERN.matcher(suffix);
            if (!matcher.find() && !(matcher = VOL_PATTERN_LOOSER.matcher(suffix)).find()) {
                matcher = VOL_PATTERN_LETTERS.matcher(suffix);
            }
            if (matcher.find(0) && (ix = rawLCcallnum.indexOf(suffix) + matcher.start()) != -1 && ix < rawLCcallnum.length()) {
                return rawLCcallnum.substring(0, ix).trim();
            }
        }
        return rawLCcallnum;
    }

    public static String removeDeweyVolSuffix(String rawDeweyCallnum) {
        int ix;
        String cutSuffix = CallNumUtils.getDeweyCutterSuffix(rawDeweyCallnum);
        if (cutSuffix == null || cutSuffix.length() == 0) {
            return rawDeweyCallnum;
        }
        Matcher matcher = VOL_PATTERN.matcher(cutSuffix);
        if (!matcher.find() && !(matcher = VOL_PATTERN_LOOSER.matcher(cutSuffix)).find()) {
            matcher = VOL_PATTERN_LETTERS.matcher(cutSuffix);
        }
        if (matcher.find(0) && (ix = rawDeweyCallnum.indexOf(cutSuffix) + matcher.start()) != -1 && ix < rawDeweyCallnum.length()) {
            return rawDeweyCallnum.substring(0, ix).trim();
        }
        return rawDeweyCallnum;
    }

    public static String addLeadingZeros(String deweyCallNum) {
        String result = deweyCallNum;
        String b4Cutter = CallNumUtils.getPortionBeforeCutter(deweyCallNum);
        String b4dec = null;
        int decIx = b4Cutter.indexOf(".");
        b4dec = decIx >= 0 ? deweyCallNum.substring(0, decIx).trim() : b4Cutter.trim();
        if (b4dec != null) {
            switch (b4dec.length()) {
                case 1: {
                    result = "00" + deweyCallNum;
                    break;
                }
                case 2: {
                    result = "0" + deweyCallNum;
                }
            }
        }
        return result;
    }

    private static String getFormatString(int numDigits) {
        StringBuilder b4 = new StringBuilder();
        if (numDigits < 0) {
            b4.append("############");
        } else if (numDigits > 0) {
            for (int i = 0; i < numDigits; ++i) {
                b4.append('0');
            }
        }
        return b4.toString();
    }

    static {
        alphanumReverseMap.put(Character.valueOf('0'), Character.valueOf('Z'));
        alphanumReverseMap.put(Character.valueOf('1'), Character.valueOf('Y'));
        alphanumReverseMap.put(Character.valueOf('2'), Character.valueOf('X'));
        alphanumReverseMap.put(Character.valueOf('3'), Character.valueOf('W'));
        alphanumReverseMap.put(Character.valueOf('4'), Character.valueOf('V'));
        alphanumReverseMap.put(Character.valueOf('5'), Character.valueOf('U'));
        alphanumReverseMap.put(Character.valueOf('6'), Character.valueOf('T'));
        alphanumReverseMap.put(Character.valueOf('7'), Character.valueOf('S'));
        alphanumReverseMap.put(Character.valueOf('8'), Character.valueOf('R'));
        alphanumReverseMap.put(Character.valueOf('9'), Character.valueOf('Q'));
        alphanumReverseMap.put(Character.valueOf('A'), Character.valueOf('P'));
        alphanumReverseMap.put(Character.valueOf('B'), Character.valueOf('O'));
        alphanumReverseMap.put(Character.valueOf('C'), Character.valueOf('N'));
        alphanumReverseMap.put(Character.valueOf('D'), Character.valueOf('M'));
        alphanumReverseMap.put(Character.valueOf('E'), Character.valueOf('L'));
        alphanumReverseMap.put(Character.valueOf('F'), Character.valueOf('K'));
        alphanumReverseMap.put(Character.valueOf('G'), Character.valueOf('J'));
        alphanumReverseMap.put(Character.valueOf('H'), Character.valueOf('I'));
        alphanumReverseMap.put(Character.valueOf('I'), Character.valueOf('H'));
        alphanumReverseMap.put(Character.valueOf('J'), Character.valueOf('G'));
        alphanumReverseMap.put(Character.valueOf('K'), Character.valueOf('F'));
        alphanumReverseMap.put(Character.valueOf('L'), Character.valueOf('E'));
        alphanumReverseMap.put(Character.valueOf('M'), Character.valueOf('D'));
        alphanumReverseMap.put(Character.valueOf('N'), Character.valueOf('C'));
        alphanumReverseMap.put(Character.valueOf('O'), Character.valueOf('B'));
        alphanumReverseMap.put(Character.valueOf('P'), Character.valueOf('A'));
        alphanumReverseMap.put(Character.valueOf('Q'), Character.valueOf('9'));
        alphanumReverseMap.put(Character.valueOf('R'), Character.valueOf('8'));
        alphanumReverseMap.put(Character.valueOf('S'), Character.valueOf('7'));
        alphanumReverseMap.put(Character.valueOf('T'), Character.valueOf('6'));
        alphanumReverseMap.put(Character.valueOf('U'), Character.valueOf('5'));
        alphanumReverseMap.put(Character.valueOf('V'), Character.valueOf('4'));
        alphanumReverseMap.put(Character.valueOf('W'), Character.valueOf('3'));
        alphanumReverseMap.put(Character.valueOf('X'), Character.valueOf('2'));
        alphanumReverseMap.put(Character.valueOf('Y'), Character.valueOf('1'));
        alphanumReverseMap.put(Character.valueOf('Z'), Character.valueOf('0'));
        SORT_FIRST_CHAR = '\u0000';
        reverseDefault = new StringBuilder(75);
        for (int i = 0; i < 50; ++i) {
            reverseDefault.append(Character.toChars(126));
        }
        PUNCT_PREFIX = "([\\.:\\/])?";
        NS_PREFIX = "(n\\.s\\.?\\,? ?)?";
        MONTHS = "jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec";
        VOL_LETTERS = "[\\:\\/]?(bd|iss|jahrg|new ser|no|part|pts?|ser|t|v|vols?|vyp|" + MONTHS + ")";
        VOL_NUMBERS = "\\d+([\\/-]\\d+)?( \\d{4}([\\/-]\\d{4})?)?( ?suppl\\.?)?";
        VOL_NUMBERS_LOOSER = "\\d+.*";
        VOL_NUM_AS_LETTERS = "[A-Z]([\\/-]\\[A-Z]+)?.*";
        VOL_PATTERN = Pattern.compile(PUNCT_PREFIX + NS_PREFIX + VOL_LETTERS + "\\.? ?" + VOL_NUMBERS, 2);
        VOL_PATTERN_LOOSER = Pattern.compile(PUNCT_PREFIX + NS_PREFIX + VOL_LETTERS + "\\.? ?" + VOL_NUMBERS_LOOSER, 2);
        VOL_PATTERN_LETTERS = Pattern.compile(PUNCT_PREFIX + NS_PREFIX + VOL_LETTERS + "[\\/\\. ]" + VOL_NUM_AS_LETTERS, 2);
    }
}

