/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.marc4j.MarcCombiningReader;
import org.marc4j.MarcReader;
import org.marc4j.MarcSplitStreamWriter;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;
import org.marc4j.util.RawRecord;
import org.marc4j.util.RawRecordReader;
import org.marc4j.util.StringNaturalCompare;

public class MergeSummaryHoldings
implements MarcReader {
    public static String DEFAULT_MHLD_FLDS_TO_MERGE = "852|853|863|866|867|868";
    public static Comparator<String> ID_COMPARATOR = new StringNaturalCompare();
    static boolean verbose = false;
    static boolean veryverbose = false;
    private boolean permissive;
    private boolean toUtf8;
    private String defaultEncoding = null;
    private String mhldFldsToMerge = null;
    private RawRecordReader bibRecsRawRecRdr = null;
    private MarcReader bibRecsMarcReader = null;
    private String mhldRecsFileName;
    private RawRecordReader mhldRawRecRdr = null;
    private RawRecord currentMhldRec = null;
    private RawRecord unmatchedPrevMhldRec = null;
    private String prevMhldRecID = null;

    public MergeSummaryHoldings(RawRecordReader bibRecsRawRecRdr, boolean permissive, boolean toUtf8, String defaultEncoding, String mhldRecsFileName, String mhldFldsToMerge) {
        this.bibRecsRawRecRdr = bibRecsRawRecRdr;
        this.bibRecsMarcReader = null;
        this.mhldRecsFileName = mhldRecsFileName;
        this.permissive = permissive;
        this.toUtf8 = toUtf8;
        this.defaultEncoding = defaultEncoding;
        this.mhldFldsToMerge = mhldFldsToMerge;
        System.setProperty("org.marc4j.marc.MarcFactory", "org.solrmarc.marcoverride.NoSortMarcFactoryImpl");
        this.readMhldFileFromBeginning(mhldRecsFileName);
    }

    public MergeSummaryHoldings(RawRecordReader bibRecsRawRecRdr, String mhldRecsFileName, String mhldFldsToMerge) {
        this(bibRecsRawRecRdr, true, false, "MARC8", mhldRecsFileName, mhldFldsToMerge);
    }

    public MergeSummaryHoldings(MarcReader bibRecsRawRecRdr, String mhldRecsFileName, String mhldFldsToMerge) {
        this.bibRecsRawRecRdr = null;
        this.bibRecsMarcReader = bibRecsRawRecRdr;
        this.mhldRecsFileName = mhldRecsFileName;
        this.mhldFldsToMerge = mhldFldsToMerge;
        this.readMhldFileFromBeginning(mhldRecsFileName);
    }

    private void readMhldFileFromBeginning(String mhldRecsFileName) {
        try {
            this.mhldRawRecRdr = new RawRecordReader(new FileInputStream(new File(mhldRecsFileName)));
        }
        catch (FileNotFoundException e) {
            System.err.println("No file found at " + mhldRecsFileName);
            this.mhldRawRecRdr = null;
        }
        this.prevMhldRecID = null;
        this.unmatchedPrevMhldRec = null;
    }

    @Override
    public boolean hasNext() {
        if (this.bibRecsRawRecRdr != null) {
            return this.bibRecsRawRecRdr.hasNext();
        }
        if (this.bibRecsMarcReader != null) {
            return this.bibRecsMarcReader.hasNext();
        }
        return false;
    }

    @Override
    public Record next() {
        Record bibRec = null;
        if (this.bibRecsRawRecRdr != null) {
            RawRecord rawrec = this.bibRecsRawRecRdr.next();
            bibRec = rawrec.getAsRecord(this.permissive, this.toUtf8, "999", this.defaultEncoding);
        } else if (this.bibRecsMarcReader != null) {
            bibRec = this.bibRecsMarcReader.next();
        }
        RawRecord matchingRawMhldRec = this.getMatchingMhldRawRec(bibRec.getControlNumber());
        if (matchingRawMhldRec != null) {
            bibRec = this.addMhldFieldsToBibRec(bibRec, matchingRawMhldRec);
        }
        return bibRec;
    }

    private RawRecord getNextMhld() {
        if (this.mhldRawRecRdr != null) {
            if (this.mhldRawRecRdr.hasNext()) {
                this.currentMhldRec = this.mhldRawRecRdr.next();
            } else {
                this.readMhldFileFromBeginning(this.mhldRecsFileName);
            }
            return this.currentMhldRec;
        }
        return null;
    }

    private RawRecord getMatchingMhldRawRec(String bibRecID) {
        if (this.prevMhldRecID != null && ID_COMPARATOR.compare(this.prevMhldRecID, bibRecID) > 0) {
            this.readMhldFileFromBeginning(this.mhldRecsFileName);
        }
        if (this.unmatchedPrevMhldRec == null && this.mhldRawRecRdr != null && this.mhldRawRecRdr.hasNext()) {
            this.unmatchedPrevMhldRec = this.mhldRawRecRdr.next();
        }
        while (this.mhldRawRecRdr != null && this.mhldRawRecRdr.hasNext() && ID_COMPARATOR.compare(this.unmatchedPrevMhldRec.getRecordId(), bibRecID) < 0) {
            this.prevMhldRecID = this.unmatchedPrevMhldRec.getRecordId();
            this.unmatchedPrevMhldRec = this.mhldRawRecRdr.next();
        }
        if (this.unmatchedPrevMhldRec != null && ID_COMPARATOR.compare(this.unmatchedPrevMhldRec.getRecordId(), bibRecID) == 0) {
            RawRecord matchingMhldRec = this.unmatchedPrevMhldRec;
            this.unmatchedPrevMhldRec = null;
            this.prevMhldRecID = matchingMhldRec.getRecordId();
            return matchingMhldRec;
        }
        return null;
    }

    private Record addMhldFieldsToBibRec(Record bibRecord, RawRecord rawMhldRecord) {
        Record mhldRecord = rawMhldRecord.getAsRecord(this.permissive, this.toUtf8, this.mhldFldsToMerge, this.defaultEncoding);
        List<VariableField> lvf = bibRecord.getVariableFields(this.mhldFldsToMerge.split("[|]"));
        for (VariableField vf : lvf) {
            bibRecord.removeVariableField(vf);
        }
        bibRecord = MarcCombiningReader.combineRecords(bibRecord, mhldRecord, this.mhldFldsToMerge, "999");
        return bibRecord;
    }

    public static Map<String, Record> mergeMhldsIntoBibRecordsAsMap(String bibRecsFileName, String mhldRecsFileName) throws IOException {
        HashMap<String, Record> results = new HashMap<String, Record>();
        RawRecordReader bibsRawRecRdr = new RawRecordReader(new FileInputStream(new File(bibRecsFileName)));
        boolean permissive = true;
        boolean toUtf8 = false;
        MergeSummaryHoldings merger = new MergeSummaryHoldings(bibsRawRecRdr, permissive, toUtf8, "MARC8", mhldRecsFileName, DEFAULT_MHLD_FLDS_TO_MERGE);
        verbose = true;
        veryverbose = true;
        while (merger.hasNext()) {
            Record bibRecWithPossChanges = merger.next();
            results.put(bibRecWithPossChanges.getControlNumber(), bibRecWithPossChanges);
        }
        return results;
    }

    public static void mergeMhldRecsIntoBibRecsAsStdOut2(String bibRecsFileName, String mhldRecsFileName, OutputStream outstream) throws IOException {
        RawRecordReader bibsRawRecRdr = new RawRecordReader(new FileInputStream(new File(bibRecsFileName)));
        boolean permissive = true;
        boolean toUtf8 = false;
        MergeSummaryHoldings merger = new MergeSummaryHoldings(bibsRawRecRdr, permissive, toUtf8, "MARC8", mhldRecsFileName, DEFAULT_MHLD_FLDS_TO_MERGE);
        verbose = true;
        veryverbose = true;
        MarcSplitStreamWriter writer = new MarcSplitStreamWriter(outstream, "per_record", 70000, "999");
        while (merger.hasNext()) {
            Record bibRecWithPossChanges = merger.next();
            writer.write(bibRecWithPossChanges);
            outstream.flush();
        }
    }

    private static void mergeMhldsIntoBibRecsAsStdOut(RawRecordReader bibsRawRecRdr, String mhldRecsFileName, boolean outputAllBibs) {
        MergeSummaryHoldings merger = new MergeSummaryHoldings(bibsRawRecRdr, true, false, "MARC8", mhldRecsFileName, DEFAULT_MHLD_FLDS_TO_MERGE);
        RawRecord rawBibRecCurrent = null;
        RawRecord matchingRawMhldRec = null;
        MarcSplitStreamWriter writer = new MarcSplitStreamWriter(System.out, "per_record", 70000, "999");
        while (bibsRawRecRdr.hasNext()) {
            rawBibRecCurrent = bibsRawRecRdr.next();
            matchingRawMhldRec = merger.getMatchingMhldRawRec(rawBibRecCurrent.getRecordId());
            try {
                if (matchingRawMhldRec != null) {
                    Record bibRecWithChanges = rawBibRecCurrent.getAsRecord(true, false, "999", "MARC8");
                    Record bibRecWithoutChanges = null;
                    boolean removedField = false;
                    List<VariableField> lvf = bibRecWithChanges.getVariableFields(DEFAULT_MHLD_FLDS_TO_MERGE.split("[|]"));
                    for (VariableField vf : lvf) {
                        bibRecWithChanges.removeVariableField(vf);
                        removedField = true;
                    }
                    if (removedField) {
                        bibRecWithoutChanges = rawBibRecCurrent.getAsRecord(true, false, "999", "MARC8");
                    }
                    Record matchingMhldRec = matchingRawMhldRec.getAsRecord(true, false, DEFAULT_MHLD_FLDS_TO_MERGE, "MARC8");
                    bibRecWithChanges = MarcCombiningReader.combineRecords(bibRecWithChanges, matchingMhldRec, DEFAULT_MHLD_FLDS_TO_MERGE, "999");
                    if (!outputAllBibs && removedField && bibRecWithoutChanges.toString().equals(bibRecWithChanges.toString())) continue;
                    writer.write(bibRecWithChanges);
                    System.out.flush();
                    continue;
                }
                if (!outputAllBibs) continue;
                System.out.write(rawBibRecCurrent.getRecordBytes());
                System.out.flush();
            }
            catch (IOException e) {
                System.err.println("Error writing record " + rawBibRecCurrent.getRecordId());
            }
        }
    }

    public static void main(String[] args) {
        String mhldRecsFileName = null;
        RawRecordReader bibsRawRecRdr = null;
        boolean outputAllBibs = false;
        int argoffset = 0;
        if (args.length == 0) {
            System.err.println("Usage: MergeSummaryHoldings [-v] [-a] -s marcMhldFile.mrc  marcBibsFile.mrc");
            System.err.println("   or: cat marcBibsFile.mrc | MergeSummaryHoldings [-v] [-a] -s marcMhldFile.mrc ");
        }
        while (argoffset < args.length && args[argoffset].startsWith("-")) {
            if (args[argoffset].equals("-v")) {
                verbose = true;
                ++argoffset;
            }
            if (args[argoffset].equals("-vv")) {
                verbose = true;
                veryverbose = true;
                ++argoffset;
            }
            if (args[argoffset].equals("-a")) {
                outputAllBibs = true;
                ++argoffset;
            }
            if (!args[argoffset].equals("-s")) continue;
            mhldRecsFileName = args[1 + argoffset];
            argoffset += 2;
        }
        if (args.length > argoffset && (args[argoffset].endsWith(".mrc") || args[argoffset].endsWith(".marc") || args[argoffset].endsWith(".xml"))) {
            try {
                bibsRawRecRdr = new RawRecordReader(new FileInputStream(new File(args[argoffset])));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            bibsRawRecRdr = new RawRecordReader(System.in);
        }
        System.setProperty("org.marc4j.marc.MarcFactory", "org.solrmarc.marcoverride.NoSortMarcFactoryImpl");
        MergeSummaryHoldings.mergeMhldsIntoBibRecsAsStdOut(bibsRawRecRdr, mhldRecsFileName, outputAllBibs);
        System.exit(0);
    }
}

