/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc.impl;

import java.text.DecimalFormat;
import org.marc4j.marc.Leader;
import org.marc4j.util.CustomDecimalFormat;

public class LeaderImpl
implements Leader {
    private static final long serialVersionUID = 8300445263515491860L;
    private Long id;
    private int recordLength;
    private char recordStatus;
    private char typeOfRecord;
    private char[] implDefined1;
    private char charCodingScheme;
    private int indicatorCount;
    private int subfieldCodeLength;
    private int baseAddressOfData;
    private char[] implDefined2;
    private char[] entryMap;
    private static DecimalFormat format5 = new CustomDecimalFormat(5);

    public LeaderImpl() {
    }

    public LeaderImpl(String ldr) {
        this.unmarshal(ldr);
    }

    @Override
    public void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    @Override
    public void setRecordStatus(char recordStatus) {
        this.recordStatus = recordStatus;
    }

    @Override
    public void setTypeOfRecord(char typeOfRecord) {
        this.typeOfRecord = typeOfRecord;
    }

    @Override
    public void setImplDefined1(char[] implDefined1) {
        this.implDefined1 = implDefined1;
    }

    @Override
    public void setCharCodingScheme(char charCodingScheme) {
        this.charCodingScheme = charCodingScheme;
    }

    @Override
    public void setIndicatorCount(int indicatorCount) {
        this.indicatorCount = indicatorCount;
    }

    @Override
    public void setSubfieldCodeLength(int subfieldCodeLength) {
        this.subfieldCodeLength = subfieldCodeLength;
    }

    @Override
    public void setBaseAddressOfData(int baseAddressOfData) {
        this.baseAddressOfData = baseAddressOfData;
    }

    @Override
    public void setImplDefined2(char[] implDefined2) {
        this.implDefined2 = implDefined2;
    }

    @Override
    public void setEntryMap(char[] entryMap) {
        this.entryMap = entryMap;
    }

    @Override
    public int getRecordLength() {
        return this.recordLength;
    }

    @Override
    public char getRecordStatus() {
        return this.recordStatus;
    }

    @Override
    public char getTypeOfRecord() {
        return this.typeOfRecord;
    }

    @Override
    public char[] getImplDefined1() {
        return this.implDefined1;
    }

    @Override
    public char getCharCodingScheme() {
        return this.charCodingScheme;
    }

    @Override
    public int getIndicatorCount() {
        return this.indicatorCount;
    }

    @Override
    public int getSubfieldCodeLength() {
        return this.subfieldCodeLength;
    }

    @Override
    public int getBaseAddressOfData() {
        return this.baseAddressOfData;
    }

    @Override
    public char[] getImplDefined2() {
        return this.implDefined2;
    }

    @Override
    public char[] getEntryMap() {
        return this.entryMap;
    }

    @Override
    public void unmarshal(String ldr) {
        try {
            String s = ldr.substring(0, 5);
            if (this.isInteger(s)) {
                this.setRecordLength(Integer.parseInt(s));
            } else {
                this.setRecordLength(0);
            }
            this.setRecordStatus(ldr.charAt(5));
            this.setTypeOfRecord(ldr.charAt(6));
            this.setImplDefined1(ldr.substring(7, 9).toCharArray());
            this.setCharCodingScheme(ldr.charAt(9));
            s = String.valueOf(ldr.charAt(10));
            if (this.isInteger(s)) {
                this.setIndicatorCount(Integer.parseInt(s));
            } else {
                this.setIndicatorCount(2);
            }
            s = String.valueOf(ldr.charAt(11));
            if (this.isInteger(s)) {
                this.setSubfieldCodeLength(Integer.parseInt(s));
            } else {
                this.setSubfieldCodeLength(2);
            }
            s = ldr.substring(12, 17);
            if (this.isInteger(s)) {
                this.setBaseAddressOfData(Integer.parseInt(s));
            } else {
                this.setBaseAddressOfData(0);
            }
            this.setImplDefined2(ldr.substring(17, 20).toCharArray());
            this.setEntryMap(ldr.substring(20, 24).toCharArray());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unable to parse leader", e);
        }
    }

    @Override
    public String marshal() {
        return this.toString();
    }

    public String toString() {
        return new StringBuffer().append(format5.format(this.getRecordLength())).append(this.getRecordStatus()).append(this.getTypeOfRecord()).append(this.getImplDefined1()).append(this.getCharCodingScheme()).append(this.getIndicatorCount()).append(this.getSubfieldCodeLength()).append(format5.format(this.getBaseAddressOfData())).append(this.getImplDefined2()).append(this.getEntryMap()).toString();
    }

    private boolean isInteger(String value) {
        int len = value.length();
        if (len == 0) {
            return false;
        }
        int i = 0;
        do {
            switch (value.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (++i < len);
        return true;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }
}

