/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.marc4j.MarcException;
import org.marc4j.converter.impl.CodeTableHandler;
import org.marc4j.converter.impl.CodeTableInterface;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class CodeTable
implements CodeTableInterface {
    protected static HashMap<Integer, HashMap<Integer, Character>> charsets = null;
    protected static HashMap<Integer, Vector<Integer>> combining = null;

    @Override
    public boolean isCombining(int c, int g0, int g1) {
        int newc;
        int mode;
        boolean retVal = false;
        if (c <= 126) {
            mode = g0;
            newc = c + 128;
        } else {
            mode = g1;
            newc = c - 128;
        }
        Vector<Integer> v = combining.get(mode);
        if (null != v && !(retVal = v.contains(c))) {
            retVal = v.contains(newc);
        }
        return retVal;
    }

    @Override
    public char getChar(int c, int mode) {
        if (c == 32) {
            return (char)c;
        }
        HashMap<Integer, Character> charset = charsets.get(new Integer(mode));
        if (charset == null) {
            return '\u0000';
        }
        Character ch = charset.get(new Integer(c));
        if (ch == null) {
            int newc = c < 128 ? c + 128 : c - 128;
            ch = charset.get(new Integer(newc));
            if (ch == null) {
                return '\u0000';
            }
            return ch.charValue();
        }
        return ch.charValue();
    }

    public CodeTable(InputStream byteStream) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(byteStream);
            CodeTableHandler saxUms = new CodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public CodeTable(String filename) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            File file = new File(filename);
            InputSource src = new InputSource(new FileInputStream(file));
            CodeTableHandler saxUms = new CodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public CodeTable(URI uri) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(uri.toURL().openStream());
            CodeTableHandler saxUms = new CodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }
}

