/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.marc4j.MarcError;
import org.marc4j.MarcWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;

public class MarcTxtWriter
implements MarcWriter {
    private String indexkeyprefix = null;
    private PrintWriter out = null;
    private CharConverter conv = null;

    public MarcTxtWriter(OutputStream os) {
        try {
            this.out = new PrintWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), true);
        }
        catch (NoClassDefFoundError ncdf) {
            try {
                this.out = new PrintWriter((Writer)new OutputStreamWriter(os, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public MarcTxtWriter(OutputStream os, String indexkeyprefix) {
        try {
            this.out = new PrintWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), true);
        }
        catch (NoClassDefFoundError ncdf) {
            try {
                this.out = new PrintWriter((Writer)new OutputStreamWriter(os, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.indexkeyprefix = indexkeyprefix;
    }

    @Override
    public void write(Record record) {
        String recStr = this.conv != null ? this.applyConverter(record, this.conv) : record.toString();
        if (this.indexkeyprefix != null) {
            String[] lines = recStr.split("\r?\n");
            for (String line : lines) {
                if (line.length() < 3 || !this.indexkeyprefix.contains(line.substring(0, 3))) continue;
                this.out.println(line);
            }
            if (this.indexkeyprefix.contains("err") && record.getErrors() != null) {
                for (MarcError err : record.getErrors()) {
                    this.out.println(err.toString());
                }
            }
        } else {
            this.out.println(recStr);
        }
    }

    private String applyConverter(Record record, CharConverter conv) {
        StringBuilder sb = new StringBuilder();
        sb.append("LEADER ");
        sb.append(record.getLeader().toString());
        sb.append('\n');
        for (VariableField field : record.getVariableFields()) {
            if (field instanceof ControlField) {
                sb.append(field.toString());
            } else if (field instanceof DataField) {
                DataField df = (DataField)field;
                sb.append(df.getTag());
                sb.append(' ');
                sb.append(df.getIndicator1());
                sb.append(df.getIndicator2());
                for (Subfield sf : df.getSubfields()) {
                    sb.append("$").append(sf.getCode()).append(conv.convert(sf.getData()));
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public void setConverter(CharConverter converter) {
        this.conv = converter;
    }

    @Override
    public CharConverter getConverter() {
        return this.conv;
    }

    @Override
    public void close() {
        this.out.flush();
        this.out.close();
    }

    @Override
    public boolean expectsUnicode() {
        return this.conv == null;
    }
}

