/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import org.marc4j.MarcException;
import org.marc4j.MarcWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;

public class MarcJsonWriter
implements MarcWriter {
    public static final int MARC_IN_JSON = 0;
    public static final int MARC_JSON = 1;
    private CharConverter converter = null;
    private final OutputStream os;
    private int useJsonFormat = 0;
    private boolean indent = false;
    private boolean escapeSlash = false;
    private boolean quoteLabels = true;
    private String ql = "\"";
    private boolean normalize = false;

    public MarcJsonWriter(OutputStream os) {
        this.os = os;
    }

    public MarcJsonWriter(OutputStream os, CharConverter conv) {
        this.os = os;
        this.setConverter(conv);
    }

    public MarcJsonWriter(OutputStream os, int jsonFormat) {
        this.os = os;
        this.useJsonFormat = jsonFormat;
        if (this.useJsonFormat == 1) {
            this.setQuoteLabels(false);
        }
    }

    public MarcJsonWriter(OutputStream os, CharConverter conv, int jsonFormat) {
        this.os = os;
        this.setConverter(conv);
        this.useJsonFormat = jsonFormat;
        if (this.useJsonFormat == 1) {
            this.setQuoteLabels(false);
        }
    }

    @Override
    public void close() {
        try {
            this.os.close();
        }
        catch (IOException e) {
            throw new MarcException("IO Error occurred closing marc writer", e);
        }
    }

    protected String toMarcJson(Record record) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        this.indent(buf, "\n    ");
        buf.append(this.ql + "leader" + this.ql + ":\"").append(this.unicodeEscape(record.getLeader().toString())).append("\",");
        this.indent(buf, "\n    ");
        buf.append(this.ql + "controlfield" + this.ql + ":");
        this.indent(buf, "\n    ");
        buf.append("[");
        boolean firstField = true;
        for (ControlField cf : record.getControlFields()) {
            if (!firstField) {
                buf.append(",");
            } else {
                firstField = false;
            }
            this.indent(buf, "\n        ");
            if (!cf.getTag().matches("[A-Z0-9][A-Z0-9][A-Z0-9]")) {
                throw new MarcException("Invalid tag: " + cf.getTag());
            }
            buf.append("{ " + this.ql + "tag" + this.ql + " : \"" + cf.getTag() + "\", " + this.ql + "data" + this.ql + " : ").append("\"" + this.unicodeEscape(cf.getData()) + "\" }");
        }
        this.indent(buf, "\n    ");
        buf.append("]");
        this.indent(buf, "\n    ");
        buf.append("datafield :");
        this.indent(buf, "\n    ");
        buf.append("[");
        firstField = true;
        for (DataField df : record.getDataFields()) {
            if (!firstField) {
                buf.append(",");
            } else {
                firstField = false;
            }
            this.indent(buf, "\n        ");
            buf.append("{");
            this.indent(buf, "\n            ");
            if (!df.getTag().matches("[A-Z0-9][A-Z0-9][A-Z0-9]")) {
                throw new MarcException("Invalid tag: " + df.getTag());
            }
            buf.append(this.ql + "tag" + this.ql + " : \"" + df.getTag() + "\", " + this.ql + "ind" + this.ql + " : \"");
            this.unicodeEscape(buf, df.getIndicator1());
            this.unicodeEscape(buf, df.getIndicator2());
            buf.append("\",");
            this.indent(buf, "\n            ");
            buf.append(this.ql + "subfield" + this.ql + " :");
            this.indent(buf, "\n            ");
            buf.append("[");
            boolean firstSubfield = true;
            for (Subfield sf : df.getSubfields()) {
                if (!firstSubfield) {
                    buf.append(",");
                } else {
                    firstSubfield = false;
                }
                this.indent(buf, "\n                ");
                if (!(sf.getCode() >= 'a' && 'z' >= sf.getCode() || sf.getCode() >= '0' && '9' >= sf.getCode())) {
                    throw new MarcException("Invalid code: " + sf.getCode());
                }
                buf.append("{ " + this.ql + "code" + this.ql + " : \"" + sf.getCode() + "\", " + this.ql + "data" + this.ql + " : \"" + this.unicodeEscape(sf.getData()) + "\" }");
            }
            this.indent(buf, "\n            ");
            buf.append("]");
            this.indent(buf, "\n        ");
            buf.append("}");
        }
        this.indent(buf, "\n    ");
        buf.append("]");
        this.indent(buf, "\n");
        buf.append("}\n");
        return buf.toString();
    }

    private void indent(StringBuffer buf, String indentStr) {
        if (this.indent) {
            buf.append(indentStr);
        }
    }

    protected String toMarcInJson(Record record) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        this.indent(buf, "\n    ");
        buf.append(this.ql + "leader" + this.ql + ":\"").append(this.unicodeEscape(record.getLeader().toString())).append("\",");
        this.indent(buf, "\n    ");
        buf.append(this.ql + "fields" + this.ql + ":");
        this.indent(buf, "\n    ");
        buf.append("[");
        boolean firstField = true;
        for (ControlField cf : record.getControlFields()) {
            if (!firstField) {
                buf.append(",");
            } else {
                firstField = false;
            }
            this.indent(buf, "\n        ");
            buf.append("{");
            this.indent(buf, "\n            ");
            if (!cf.getTag().matches("[A-Z0-9][A-Z0-9][A-Z0-9]")) {
                throw new MarcException("Invalid tag: " + cf.getTag());
            }
            buf.append(this.ql + cf.getTag() + this.ql + ":").append("\"" + this.unicodeEscape(cf.getData()) + "\"");
            this.indent(buf, "\n        ");
            buf.append("}");
        }
        for (DataField df : record.getDataFields()) {
            if (!firstField) {
                buf.append(",");
            } else {
                firstField = false;
            }
            this.indent(buf, "\n        ");
            buf.append("{");
            this.indent(buf, "\n            ");
            if (!df.getTag().matches("[A-Z0-9][A-Z0-9][A-Z0-9]")) {
                throw new MarcException("Invalid tag: " + df.getTag());
            }
            buf.append(this.ql + df.getTag() + this.ql + ":");
            this.indent(buf, "\n                ");
            buf.append("{");
            buf.append(this.ql + "subfields" + this.ql + ":");
            this.indent(buf, "\n                ");
            buf.append("[");
            boolean firstSubfield = true;
            for (Subfield sf : df.getSubfields()) {
                if (!firstSubfield) {
                    buf.append(",");
                } else {
                    firstSubfield = false;
                }
                this.indent(buf, "\n                    ");
                buf.append("{");
                this.indent(buf, "\n                        ");
                if (!(sf.getCode() >= 'a' && 'z' >= sf.getCode() || sf.getCode() >= '0' && '9' >= sf.getCode())) {
                    throw new MarcException("Invalid code: " + sf.getCode());
                }
                buf.append(this.ql + sf.getCode() + this.ql + ":\"" + this.unicodeEscape(sf.getData()) + "\"");
                this.indent(buf, "\n                    ");
                buf.append("}");
            }
            this.indent(buf, "\n                ");
            buf.append("],");
            this.indent(buf, "\n                ");
            buf.append(this.ql + "ind1" + this.ql + ":\"");
            this.unicodeEscape(buf, df.getIndicator1());
            buf.append("\",");
            this.indent(buf, "\n                ");
            buf.append(this.ql + "ind2" + this.ql + ":\"");
            this.unicodeEscape(buf, df.getIndicator2());
            buf.append("\"");
            this.indent(buf, "\n            ");
            buf.append("}");
            this.indent(buf, "\n        ");
            buf.append("}");
        }
        this.indent(buf, "\n    ");
        buf.append("]");
        this.indent(buf, "\n");
        buf.append("}\n");
        return buf.toString();
    }

    private String unicodeEscape(String data) {
        if (this.converter != null) {
            data = this.converter.convert(data);
        }
        if (this.normalize) {
            data = Normalizer.normalize(data, Normalizer.Form.NFC);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            this.unicodeEscape(buffer, c);
        }
        return buffer.toString();
    }

    private void unicodeEscape(StringBuffer buffer, char c) {
        switch (c) {
            case '/': {
                if (this.escapeSlash) {
                    buffer.append("\\/");
                    break;
                }
                buffer.append("/");
                break;
            }
            case '\"': {
                buffer.append("\\\"");
                break;
            }
            case '\\': {
                buffer.append("\\\\");
                break;
            }
            case '\b': {
                buffer.append("\\b");
                break;
            }
            case '\f': {
                buffer.append("\\f");
                break;
            }
            case '\n': {
                buffer.append("\\n");
                break;
            }
            case '\r': {
                buffer.append("\\r");
                break;
            }
            case '\t': {
                buffer.append("\\t");
                break;
            }
            default: {
                if (c > '\u00ff' || c <= '\u001f') {
                    String val = "0000" + Integer.toHexString(c);
                    buffer.append("\\u" + val.substring(val.length() - 4));
                    break;
                }
                buffer.append(c);
            }
        }
    }

    @Override
    public CharConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(CharConverter converter) {
        this.converter = converter;
    }

    public boolean hasIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    @Override
    public void write(Record record) {
        String recordAsJson = "";
        if (this.useJsonFormat == 0) {
            recordAsJson = this.toMarcInJson(record);
        } else if (this.useJsonFormat == 1) {
            recordAsJson = this.toMarcJson(record);
        }
        try {
            this.os.write(recordAsJson.getBytes(StandardCharsets.UTF_8));
            this.os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isEscapeSlash() {
        return this.escapeSlash;
    }

    public void setEscapeSlash(boolean escapeSlash) {
        this.escapeSlash = escapeSlash;
    }

    public boolean isQuoteLabels() {
        return this.quoteLabels;
    }

    public void setQuoteLabels(boolean quoteLabels) {
        this.quoteLabels = quoteLabels;
        this.ql = quoteLabels ? "\"" : "";
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setUnicodeNormalization(boolean b) {
        this.normalize = b;
    }

    @Override
    public boolean expectsUnicode() {
        return this.converter == null;
    }
}

