/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ModuleRef;
import io.github.classgraph.utils.ReflectionUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class ModuleReaderProxy
implements Closeable {
    private final AutoCloseable moduleReader;
    private static Class<?> collectorClass = ReflectionUtils.classForNameOrNull("java.util.stream.Collector");
    private static Object collectorsToList;

    ModuleReaderProxy(ModuleRef moduleRef) throws IOException {
        try {
            this.moduleReader = (AutoCloseable)ReflectionUtils.invokeMethod(moduleRef.getReference(), "open", true);
            if (this.moduleReader == null) {
                throw new IllegalArgumentException("moduleReference.open() should not return null");
            }
        }
        catch (SecurityException e) {
            throw new IOException("Could not open module " + moduleRef.getName(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.moduleReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> list() throws IOException, SecurityException {
        if (collectorsToList == null) {
            throw new IllegalArgumentException("Could not call Collectors.toList()");
        }
        Object resourcesStream = ReflectionUtils.invokeMethod(this.moduleReader, "list", true);
        if (resourcesStream == null) {
            throw new IllegalArgumentException("Could not call moduleReader.list()");
        }
        Object resourcesList = ReflectionUtils.invokeMethod(resourcesStream, "collect", collectorClass, collectorsToList, true);
        if (resourcesList == null) {
            throw new IllegalArgumentException("Could not call moduleReader.list().collect(Collectors.toList())");
        }
        List resourcesListTyped = (List)resourcesList;
        return resourcesListTyped;
    }

    public InputStream open(String path) throws IOException, SecurityException {
        Object optionalInputStream = ReflectionUtils.invokeMethod(this.moduleReader, "open", String.class, path, true);
        if (optionalInputStream == null) {
            throw new IllegalArgumentException("Could not call moduleReader.open(name)");
        }
        Object inputStream = ReflectionUtils.invokeMethod(optionalInputStream, "get", true);
        if (inputStream == null) {
            throw new IllegalArgumentException("Could not call moduleReader.open(name).get()");
        }
        return (InputStream)inputStream;
    }

    public ByteBuffer read(String path) throws IOException, SecurityException, OutOfMemoryError {
        Object optionalByteBuffer = ReflectionUtils.invokeMethod(this.moduleReader, "read", String.class, path, true);
        if (optionalByteBuffer == null) {
            throw new IllegalArgumentException("Could not call moduleReader.open(name)");
        }
        Object byteBuffer = ReflectionUtils.invokeMethod(optionalByteBuffer, "get", true);
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Could not call moduleReader.read(name).get()");
        }
        return (ByteBuffer)byteBuffer;
    }

    public void release(ByteBuffer byteBuffer) {
        ReflectionUtils.invokeMethod(this.moduleReader, "release", ByteBuffer.class, byteBuffer, true);
    }

    static {
        Class<?> collectorsClass = ReflectionUtils.classForNameOrNull("java.util.stream.Collectors");
        if (collectorsClass != null) {
            collectorsToList = ReflectionUtils.invokeStaticMethod(collectorsClass, "toList", true);
        }
    }
}

