/*
 * Decompiled with CFR 0.152.
 */
package org.vufind.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.vufind.util.Normalizer;
import org.vufind.util.Utils;

public class NACONormalizer
implements Normalizer {
    protected Collator collator = Collator.getInstance();
    private static String deleteChars = "['\\[\\]\u2018\u2019\u02ba\u02bb\u02bc\u02b9\u02bf]";
    private static String spaceChars = "[\\p{Punct}\u00bf\u00a1\u201c\u201d\u00ab\u00bb\u00b1\u207a\u207b\u2117\u00ae\u00a9\u00b0\u00b7]";
    private static Pattern deletePattern = Pattern.compile(deleteChars);
    private static Pattern spacePattern = Pattern.compile(spaceChars);
    private static Pattern whitespacePattern = Pattern.compile("\\s+");

    public NACONormalizer() {
        this.collator.setStrength(0);
    }

    public static NACONormalizer getInstance() throws Exception {
        NACONormalizer nacoNormalizer;
        if (Utils.getEnvironment("NORMALISER") != null) {
            String normalizerClass = Utils.getEnvironment("NORMALISER");
            nacoNormalizer = (NACONormalizer)Class.forName(normalizerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            nacoNormalizer = new NACONormalizer();
        }
        return nacoNormalizer;
    }

    public CollationKey normalizeToKey(String s) {
        s = deletePattern.matcher(s).replaceAll("");
        s = spacePattern.matcher(s).replaceAll(" ");
        s = whitespacePattern.matcher(s).replaceAll(" ");
        s = s.trim();
        return this.collator.getCollationKey(s);
    }

    @Override
    public byte[] normalize(String s) {
        return this.normalizeToKey(s).toByteArray();
    }

    public static void main(String[] args) {
        try {
            String str;
            NACONormalizer norm = new NACONormalizer();
            InputStreamReader in = new InputStreamReader(System.in);
            BufferedReader input = new BufferedReader(in);
            while ((str = input.readLine()) != null) {
                System.out.println(norm.normalize(str));
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }
}

