/*
 * Decompiled with CFR 0.152.
 */
package org.vufind.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import java.util.regex.Pattern;
import org.vufind.util.Normalizer;
import org.vufind.util.Utils;

public class ICUCollatorNormalizer
implements Normalizer {
    protected Collator collator;
    protected Pattern junkregexp = Pattern.compile("\\([^a-z0-9\\p{L} ]\\)");

    public ICUCollatorNormalizer() {
        this.collator = Collator.getInstance();
        this.collator.setStrength(1);
    }

    public static ICUCollatorNormalizer getInstance() throws Exception {
        ICUCollatorNormalizer iCUCollatorNormalizer;
        if (Utils.getEnvironment("NORMALISER") != null) {
            String normaliserClass = Utils.getEnvironment("NORMALISER");
            iCUCollatorNormalizer = (ICUCollatorNormalizer)Class.forName(normaliserClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            iCUCollatorNormalizer = new ICUCollatorNormalizer();
        }
        return iCUCollatorNormalizer;
    }

    public CollationKey normalizeToKey(String s) {
        s = s.replaceAll("-", "").replaceAll("\\p{Punct}", " ").replaceAll(" +", " ").trim();
        s = this.junkregexp.matcher(s).replaceAll("");
        return this.collator.getCollationKey(s);
    }

    @Override
    public byte[] normalize(String s) {
        return this.normalizeToKey(s).toByteArray();
    }
}

