/*
 * Decompiled with CFR 0.152.
 */
package org.vufind.solr.indexing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.vufind.solr.indexing.SolrFieldIterator;
import org.vufind.util.BrowseEntry;
import org.vufind.util.Utils;

public class StoredFieldIterator
extends SolrFieldIterator {
    int currentDoc = 0;
    LinkedList<BrowseEntry> buffer;
    String sortField = Utils.getEnvironment("SORTFIELD");
    String valueField = Utils.getEnvironment("VALUEFIELD");
    private Set<String> fieldSelection;
    private Bits liveDocsBitSet;

    public StoredFieldIterator(String indexPath, String field) throws Exception {
        super(indexPath, field);
        if (this.sortField == null || this.valueField == null) {
            throw new IllegalArgumentException("Both SORTFIELD and VALUEFIELD environment variables must be set.");
        }
        this.fieldSelection = new HashSet<String>();
        this.fieldSelection.add(this.sortField);
        this.fieldSelection.add(this.valueField);
        this.fieldSelection.add("id");
        this.reader = DirectoryReader.open((Directory)FSDirectory.open((Path)new File(indexPath).toPath()));
        this.liveDocsBitSet = MultiBits.getLiveDocs((IndexReader)this.reader);
        this.buffer = new LinkedList();
    }

    private void loadDocument(IndexReader reader, int docid) throws IOException {
        String[] value;
        Document doc = reader.storedFields().document(this.currentDoc, this.fieldSelection);
        String[] sort_key = doc.getValues(this.sortField);
        if (sort_key.length == (value = doc.getValues(this.valueField)).length) {
            for (int i = 0; i < value.length; ++i) {
                this.buffer.add(new BrowseEntry(this.buildSortKey(sort_key[i]), sort_key[i], value[i]));
            }
        } else {
            String id = null;
            IndexableField idField = doc.getField("id");
            if (idField != null) {
                id = idField.stringValue();
            }
            System.err.println("Skipped entries for doc #" + docid + " (id:" + id + "): the number of sort keys didn't match the number of stored values.");
        }
    }

    @Override
    protected BrowseEntry readNext() throws IOException {
        while (this.buffer.isEmpty()) {
            if (this.currentDoc < this.reader.maxDoc()) {
                if (this.liveDocsBitSet == null || this.liveDocsBitSet.get(this.currentDoc)) {
                    this.loadDocument((IndexReader)this.reader, this.currentDoc);
                }
                ++this.currentDoc;
                continue;
            }
            return null;
        }
        return this.buffer.remove();
    }
}

