/*
 * Decompiled with CFR 0.152.
 */
package org.vufind.solr.indexing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.vufind.util.BrowseEntry;
import org.vufind.util.Normalizer;
import org.vufind.util.NormalizerFactory;

public class SolrFieldIterator
implements AutoCloseable,
Iterator<BrowseEntry>,
Iterable<BrowseEntry> {
    protected CompositeReader reader;
    protected IndexSearcher searcher;
    protected List<LeafReaderContext> leafReaders;
    private String field;
    private Normalizer normalizer;
    TermsEnum tenum = null;
    private BrowseEntry nextEntry = null;
    private boolean exhausted = false;

    public SolrFieldIterator(String indexPath, String field) throws Exception {
        this.reader = DirectoryReader.open((Directory)FSDirectory.open((Path)new File(indexPath).toPath()));
        this.searcher = new IndexSearcher((IndexReader)this.reader);
        this.leafReaders = new ArrayList<LeafReaderContext>(this.reader.getContext().leaves());
        this.field = field;
        String normalizerClass = System.getProperty("browse.normalizer");
        this.normalizer = NormalizerFactory.getNormalizer(normalizerClass);
    }

    public byte[] buildSortKey(String heading) {
        return this.normalizer.normalize(heading);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private boolean termExists(String t) {
        try {
            return this.searcher.search((Query)new ConstantScoreQuery((Query)new TermQuery((Term)new Term((String)this.field, (String)t))), (int)1).totalHits.value > 0L;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected BrowseEntry readNext() throws IOException {
        String termText;
        while (true) {
            BytesRef nextTerm;
            if (this.tenum == null) {
                if (this.leafReaders.isEmpty()) {
                    return null;
                }
                LeafReader ir = this.leafReaders.remove(0).reader();
                Terms terms = ir.terms(this.field);
                if (terms == null) continue;
                this.tenum = terms.iterator();
            }
            if ((nextTerm = this.tenum.next()) == null) {
                this.tenum = null;
                continue;
            }
            termText = nextTerm.utf8ToString();
            if (this.termExists(termText)) break;
        }
        return new BrowseEntry(this.buildSortKey(termText), termText, termText);
    }

    public void tryReadNext() {
        if (this.nextEntry != null) {
            return;
        }
        if (this.exhausted) {
            // empty if block
        }
        try {
            this.nextEntry = this.readNext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.nextEntry == null) {
            this.exhausted = true;
        }
    }

    @Override
    public BrowseEntry next() {
        this.tryReadNext();
        if (this.nextEntry == null) {
            throw new NoSuchElementException();
        }
        BrowseEntry result = this.nextEntry;
        this.nextEntry = null;
        return result;
    }

    @Override
    public boolean hasNext() {
        this.tryReadNext();
        return this.nextEntry != null;
    }

    @Override
    public Iterator<BrowseEntry> iterator() {
        return this;
    }
}

