/*
 * Decompiled with CFR 0.152.
 */
package org.vufind.solr.indexing;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.codec.binary.Base64;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.vufind.solr.indexing.Predicate;
import org.vufind.solr.indexing.SolrFieldIterator;
import org.vufind.util.BrowseEntry;
import org.vufind.util.Utils;

public class PrintBrowseHeadings {
    private SolrFieldIterator nonprefAuthFieldIterator;
    IndexSearcher bibSearcher;
    IndexSearcher authSearcher;
    private String luceneField;
    private String KEY_SEPARATOR = "\u0001";
    private String RECORD_SEPARATOR = "\r\n";

    private void loadHeadings(SolrFieldIterator fieldIterator, PrintWriter out, Predicate predicate) throws Exception {
        for (BrowseEntry h : fieldIterator) {
            byte[] sort_key = h.key;
            String key_text = h.key_text;
            String heading = h.value;
            if (predicate != null && !predicate.isSatisfiedBy(heading) || sort_key == null) continue;
            out.print(new String(Base64.encodeBase64((byte[])sort_key)) + this.KEY_SEPARATOR + new String(Base64.encodeBase64((byte[])key_text.getBytes(Charset.forName("UTF-8")))) + this.KEY_SEPARATOR + new String(Base64.encodeBase64((byte[])heading.getBytes(Charset.forName("UTF-8")))) + this.RECORD_SEPARATOR);
        }
    }

    private int bibCount(String heading) throws IOException {
        TotalHitCountCollector counter = new TotalHitCountCollector();
        this.bibSearcher.search((Query)new ConstantScoreQuery((Query)new TermQuery(new Term(this.luceneField, heading))), (Collector)counter);
        return counter.getTotalHits();
    }

    private boolean isLinkedFromBibData(String heading) throws IOException {
        TopDocs hits = null;
        int max_headings = 20;
        while (true) {
            hits = this.authSearcher.search((Query)new ConstantScoreQuery((Query)new TermQuery(new Term(System.getProperty("field.insteadof", "insteadOf"), heading))), max_headings);
            if (hits.scoreDocs.length < max_headings) break;
            max_headings *= 2;
        }
        StoredFields storedFields = this.authSearcher.getIndexReader().storedFields();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document doc = storedFields.document(hits.scoreDocs[i].doc);
            String[] preferred = doc.getValues(System.getProperty("field.preferred", "preferred"));
            if (preferred.length > 0) {
                String preferredHeading = preferred[0];
                if (this.bibCount(preferredHeading) <= 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private SolrFieldIterator getBibIterator(String bibPath, String luceneField) throws Exception {
        String fieldIteratorClass = "org.vufind.solr.indexing.SolrFieldIterator";
        if (Utils.getEnvironment("BIBLEECH") != null) {
            if (System.getenv("BIBLEECH") != null) {
                Utils.printDeprecationWarning("You are using the 'BIBLEECH' environment variable.", "This still works, but it has been renamed to 'BIB_FIELD_ITERATOR'", "You should switch to avoid breakage in future versions.");
            }
            if (System.getProperty("bibleech") != null) {
                Utils.printDeprecationWarning("You are using the 'bibleech' system property.", "This still works, but it has been renamed to 'bib_field_iterator'", "You should switch to avoid breakage in future versions.");
            }
            fieldIteratorClass = Utils.getEnvironment("BIBLEECH");
        }
        if (Utils.getEnvironment("BIB_FIELD_ITERATOR") != null) {
            fieldIteratorClass = Utils.getEnvironment("BIB_FIELD_ITERATOR");
        }
        if ("StoredFieldLeech".equals(fieldIteratorClass)) {
            Utils.printDeprecationWarning("You are using the 'StoredFieldLeech' class.", "This still works, but it has been renamed to 'org.vufind.solr.indexing.StoredFieldIterator'", "You should switch to avoid breakage in future versions.");
            fieldIteratorClass = "org.vufind.solr.indexing.StoredFieldIterator";
        }
        return (SolrFieldIterator)Class.forName(fieldIteratorClass).getConstructor(String.class, String.class).newInstance(bibPath, luceneField);
    }

    public void create(String bibPath, String luceneField, String authPath, String outFile) throws Exception {
        try (SolrFieldIterator bibFieldIterator = this.getBibIterator(bibPath, luceneField);){
            this.luceneField = luceneField;
            DirectoryReader bibReader = DirectoryReader.open((Directory)FSDirectory.open((Path)new File(bibPath).toPath()));
            this.bibSearcher = new IndexSearcher((IndexReader)bibReader);
            try (PrintWriter out = new PrintWriter(new FileWriter(outFile));){
                if (authPath != null) {
                    try {
                        this.nonprefAuthFieldIterator = new SolrFieldIterator(authPath, System.getProperty("field.insteadof", "insteadOf"));
                    }
                    catch (IndexNotFoundException e) {
                        this.nonprefAuthFieldIterator = null;
                    }
                    if (this.nonprefAuthFieldIterator != null) {
                        DirectoryReader authReader = DirectoryReader.open((Directory)FSDirectory.open((Path)new File(authPath).toPath()));
                        this.authSearcher = new IndexSearcher((IndexReader)authReader);
                        this.loadHeadings(this.nonprefAuthFieldIterator, out, new Predicate(){

                            @Override
                            public boolean isSatisfiedBy(Object obj) {
                                String heading = (String)obj;
                                try {
                                    return PrintBrowseHeadings.this.isLinkedFromBibData(heading);
                                }
                                catch (IOException e) {
                                    return true;
                                }
                            }
                        });
                        this.nonprefAuthFieldIterator.close();
                    }
                }
                this.loadHeadings(bibFieldIterator, out, null);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3 && args.length != 4) {
            System.err.println("Usage: PrintBrowseHeadings <bib index> <bib field> <auth index> <out file>");
            System.err.println("\nor:\n");
            System.err.println("Usage: PrintBrowseHeadings <bib index> <bib field> <out file>");
            System.exit(0);
        }
        PrintBrowseHeadings self = new PrintBrowseHeadings();
        if (args.length == 4) {
            self.create(args[0], args[1], args[2], args[3]);
        } else {
            self.create(args[0], args[1], null, args[2]);
        }
    }
}

