/*
 * Decompiled with CFR 0.152.
 */
package org.vufind.solr.indexing;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.commons.codec.binary.Base64;

public class CreateBrowseSQLite {
    private Connection outputDB;
    private String KEY_SEPARATOR = "\u0001";

    private String readCRLFLine(BufferedReader br) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = br.read()) >= 0) {
            if (ch == 13) {
                ch = br.read();
                if (ch == 10) {
                    return sb.toString();
                }
                sb.append('\r');
            }
            sb.append((char)ch);
        }
        return null;
    }

    private void loadHeadings(BufferedReader br) throws Exception {
        int count = 0;
        this.outputDB.setAutoCommit(false);
        try (PreparedStatement prep = this.outputDB.prepareStatement("insert or ignore into all_headings (key, key_text, heading) values (?, ?, ?)");){
            String line;
            while ((line = this.readCRLFLine(br)) != null) {
                String[] fields = line.split(this.KEY_SEPARATOR);
                if (fields.length == 3) {
                    prep.setBytes(1, Base64.decodeBase64((byte[])fields[0].getBytes()));
                    prep.setBytes(2, Base64.decodeBase64((byte[])fields[1].getBytes()));
                    prep.setBytes(3, Base64.decodeBase64((byte[])fields[2].getBytes()));
                    prep.addBatch();
                }
                if (count % 500000 == 0) {
                    prep.executeBatch();
                    prep.clearBatch();
                }
                ++count;
            }
            prep.executeBatch();
        }
        this.outputDB.commit();
        this.outputDB.setAutoCommit(true);
    }

    private void setupDatabase() throws Exception {
        try (Statement stat = this.outputDB.createStatement();){
            stat.executeUpdate("drop table if exists all_headings;");
            stat.executeUpdate("create table all_headings (key, key_text, heading);");
            stat.executeUpdate("PRAGMA synchronous = OFF;");
            stat.execute("PRAGMA journal_mode = OFF;");
        }
    }

    private void buildOrderedTables() throws Exception {
        try (Statement stat = this.outputDB.createStatement();){
            stat.executeUpdate("drop table if exists headings;");
            stat.executeUpdate("create table headings as select * from all_headings order by key;");
            stat.executeUpdate("create index keyindex on headings (key);");
        }
    }

    public void create(String headingsFile, String outputPath) throws Exception {
        Class.forName("org.sqlite.JDBC");
        this.outputDB = DriverManager.getConnection("jdbc:sqlite:" + outputPath);
        this.setupDatabase();
        try (BufferedReader br = new BufferedReader(new FileReader(headingsFile));){
            this.loadHeadings(br);
        }
        this.buildOrderedTables();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: CreateBrowseSQLite <headings file> <db file>");
            System.exit(0);
        }
        CreateBrowseSQLite self = new CreateBrowseSQLite();
        self.create(args[0], args[1]);
    }
}

