/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.ByteVectorSimilarityFunction;
import org.apache.lucene.queries.function.valuesource.ConstNumberSource;
import org.apache.lucene.queries.function.valuesource.ConstValueSource;
import org.apache.lucene.queries.function.valuesource.DefFunction;
import org.apache.lucene.queries.function.valuesource.DivFloatFunction;
import org.apache.lucene.queries.function.valuesource.DocFreqValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleConstValueSource;
import org.apache.lucene.queries.function.valuesource.DualFloatFunction;
import org.apache.lucene.queries.function.valuesource.FloatVectorSimilarityFunction;
import org.apache.lucene.queries.function.valuesource.IDFValueSource;
import org.apache.lucene.queries.function.valuesource.IfFunction;
import org.apache.lucene.queries.function.valuesource.JoinDocFreqValueSource;
import org.apache.lucene.queries.function.valuesource.LinearFloatFunction;
import org.apache.lucene.queries.function.valuesource.LiteralValueSource;
import org.apache.lucene.queries.function.valuesource.MaxDocValueSource;
import org.apache.lucene.queries.function.valuesource.MaxFloatFunction;
import org.apache.lucene.queries.function.valuesource.MinFloatFunction;
import org.apache.lucene.queries.function.valuesource.MultiBoolFunction;
import org.apache.lucene.queries.function.valuesource.MultiValueSource;
import org.apache.lucene.queries.function.valuesource.NormValueSource;
import org.apache.lucene.queries.function.valuesource.NumDocsValueSource;
import org.apache.lucene.queries.function.valuesource.ProductFloatFunction;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.queries.function.valuesource.RangeMapFloatFunction;
import org.apache.lucene.queries.function.valuesource.ReciprocalFloatFunction;
import org.apache.lucene.queries.function.valuesource.ScaleFloatFunction;
import org.apache.lucene.queries.function.valuesource.SimpleBoolFunction;
import org.apache.lucene.queries.function.valuesource.SimpleFloatFunction;
import org.apache.lucene.queries.function.valuesource.SingleFunction;
import org.apache.lucene.queries.function.valuesource.SumFloatFunction;
import org.apache.lucene.queries.function.valuesource.SumTotalTermFreqValueSource;
import org.apache.lucene.queries.function.valuesource.TFValueSource;
import org.apache.lucene.queries.function.valuesource.TermFreqValueSource;
import org.apache.lucene.queries.function.valuesource.TotalTermFreqValueSource;
import org.apache.lucene.queries.function.valuesource.VectorValueSource;
import org.apache.lucene.queries.payloads.PayloadDecoder;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.JaroWinklerDistance;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.search.spell.NGramDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.CurrencyFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.FloatPayloadValueSource;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.AvgAgg;
import org.apache.solr.search.facet.CountAgg;
import org.apache.solr.search.facet.CountValsAgg;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.MinMaxAgg;
import org.apache.solr.search.facet.MissingAgg;
import org.apache.solr.search.facet.PercentileAgg;
import org.apache.solr.search.facet.RelatednessAgg;
import org.apache.solr.search.facet.StddevAgg;
import org.apache.solr.search.facet.SumAgg;
import org.apache.solr.search.facet.SumsqAgg;
import org.apache.solr.search.facet.UniqueAgg;
import org.apache.solr.search.facet.UniqueBlockFieldAgg;
import org.apache.solr.search.facet.UniqueBlockQueryAgg;
import org.apache.solr.search.facet.VarianceAgg;
import org.apache.solr.search.function.CollapseScoreFunction;
import org.apache.solr.search.function.ConcatStringFunction;
import org.apache.solr.search.function.DualDoubleFunction;
import org.apache.solr.search.function.EqualFunction;
import org.apache.solr.search.function.OrdFieldSource;
import org.apache.solr.search.function.ReverseOrdFieldSource;
import org.apache.solr.search.function.SolrComparisonBoolFunction;
import org.apache.solr.search.function.distance.GeoDistValueSourceParser;
import org.apache.solr.search.function.distance.GeohashFunction;
import org.apache.solr.search.function.distance.GeohashHaversineFunction;
import org.apache.solr.search.function.distance.HaversineFunction;
import org.apache.solr.search.function.distance.SquaredEuclideanFunction;
import org.apache.solr.search.function.distance.StringDistanceFunction;
import org.apache.solr.search.function.distance.VectorDistanceFunction;
import org.apache.solr.search.join.ChildFieldValueSourceParser;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.PayloadUtils;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public abstract class ValueSourceParser
implements NamedListInitializedPlugin {
    private static final Map<String, ValueSourceParser> standardVSParsers = new HashMap<String, ValueSourceParser>();
    public static final Map<String, ValueSourceParser> standardValueSourceParsers = Collections.unmodifiableMap(standardVSParsers);

    public abstract ValueSource parse(FunctionQParser var1) throws SyntaxError;

    private static ValueSourceParser addParser(String name, ValueSourceParser p) {
        return standardVSParsers.put(name, p);
    }

    private static ValueSourceParser addParser(NamedParser p) {
        return standardVSParsers.put(p.name(), p);
    }

    private static void alias(String source, String dest) {
        standardVSParsers.put(dest, standardVSParsers.get(source));
    }

    private static TInfo parseTerm(FunctionQParser fp) throws SyntaxError {
        TInfo tinfo = new TInfo();
        tinfo.indexedField = tinfo.field = fp.parseArg();
        tinfo.val = fp.parseArg();
        tinfo.indexedBytes = new BytesRefBuilder();
        FieldType ft = fp.getReq().getSchema().getFieldTypeNoEx(tinfo.field);
        if (ft == null) {
            ft = new StrField();
        }
        if (ft instanceof TextField) {
            String indexedVal = tinfo.val;
            Query q = ft.getFieldQuery(fp, fp.getReq().getSchema().getFieldOrNull(tinfo.field), tinfo.val);
            if (q instanceof TermQuery) {
                Term term = ((TermQuery)q).getTerm();
                tinfo.indexedField = term.field();
                indexedVal = term.text();
            }
            tinfo.indexedBytes.copyChars((CharSequence)indexedVal);
        } else {
            ft.readableToIndexed(tinfo.val, tinfo.indexedBytes);
        }
        return tinfo;
    }

    private static void splitSources(int dim, List<ValueSource> sources, List<ValueSource> dest1, List<ValueSource> dest2) {
        int i;
        for (i = 0; i < dim; ++i) {
            dest1.add(sources.get(i));
        }
        for (i = dim; i < sources.size(); ++i) {
            dest2.add(sources.get(i));
        }
    }

    private static MVResult getMultiValueSources(List<ValueSource> sources) {
        MVResult mvr = new MVResult();
        if (sources.size() % 2 != 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal number of sources.  There must be an even number of sources");
        }
        if (sources.size() == 2) {
            boolean s1MV = sources.get(0) instanceof MultiValueSource;
            boolean s2MV = sources.get(1) instanceof MultiValueSource;
            if (s1MV && s2MV) {
                mvr.mv1 = (MultiValueSource)sources.get(0);
                mvr.mv2 = (MultiValueSource)sources.get(1);
            } else {
                if (s1MV || s2MV) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal number of sources.  There must be an even number of sources");
                }
                mvr.mv1 = new VectorValueSource(Collections.singletonList(sources.get(0)));
                mvr.mv2 = new VectorValueSource(Collections.singletonList(sources.get(1)));
            }
        } else {
            int dim = sources.size() / 2;
            ArrayList<ValueSource> sources1 = new ArrayList<ValueSource>(dim);
            ArrayList<ValueSource> sources2 = new ArrayList<ValueSource>(dim);
            ValueSourceParser.splitSources(dim, sources, sources1, sources2);
            mvr.mv1 = new VectorValueSource(sources1);
            mvr.mv2 = new VectorValueSource(sources2);
        }
        return mvr;
    }

    static {
        ValueSourceParser.addParser("testfunc", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource source = fp.parseValueSource();
                return new TestValueSource(source);
            }
        });
        ValueSourceParser.addParser("ord", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                String field = fp.parseId();
                return new OrdFieldSource(field);
            }
        });
        ValueSourceParser.addParser("literal", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new LiteralValueSource(fp.parseArg());
            }
        });
        ValueSourceParser.addParser("threadid", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new LongConstValueSource(Thread.currentThread().getId());
            }
        });
        ValueSourceParser.addParser("sleep", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                int ms = fp.parseInt();
                ValueSource source = fp.parseValueSource();
                try {
                    Thread.sleep(ms);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return source;
            }
        });
        ValueSourceParser.addParser("rord", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                String field = fp.parseId();
                return new ReverseOrdFieldSource(field);
            }
        });
        ValueSourceParser.addParser("top", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource source = fp.parseValueSource();
                return source;
            }
        });
        ValueSourceParser.addParser("linear", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource source = fp.parseValueSource();
                float slope = fp.parseFloat().floatValue();
                float intercept = fp.parseFloat().floatValue();
                return new LinearFloatFunction(source, slope, intercept);
            }
        });
        ValueSourceParser.addParser("recip", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource source = fp.parseValueSource();
                float m = fp.parseFloat().floatValue();
                float a = fp.parseFloat().floatValue();
                float b = fp.parseFloat().floatValue();
                return new ReciprocalFloatFunction(source, m, a, b);
            }
        });
        ValueSourceParser.addParser("scale", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource source = fp.parseValueSource();
                float min = fp.parseFloat().floatValue();
                float max = fp.parseFloat().floatValue();
                return new ScaleFloatFunction(source, min, max);
            }
        });
        ValueSourceParser.addParser("div", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource a = fp.parseValueSource();
                ValueSource b = fp.parseValueSource();
                return new DivFloatFunction(a, b);
            }
        });
        ValueSourceParser.addParser("mod", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource a = fp.parseValueSource();
                ValueSource b = fp.parseValueSource();
                return new DualDoubleFunction(a, b){

                    @Override
                    protected String name() {
                        return "mod";
                    }

                    @Override
                    protected double func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
                        return aVals.doubleVal(doc) % bVals.doubleVal(doc);
                    }
                };
            }
        });
        ValueSourceParser.addParser("map", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource source = fp.parseValueSource();
                float min = fp.parseFloat().floatValue();
                float max = fp.parseFloat().floatValue();
                ValueSource target = fp.parseValueSource();
                ValueSource def = fp.hasMoreArguments() ? fp.parseValueSource() : null;
                return new RangeMapFloatFunction(source, min, max, target, def);
            }
        });
        ValueSourceParser.addParser("abs", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource source = fp.parseValueSource();
                return new SimpleFloatFunction(source){

                    protected String name() {
                        return "abs";
                    }

                    protected float func(int doc, FunctionValues vals) throws IOException {
                        return Math.abs(vals.floatVal(doc));
                    }
                };
            }
        });
        ValueSourceParser.addParser("cscore", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new CollapseScoreFunction();
            }
        });
        ValueSourceParser.addParser("sum", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new SumFloatFunction(sources.toArray(new ValueSource[0]));
            }
        });
        ValueSourceParser.alias("sum", "add");
        ValueSourceParser.addParser("vectorSimilarity", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                VectorEncoding vectorEncoding = VectorEncoding.valueOf((String)fp.parseArg());
                VectorSimilarityFunction functionName = VectorSimilarityFunction.valueOf((String)fp.parseArg());
                int vectorEncodingFlag = vectorEncoding.equals((Object)VectorEncoding.BYTE) ? 8 : 0;
                ValueSource v1 = fp.parseValueSource(1 | vectorEncodingFlag);
                ValueSource v2 = fp.parseValueSource(1 | vectorEncodingFlag);
                switch (vectorEncoding) {
                    case FLOAT32: {
                        return new FloatVectorSimilarityFunction(functionName, v1, v2);
                    }
                    case BYTE: {
                        return new ByteVectorSimilarityFunction(functionName, v1, v2);
                    }
                }
                throw new SyntaxError("Invalid vector encoding: " + vectorEncoding);
            }
        });
        ValueSourceParser.addParser("product", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new ProductFloatFunction(sources.toArray(new ValueSource[0]));
            }
        });
        ValueSourceParser.alias("product", "mul");
        ValueSourceParser.addParser("sub", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource a = fp.parseValueSource();
                ValueSource b = fp.parseValueSource();
                return new DualFloatFunction(a, b){

                    protected String name() {
                        return "sub";
                    }

                    protected float func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
                        return aVals.floatVal(doc) - bVals.floatVal(doc);
                    }
                };
            }
        });
        ValueSourceParser.addParser("vector", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new VectorValueSource(fp.parseValueSourceList());
            }
        });
        ValueSourceParser.addParser("query", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                Query q = fp.parseNestedQuery();
                float defVal = 0.0f;
                if (fp.hasMoreArguments()) {
                    defVal = fp.parseFloat().floatValue();
                }
                return new QueryValueSource(q, defVal);
            }
        });
        ValueSourceParser.addParser("boost", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                Query q = fp.parseNestedQuery();
                ValueSource vs = fp.parseValueSource();
                return new QueryValueSource((Query)FunctionScoreQuery.boostByValue((Query)q, (DoubleValuesSource)vs.asDoubleValuesSource()), 0.0f);
            }
        });
        ValueSourceParser.addParser("joindf", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                String f0 = fp.parseArg();
                String qf = fp.parseArg();
                return new JoinDocFreqValueSource(f0, qf);
            }
        });
        ValueSourceParser.addParser("geodist", new GeoDistValueSourceParser());
        ValueSourceParser.addParser("hsin", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                MultiValueSource pv2;
                MultiValueSource pv1;
                double radius = fp.parseDouble();
                boolean convert = Boolean.parseBoolean(fp.parseArg());
                ValueSource one = fp.parseValueSource();
                ValueSource two = fp.parseValueSource();
                if (fp.hasMoreArguments()) {
                    pv1 = new VectorValueSource(Arrays.asList(one, two));
                    pv2 = new VectorValueSource(Arrays.asList(fp.parseValueSource(), fp.parseValueSource()));
                } else if (one instanceof MultiValueSource && two instanceof MultiValueSource) {
                    pv1 = (MultiValueSource)one;
                    pv2 = (MultiValueSource)two;
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Input must either be 2 MultiValueSources, or there must be 4 ValueSources");
                }
                return new HaversineFunction(pv1, pv2, radius, convert);
            }
        });
        ValueSourceParser.addParser("ghhsin", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                double radius = fp.parseDouble();
                ValueSource gh1 = fp.parseValueSource();
                ValueSource gh2 = fp.parseValueSource();
                return new GeohashHaversineFunction(gh1, gh2, radius);
            }
        });
        ValueSourceParser.addParser("geohash", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource lat = fp.parseValueSource();
                ValueSource lon = fp.parseValueSource();
                return new GeohashFunction(lat, lon);
            }
        });
        ValueSourceParser.addParser("strdist", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource str1 = fp.parseValueSource();
                ValueSource str2 = fp.parseValueSource();
                String distClass = fp.parseArg();
                JaroWinklerDistance dist = null;
                if (distClass.equalsIgnoreCase("jw")) {
                    dist = new JaroWinklerDistance();
                } else if (distClass.equalsIgnoreCase("edit")) {
                    dist = new LevenshteinDistance();
                } else if (distClass.equalsIgnoreCase("ngram")) {
                    int ngram = 2;
                    if (fp.hasMoreArguments()) {
                        ngram = fp.parseInt();
                    }
                    dist = new NGramDistance(ngram);
                } else {
                    dist = fp.req.getCore().getResourceLoader().newInstance(distClass, StringDistance.class);
                }
                return new StringDistanceFunction(str1, str2, (StringDistance)dist);
            }
        });
        ValueSourceParser.addParser("field", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                String fieldName = fp.parseArg();
                SchemaField f = fp.getReq().getSchema().getField(fieldName);
                if (fp.hasMoreArguments()) {
                    String s = fp.parseArg();
                    FieldType.MultiValueSelector selector = FieldType.MultiValueSelector.lookup(s);
                    if (null == selector) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Multi-Valued field selector '" + s + "' not supported");
                    }
                    return f.getType().getSingleValueSource(selector, f, fp);
                }
                return f.getType().getValueSource(f, fp);
            }
        });
        ValueSourceParser.addParser("currency", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                String fieldName = fp.parseArg();
                SchemaField f = fp.getReq().getSchema().getField(fieldName);
                if (!(f.getType() instanceof CurrencyFieldType)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Currency function input must be the name of a CurrencyFieldType: " + fieldName);
                }
                CurrencyFieldType ft = (CurrencyFieldType)f.getType();
                String code = fp.hasMoreArguments() ? fp.parseArg() : null;
                return ft.getConvertedValueSource(code, ft.getValueSource(f, fp));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("rad"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return vals.doubleVal(doc) * (Math.PI / 180);
            }
        });
        ValueSourceParser.addParser(new DoubleParser("deg"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return vals.doubleVal(doc) * 57.29577951308232;
            }
        });
        ValueSourceParser.addParser(new DoubleParser("sqrt"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.sqrt(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("cbrt"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.cbrt(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("log"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.log10(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("ln"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.log(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("exp"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.exp(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("sin"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.sin(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("cos"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.cos(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("tan"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.tan(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("asin"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.asin(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("acos"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.acos(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("atan"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.atan(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("sinh"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.sinh(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("cosh"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.cosh(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("tanh"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.tanh(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("ceil"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.ceil(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("floor"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.floor(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("rint"){

            @Override
            public double func(int doc, FunctionValues vals) throws IOException {
                return Math.rint(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new Double2Parser("pow"){

            @Override
            public double func(int doc, FunctionValues a, FunctionValues b) throws IOException {
                return Math.pow(a.doubleVal(doc), b.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new Double2Parser("hypot"){

            @Override
            public double func(int doc, FunctionValues a, FunctionValues b) throws IOException {
                return Math.hypot(a.doubleVal(doc), b.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new Double2Parser("atan2"){

            @Override
            public double func(int doc, FunctionValues a, FunctionValues b) throws IOException {
                return Math.atan2(a.doubleVal(doc), b.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser("max", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new MaxFloatFunction(sources.toArray(new ValueSource[0]));
            }
        });
        ValueSourceParser.addParser("min", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new MinFloatFunction(sources.toArray(new ValueSource[0]));
            }
        });
        ValueSourceParser.addParser("sqedist", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                MVResult mvr = ValueSourceParser.getMultiValueSources(sources);
                return new SquaredEuclideanFunction(mvr.mv1, mvr.mv2);
            }
        });
        ValueSourceParser.addParser("dist", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                float power = fp.parseFloat().floatValue();
                List<ValueSource> sources = fp.parseValueSourceList();
                MVResult mvr = ValueSourceParser.getMultiValueSources(sources);
                return new VectorDistanceFunction(power, mvr.mv1, mvr.mv2);
            }
        });
        ValueSourceParser.addParser("ms", new DateValueSourceParser());
        ValueSourceParser.addParser("pi", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) {
                return new DoubleConstValueSource(Math.PI);
            }
        });
        ValueSourceParser.addParser("e", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) {
                return new DoubleConstValueSource(Math.E);
            }
        });
        ValueSourceParser.addParser("docfreq", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                TInfo tinfo = ValueSourceParser.parseTerm(fp);
                return new DocFreqValueSource(tinfo.field, tinfo.val, tinfo.indexedField, tinfo.indexedBytes.get());
            }
        });
        ValueSourceParser.addParser("totaltermfreq", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                TInfo tinfo = ValueSourceParser.parseTerm(fp);
                return new TotalTermFreqValueSource(tinfo.field, tinfo.val, tinfo.indexedField, tinfo.indexedBytes.get());
            }
        });
        ValueSourceParser.alias("totaltermfreq", "ttf");
        ValueSourceParser.addParser("sumtotaltermfreq", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                String field = fp.parseArg();
                return new SumTotalTermFreqValueSource(field);
            }
        });
        ValueSourceParser.alias("sumtotaltermfreq", "sttf");
        ValueSourceParser.addParser("idf", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                TInfo tinfo = ValueSourceParser.parseTerm(fp);
                return new IDFValueSource(tinfo.field, tinfo.val, tinfo.indexedField, tinfo.indexedBytes.get());
            }
        });
        ValueSourceParser.addParser("termfreq", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                TInfo tinfo = ValueSourceParser.parseTerm(fp);
                return new TermFreqValueSource(tinfo.field, tinfo.val, tinfo.indexedField, tinfo.indexedBytes.get());
            }
        });
        ValueSourceParser.addParser("tf", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                TInfo tinfo = ValueSourceParser.parseTerm(fp);
                return new TFValueSource(tinfo.field, tinfo.val, tinfo.indexedField, tinfo.indexedBytes.get());
            }
        });
        ValueSourceParser.addParser("norm", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                String field = fp.parseArg();
                return new NormValueSource(field);
            }
        });
        ValueSourceParser.addParser("maxdoc", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) {
                return new MaxDocValueSource();
            }
        });
        ValueSourceParser.addParser("numdocs", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) {
                return new NumDocsValueSource();
            }
        });
        ValueSourceParser.addParser("payload", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                TInfo tinfo = ValueSourceParser.parseTerm(fp);
                Object defaultValueSource = fp.hasMoreArguments() ? fp.parseValueSource() : new ConstValueSource(0.0f);
                PayloadFunction payloadFunction = null;
                String func = "average";
                if (fp.hasMoreArguments()) {
                    func = fp.parseArg();
                }
                if ((payloadFunction = PayloadUtils.getPayloadFunction(func)) == null && !"first".equals(func)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid payload function: " + func);
                }
                IndexSchema schema = fp.getReq().getCore().getLatestSchema();
                PayloadDecoder decoder = schema.getPayloadDecoder(tinfo.field);
                if (decoder == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No payload decoder found for field: " + tinfo.field);
                }
                return new FloatPayloadValueSource(tinfo.field, tinfo.val, tinfo.indexedField, tinfo.indexedBytes.get(), decoder, payloadFunction, (ValueSource)defaultValueSource);
            }
        });
        ValueSourceParser.addParser("true", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) {
                return BoolConstValueSource.TRUE;
            }
        });
        ValueSourceParser.addParser("false", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) {
                return BoolConstValueSource.FALSE;
            }
        });
        ValueSourceParser.addParser("exists", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource vs = fp.parseValueSource();
                return new SimpleBoolFunction(vs){

                    protected String name() {
                        return "exists";
                    }

                    protected boolean func(int doc, FunctionValues vals) throws IOException {
                        return vals.exists(doc);
                    }
                };
            }
        });
        ValueSourceParser.addParser("isnan", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource vs = fp.parseValueSource();
                return new SimpleBoolFunction(vs){

                    protected String name() {
                        return "isnan";
                    }

                    protected boolean func(int doc, FunctionValues vals) throws IOException {
                        return Float.isNaN(vals.floatVal(doc));
                    }
                };
            }
        });
        ValueSourceParser.addParser("not", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource vs = fp.parseValueSource();
                return new SimpleBoolFunction(vs){

                    protected boolean func(int doc, FunctionValues vals) throws IOException {
                        return !vals.boolVal(doc);
                    }

                    protected String name() {
                        return "not";
                    }
                };
            }
        });
        ValueSourceParser.addParser("and", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new MultiBoolFunction(sources){

                    protected String name() {
                        return "and";
                    }

                    protected boolean func(int doc, FunctionValues[] vals) throws IOException {
                        for (FunctionValues dv : vals) {
                            if (dv.boolVal(doc)) continue;
                            return false;
                        }
                        return true;
                    }
                };
            }
        });
        ValueSourceParser.addParser("or", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new MultiBoolFunction(sources){

                    protected String name() {
                        return "or";
                    }

                    protected boolean func(int doc, FunctionValues[] vals) throws IOException {
                        for (FunctionValues dv : vals) {
                            if (!dv.boolVal(doc)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        });
        ValueSourceParser.addParser("xor", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new MultiBoolFunction(sources){

                    protected String name() {
                        return "xor";
                    }

                    protected boolean func(int doc, FunctionValues[] vals) throws IOException {
                        int nTrue = 0;
                        int nFalse = 0;
                        for (FunctionValues dv : vals) {
                            if (dv.boolVal(doc)) {
                                ++nTrue;
                                continue;
                            }
                            ++nFalse;
                        }
                        return nTrue != 0 && nFalse != 0;
                    }
                };
            }
        });
        ValueSourceParser.addParser("if", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource ifValueSource = fp.parseValueSource();
                ValueSource trueValueSource = fp.parseValueSource();
                ValueSource falseValueSource = fp.parseValueSource();
                return new IfFunction(ifValueSource, trueValueSource, falseValueSource);
            }
        });
        ValueSourceParser.addParser("gt", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource lhsValSource = fp.parseValueSource();
                ValueSource rhsValSource = fp.parseValueSource();
                return new SolrComparisonBoolFunction(lhsValSource, rhsValSource, "gt", cmp -> cmp > 0);
            }
        });
        ValueSourceParser.addParser("lt", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource lhsValSource = fp.parseValueSource();
                ValueSource rhsValSource = fp.parseValueSource();
                return new SolrComparisonBoolFunction(lhsValSource, rhsValSource, "lt", cmp -> cmp < 0);
            }
        });
        ValueSourceParser.addParser("gte", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource lhsValSource = fp.parseValueSource();
                ValueSource rhsValSource = fp.parseValueSource();
                return new SolrComparisonBoolFunction(lhsValSource, rhsValSource, "gte", cmp -> cmp >= 0);
            }
        });
        ValueSourceParser.addParser("lte", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource lhsValSource = fp.parseValueSource();
                ValueSource rhsValSource = fp.parseValueSource();
                return new SolrComparisonBoolFunction(lhsValSource, rhsValSource, "lte", cmp -> cmp <= 0);
            }
        });
        ValueSourceParser.addParser("eq", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ValueSource lhsValSource = fp.parseValueSource();
                ValueSource rhsValSource = fp.parseValueSource();
                return new EqualFunction(lhsValSource, rhsValSource, "eq");
            }
        });
        ValueSourceParser.addParser("def", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new DefFunction(fp.parseValueSourceList());
            }
        });
        ValueSourceParser.addParser("concat", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new ConcatStringFunction(sources.toArray(new ValueSource[0]));
            }
        });
        ValueSourceParser.addParser("agg", new ValueSourceParser(){

            @Override
            public AggValueSource parse(FunctionQParser fp) throws SyntaxError {
                return fp.parseAgg(1);
            }
        });
        ValueSourceParser.addParser("agg_count", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new CountAgg();
            }
        });
        ValueSourceParser.addParser("agg_unique", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new UniqueAgg(fp.parseArg());
            }
        });
        ValueSourceParser.addParser("agg_uniqueBlock", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                if (fp.sp.peek() == "{!".charAt(0)) {
                    return new UniqueBlockQueryAgg(fp.parseNestedQuery());
                }
                return new UniqueBlockFieldAgg(fp.parseArg());
            }
        });
        ValueSourceParser.addParser("agg_hll", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new HLLAgg(fp.parseArg());
            }
        });
        ValueSourceParser.addParser("agg_sum", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new SumAgg(fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_avg", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new AvgAgg(fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_sumsq", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new SumsqAgg(fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_variance", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new VarianceAgg(fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_stddev", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new StddevAgg(fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_missing", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new MissingAgg(fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_countvals", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new CountValsAgg(fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_min", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new MinMaxAgg("min", fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_max", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                return new MinMaxAgg("max", fp.parseValueSource(5));
            }
        });
        ValueSourceParser.addParser("agg_percentile", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                ArrayList<Double> percentiles = new ArrayList<Double>();
                ValueSource vs = fp.parseValueSource(5);
                while (fp.hasMoreArguments()) {
                    double val = fp.parseDouble();
                    if (val < 0.0 || val > 100.0) {
                        throw new SyntaxError("requested percentile must be between 0 and 100.  got " + val);
                    }
                    percentiles.add(val);
                }
                if (percentiles.isEmpty()) {
                    throw new SyntaxError("expected percentile(valsource,percent1[,percent2]*)  EXAMPLE:percentile(myfield,50)");
                }
                return new PercentileAgg(vs, percentiles);
            }
        });
        ValueSourceParser.addParser("agg_relatedness", new ValueSourceParser(){

            @Override
            public ValueSource parse(FunctionQParser fp) throws SyntaxError {
                RelatednessAgg agg = new RelatednessAgg(fp.parseNestedQuery(), fp.parseNestedQuery());
                agg.setOpts(fp);
                return agg;
            }
        });
        ValueSourceParser.addParser("childfield", new ChildFieldValueSourceParser());
    }

    static class TestValueSource
    extends ValueSource {
        ValueSource source;

        public TestValueSource(ValueSource source) {
            this.source = source;
        }

        public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
            if (context.get((Object)this) == null) {
                SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "testfunc: unweighted value source detected.  delegate=" + this.source + " request=" + (requestInfo == null ? "null" : requestInfo.getReq()));
            }
            return this.source.getValues(context, readerContext);
        }

        public boolean equals(Object o) {
            return o instanceof TestValueSource && this.source.equals((Object)((TestValueSource)((Object)o)).source);
        }

        public int hashCode() {
            return this.source.hashCode() + TestValueSource.class.hashCode();
        }

        public String description() {
            return "testfunc(" + this.source.description() + ")";
        }

        public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
            context.put((Object)this, (Object)this);
        }

        public SortField getSortField(boolean reverse) {
            return super.getSortField(reverse);
        }
    }

    static class BoolConstValueSource
    extends ConstNumberSource {
        public static final BoolConstValueSource TRUE = new BoolConstValueSource(true);
        public static final BoolConstValueSource FALSE = new BoolConstValueSource(false);
        final boolean constant;

        private BoolConstValueSource(boolean constant) {
            this.constant = constant;
        }

        public String description() {
            return "const(" + this.constant + ")";
        }

        public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
            return new BoolDocValues((ValueSource)this){

                public boolean boolVal(int doc) {
                    return constant;
                }
            };
        }

        public int hashCode() {
            return this.constant ? 305419896 : -2023406815;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BoolConstValueSource)) {
                return false;
            }
            BoolConstValueSource other = (BoolConstValueSource)((Object)o);
            return this.constant == other.constant;
        }

        public int getInt() {
            return this.constant ? 1 : 0;
        }

        public long getLong() {
            return this.constant ? 1L : 0L;
        }

        public float getFloat() {
            return this.constant ? 1.0f : 0.0f;
        }

        public double getDouble() {
            return this.constant ? 1.0 : 0.0;
        }

        public Number getNumber() {
            return this.constant ? 1 : 0;
        }

        public boolean getBool() {
            return this.constant;
        }
    }

    static abstract class Double2Parser
    extends NamedParser {
        public Double2Parser(String name) {
            super(name);
        }

        public abstract double func(int var1, FunctionValues var2, FunctionValues var3) throws IOException;

        @Override
        public ValueSource parse(FunctionQParser fp) throws SyntaxError {
            return new Function(fp.parseValueSource(), fp.parseValueSource());
        }

        class Function
        extends ValueSource {
            private final ValueSource a;
            private final ValueSource b;

            public Function(ValueSource a, ValueSource b) {
                this.a = a;
                this.b = b;
            }

            public String description() {
                return Double2Parser.this.name() + "(" + this.a.description() + "," + this.b.description() + ")";
            }

            public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
                final FunctionValues aVals = this.a.getValues(context, readerContext);
                final FunctionValues bVals = this.b.getValues(context, readerContext);
                return new DoubleDocValues(this){

                    public double doubleVal(int doc) throws IOException {
                        return Double2Parser.this.func(doc, aVals, bVals);
                    }

                    public String toString(int doc) throws IOException {
                        return Double2Parser.this.name() + "(" + aVals.toString(doc) + "," + bVals.toString(doc) + ")";
                    }
                };
            }

            public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
            }

            public int hashCode() {
                int h = this.a.hashCode();
                h ^= h << 13 | h >>> 20;
                h += this.b.hashCode();
                h ^= h << 23 | h >>> 10;
                return h += Double2Parser.this.name().hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Function)) {
                    return false;
                }
                Function other = (Function)((Object)o);
                return this.a.equals((Object)other.a) && this.b.equals((Object)other.b);
            }
        }
    }

    static abstract class DoubleParser
    extends NamedParser {
        public DoubleParser(String name) {
            super(name);
        }

        public abstract double func(int var1, FunctionValues var2) throws IOException;

        @Override
        public ValueSource parse(FunctionQParser fp) throws SyntaxError {
            return new Function(fp.parseValueSource());
        }

        class Function
        extends SingleFunction {
            public Function(ValueSource source) {
                super(source);
            }

            public String name() {
                return DoubleParser.this.name();
            }

            public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
                final FunctionValues vals = this.source.getValues(context, readerContext);
                return new DoubleDocValues((ValueSource)this){

                    public double doubleVal(int doc) throws IOException {
                        return DoubleParser.this.func(doc, vals);
                    }

                    public String toString(int doc) throws IOException {
                        return Function.this.name() + "(" + vals.toString(doc) + ")";
                    }
                };
            }
        }
    }

    static abstract class NamedParser
    extends ValueSourceParser {
        private final String name;

        public NamedParser(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }

    static class LongConstValueSource
    extends ConstNumberSource {
        final long constant;
        final double dv;
        final float fv;

        public LongConstValueSource(long constant) {
            this.constant = constant;
            this.dv = constant;
            this.fv = constant;
        }

        public String description() {
            return "const(" + this.constant + ")";
        }

        public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
            return new LongDocValues((ValueSource)this){

                public float floatVal(int doc) {
                    return fv;
                }

                public int intVal(int doc) {
                    return (int)constant;
                }

                public long longVal(int doc) {
                    return constant;
                }

                public double doubleVal(int doc) {
                    return dv;
                }

                public String toString(int doc) {
                    return this.description();
                }
            };
        }

        public int hashCode() {
            return (int)this.constant + (int)(this.constant >>> 32);
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongConstValueSource)) {
                return false;
            }
            LongConstValueSource other = (LongConstValueSource)((Object)o);
            return this.constant == other.constant;
        }

        public int getInt() {
            return (int)this.constant;
        }

        public long getLong() {
            return this.constant;
        }

        public float getFloat() {
            return this.fv;
        }

        public double getDouble() {
            return this.dv;
        }

        public Number getNumber() {
            return this.constant;
        }

        public boolean getBool() {
            return this.constant != 0L;
        }
    }

    static class DateValueSourceParser
    extends ValueSourceParser {
        DateValueSourceParser() {
        }

        public Date getDate(FunctionQParser fp, String arg) {
            if (arg == null) {
                return null;
            }
            if (arg.startsWith("NOW") || arg.length() > 1 && Character.isDigit(arg.charAt(1))) {
                Date now = null;
                return DateMathParser.parseMath(now, arg);
            }
            return null;
        }

        public ValueSource getValueSource(FunctionQParser fp, String arg) {
            if (arg == null) {
                return null;
            }
            SchemaField f = fp.req.getSchema().getField(arg);
            return f.getType().getValueSource(f, fp);
        }

        @Override
        public ValueSource parse(FunctionQParser fp) throws SyntaxError {
            long ms2;
            Date d1;
            String first = fp.parseArg();
            String second = fp.parseArg();
            if (first == null) {
                first = "NOW";
            }
            ValueSource v1 = (d1 = this.getDate(fp, first)) == null ? this.getValueSource(fp, first) : null;
            Date d2 = this.getDate(fp, second);
            ValueSource v2 = d2 == null ? this.getValueSource(fp, second) : null;
            final long ms1 = d1 == null ? 0L : d1.getTime();
            long l = ms2 = d2 == null ? 0L : d2.getTime();
            if (d1 != null && v2 == null) {
                return new LongConstValueSource(ms1 - ms2);
            }
            if (v1 != null && v2 == null && d2 == null) {
                return v1;
            }
            if (d1 != null && v2 != null) {
                return new DualFloatFunction((ValueSource)new LongConstValueSource(ms1), v2){

                    protected String name() {
                        return "ms";
                    }

                    protected float func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
                        return ms1 - bVals.longVal(doc);
                    }
                };
            }
            if (v1 != null && d2 != null) {
                return new DualFloatFunction(v1, (ValueSource)new LongConstValueSource(ms2)){

                    protected String name() {
                        return "ms";
                    }

                    protected float func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
                        return aVals.longVal(doc) - ms2;
                    }
                };
            }
            if (v1 != null && v2 != null) {
                return new DualFloatFunction(v1, v2){

                    protected String name() {
                        return "ms";
                    }

                    protected float func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
                        return aVals.longVal(doc) - bVals.longVal(doc);
                    }
                };
            }
            return null;
        }
    }

    private static class TInfo {
        String field;
        String val;
        String indexedField;
        BytesRefBuilder indexedBytes;

        private TInfo() {
        }
    }

    private static class MVResult {
        MultiValueSource mv1;
        MultiValueSource mv2;

        private MVResult() {
        }
    }
}

