/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.routing.NoOpReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.ShardParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.component.CloudReplicaSource;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ReplicaSource;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.handler.component.StandaloneReplicaSource;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AllowListUrlChecker;

@NotThreadSafe
public class HttpShardHandler
extends ShardHandler {
    public static String ONLY_NRT_REPLICAS = "distribOnlyRealtime";
    private HttpShardHandlerFactory httpShardHandlerFactory;
    private Map<ShardResponse, Cancellable> responseCancellableMap;
    private BlockingQueue<ShardResponse> responses;
    private AtomicInteger pending;
    private Map<String, List<String>> shardToURLs;
    private LBHttp2SolrClient lbClient;

    public HttpShardHandler(HttpShardHandlerFactory httpShardHandlerFactory) {
        this.httpShardHandlerFactory = httpShardHandlerFactory;
        this.lbClient = httpShardHandlerFactory.loadbalancer;
        this.pending = new AtomicInteger(0);
        this.responses = new LinkedBlockingQueue<ShardResponse>();
        this.responseCancellableMap = new HashMap<ShardResponse, Cancellable>();
        this.shardToURLs = new HashMap<String, List<String>>();
    }

    private List<String> getURLs(String shard) {
        List<String> urls = this.shardToURLs.get(shard);
        if (urls == null) {
            urls = this.httpShardHandlerFactory.buildURLList(shard);
            this.shardToURLs.put(shard, urls);
        }
        return urls;
    }

    @Override
    public void submit(ShardRequest sreq, String shard, ModifiableSolrParams params) {
        List<String> urls = this.getURLs(shard);
        params.remove("wt");
        params.remove("version");
        final QueryRequest req = this.makeQueryRequest(sreq, params, shard);
        req.setMethod(SolrRequest.METHOD.POST);
        LBSolrClient.Req lbReq = this.httpShardHandlerFactory.newLBHttpSolrClientReq(req, urls);
        final ShardResponse srsp = new ShardResponse();
        if (sreq.nodeName != null) {
            srsp.setNodeName(sreq.nodeName);
        }
        srsp.setShardRequest(sreq);
        srsp.setShard(shard);
        final SimpleSolrResponse ssr = new SimpleSolrResponse();
        srsp.setSolrResponse(ssr);
        this.pending.incrementAndGet();
        if (urls.isEmpty()) {
            SolrException exception = new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no servers hosting shard: " + shard);
            srsp.setException(exception);
            srsp.setResponseCode(exception.code());
            this.responses.add(srsp);
            return;
        }
        this.responseCancellableMap.put(srsp, this.lbClient.asyncReq(lbReq, (AsyncListener)new AsyncListener<LBSolrClient.Rsp>(){
            volatile long startTime = System.nanoTime();

            public void onStart() {
                SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
                if (requestInfo != null) {
                    req.setUserPrincipal(requestInfo.getReq().getUserPrincipal());
                }
            }

            public void onSuccess(LBSolrClient.Rsp rsp) {
                ssr.nl = rsp.getResponse();
                srsp.setShardAddress(rsp.getServer());
                ssr.elapsedTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
                HttpShardHandler.this.responses.add(srsp);
            }

            public void onFailure(Throwable throwable) {
                ssr.elapsedTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
                srsp.setException(throwable);
                if (throwable instanceof SolrException) {
                    srsp.setResponseCode(((SolrException)throwable).code());
                }
                HttpShardHandler.this.responses.add(srsp);
            }
        }));
    }

    protected QueryRequest makeQueryRequest(ShardRequest sreq, ModifiableSolrParams params, String shard) {
        return new QueryRequest((SolrParams)params);
    }

    protected ShardResponse transfomResponse(ShardRequest sreq, ShardResponse rsp, String shard) {
        return rsp;
    }

    @Override
    public ShardResponse takeCompletedIncludingErrors() {
        return this.take(false);
    }

    @Override
    public ShardResponse takeCompletedOrError() {
        return this.take(true);
    }

    private ShardResponse take(boolean bailOnError) {
        try {
            while (this.pending.get() > 0) {
                ShardResponse rsp = this.responses.take();
                this.responseCancellableMap.remove(rsp);
                this.pending.decrementAndGet();
                if (bailOnError && rsp.getException() != null) {
                    return rsp;
                }
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getShardRequest().responses.size() != rsp.getShardRequest().actualShards.length) continue;
                return rsp;
            }
        }
        catch (InterruptedException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        return null;
    }

    @Override
    public void cancelAll() {
        for (Cancellable cancellable : this.responseCancellableMap.values()) {
            cancellable.cancel();
            this.pending.decrementAndGet();
        }
        this.responseCancellableMap.clear();
    }

    @Override
    public void prepDistributed(ResponseBuilder rb) {
        String shards_start;
        ReplicaSource replicaSource;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String shards = params.get("shards");
        CoreDescriptor coreDescriptor = req.getCore().getCoreDescriptor();
        CloudDescriptor cloudDescriptor = req.getCloudDescriptor();
        ZkController zkController = req.getCoreContainer().getZkController();
        ReplicaListTransformer replicaListTransformer = this.httpShardHandlerFactory.getReplicaListTransformer(req);
        AllowListUrlChecker urlChecker = req.getCoreContainer().getAllowListUrlChecker();
        if (shards != null && zkController == null && urlChecker.isEnabled() && !urlChecker.hasExplicitAllowList()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "solr.xml property 'allowUrls' not configured but required (in lieu of ZkController and ClusterState) when using the 'shards' parameter. Set -Dsolr.disable.allowUrls=true to disable URL allow-list checks.");
        }
        if (zkController != null) {
            boolean onlyNrt = Boolean.TRUE == req.getContext().get(ONLY_NRT_REPLICAS);
            replicaSource = new CloudReplicaSource.Builder().params(params).zkStateReader(zkController.getZkStateReader()).allowListUrlChecker(urlChecker).replicaListTransformer(replicaListTransformer).collection(cloudDescriptor.getCollectionName()).onlyNrt(onlyNrt).build();
            rb.slices = replicaSource.getSliceNames().toArray(new String[replicaSource.getSliceCount()]);
            if (this.canShortCircuit(rb.slices, onlyNrt, params, cloudDescriptor)) {
                rb.isDistrib = false;
                rb.shortCircuitedURL = ZkCoreNodeProps.getCoreUrl((String)zkController.getBaseUrl(), (String)coreDescriptor.getName());
                return;
            }
            if (!ShardParams.getShardsTolerantAsBool((SolrParams)params)) {
                for (int i = 0; i < rb.slices.length; ++i) {
                    if (!replicaSource.getReplicasBySlice(i).isEmpty()) continue;
                    CloudReplicaSource allActiveReplicaSource = new CloudReplicaSource.Builder().params(params).zkStateReader(zkController.getZkStateReader()).allowListUrlChecker(AllowListUrlChecker.ALLOW_ALL).replicaListTransformer(NoOpReplicaListTransformer.INSTANCE).collection(cloudDescriptor.getCollectionName()).onlyNrt(false).build();
                    String adjective = allActiveReplicaSource.getReplicasBySlice(i).isEmpty() ? "active" : "eligible";
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no " + adjective + " servers hosting shard: " + rb.slices[i]);
                }
            }
        } else {
            replicaSource = new StandaloneReplicaSource.Builder().allowListUrlChecker(urlChecker).shards(shards).build();
            rb.slices = new String[replicaSource.getSliceCount()];
        }
        rb.shards = new String[rb.slices.length];
        for (int i = 0; i < rb.slices.length; ++i) {
            rb.shards[i] = HttpShardHandler.createSliceShardsStr(replicaSource.getReplicasBySlice(i));
        }
        String shards_rows = params.get("shards.rows");
        if (shards_rows != null) {
            rb.shards_rows = Integer.parseInt(shards_rows);
        }
        if ((shards_start = params.get("shards.start")) != null) {
            rb.shards_start = Integer.parseInt(shards_start);
        }
    }

    private static String createSliceShardsStr(List<String> shardUrls) {
        return String.join((CharSequence)"|", shardUrls);
    }

    private boolean canShortCircuit(String[] slices, boolean onlyNrtReplicas, SolrParams params, CloudDescriptor cloudDescriptor) {
        String ourSlice = cloudDescriptor.getShardId();
        String ourCollection = cloudDescriptor.getCollectionName();
        if (!(slices.length != 1 || slices[0] == null || !slices[0].equals(ourSlice) && !slices[0].equals(ourCollection + "_" + ourSlice) || cloudDescriptor.getLastPublished() != Replica.State.ACTIVE || onlyNrtReplicas && cloudDescriptor.getReplicaType() != Replica.Type.NRT)) {
            boolean shortCircuit = params.getBool("shortCircuit", true);
            String targetHandler = params.get("shards.qt");
            shortCircuit = shortCircuit && targetHandler == null;
            return shortCircuit;
        }
        return false;
    }

    @Override
    public ShardHandlerFactory getShardHandlerFactory() {
        return this.httpShardHandlerFactory;
    }

    private static class SimpleSolrResponse
    extends SolrResponse {
        volatile long elapsedTime;
        volatile NamedList<Object> nl;

        private SimpleSolrResponse() {
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public NamedList<Object> getResponse() {
            return this.nl;
        }

        public void setResponse(NamedList<Object> rsp) {
            this.nl = rsp;
        }

        public void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }
    }
}

