/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.solr.client.api.endpoint.ListCollectionsApi;
import org.apache.solr.client.api.model.ListCollectionsResponse;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class ListCollections
extends AdminAPIBase
implements ListCollectionsApi {
    @Inject
    public ListCollections(CoreContainer coreContainer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(coreContainer, req, rsp);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public ListCollectionsResponse listCollections() {
        ListCollectionsResponse response = this.instantiateJerseyResponse(ListCollectionsResponse.class);
        ListCollections.validateZooKeeperAwareCoreContainer(this.coreContainer);
        Map collections = this.coreContainer.getZkController().getZkStateReader().getClusterState().getCollectionsMap();
        ArrayList collectionList = new ArrayList(collections.keySet());
        Collections.sort(collectionList);
        response.collections = collectionList;
        return response;
    }
}

