/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.DeleteCollectionSnapshotApi;
import org.apache.solr.client.api.model.DeleteCollectionSnapshotResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteCollectionSnapshot
extends AdminAPIBase
implements DeleteCollectionSnapshotApi {
    @Inject
    public DeleteCollectionSnapshot(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public DeleteCollectionSnapshotResponse deleteCollectionSnapshot(String collName, String snapshotName, boolean followAliases, String asyncId) throws Exception {
        DeleteCollectionSnapshotResponse response = this.instantiateJerseyResponse(DeleteCollectionSnapshotResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteCollectionSnapshot.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        String collectionName = this.resolveCollectionName(collName, followAliases);
        ZkNodeProps remoteMessage = DeleteCollectionSnapshot.createRemoteMessage(collectionName, followAliases, snapshotName, asyncId);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.DELETESNAPSHOT, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        response.collection = collName;
        response.snapshotName = snapshotName;
        response.followAliases = followAliases;
        response.requestId = asyncId;
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, boolean followAliases, String snapshotName, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETESNAPSHOT.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("commitName", snapshotName);
        remoteMessage.put("followAliases", followAliases);
        if (asyncId != null) {
            remoteMessage.put("async", asyncId);
        }
        return new ZkNodeProps(remoteMessage);
    }
}

