/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SimplePostTool;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;

public class PostTool
extends ToolBase {
    public PostTool() {
        this(CLIO.getOutStream());
    }

    public PostTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "post";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"url").argName("url").hasArg().required(false).desc("<base Solr update URL>").build(), Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(false).desc("Name of the collection.").build(), Option.builder((String)"commit").required(false).desc("Issue a commit at end of post").build(), Option.builder((String)"optimize").required(false).desc("Issue an optimize at end of post").build(), Option.builder((String)"mode").argName("mode").hasArg(true).required(false).desc("Files crawls files, web crawls website. default: files.").build(), Option.builder((String)"recursive").argName("recursive").hasArg(true).required(false).desc("For web crawl, how deep to go. default: 1").build(), Option.builder((String)"delay").argName("delay").hasArg(true).required(false).desc("If recursive then delay will be the wait time between posts.  default: 10 for web, 0 for files").build(), Option.builder((String)"type").argName("content-type").hasArg(true).required(false).desc("default: application/json").build(), Option.builder((String)"filetypes").argName("<type>[,<type>,...]").hasArg(true).required(false).desc("default: xml,json,jsonl,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log").build(), Option.builder((String)"params").argName("<key>=<value>[&<key>=<value>...]").hasArg(true).required(false).desc("values must be URL-encoded; these pass through to Solr update request").build(), Option.builder((String)"out").required(false).desc("sends Solr response outputs to console").build(), Option.builder((String)"format").required(false).desc("sends application/json content as Solr commands to /update instead of /update/json/docs").build());
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        Object url;
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        URL solrUrl = null;
        if (cli.hasOption("url")) {
            url = cli.getOptionValue("url");
            solrUrl = new URL((String)url);
        } else if (cli.hasOption("c")) {
            url = SolrCLI.getDefaultSolrUrl() + "/solr/" + cli.getOptionValue("c") + "/update";
            solrUrl = new URL((String)url);
        } else {
            throw new IllegalArgumentException("Must specify either -url or -c parameter to post documents.");
        }
        String mode = "files";
        if (cli.hasOption("mode")) {
            mode = cli.getOptionValue("mode");
        }
        boolean auto = true;
        String type = null;
        if (cli.hasOption("type")) {
            type = cli.getOptionValue("type");
        }
        String format = cli.hasOption("format") ? "solr" : "";
        String fileTypes = "xml,json,jsonl,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log";
        if (cli.hasOption("filetypes")) {
            fileTypes = cli.getOptionValue("filetypes");
        }
        int defaultDelay = mode.equals("web") ? 10 : 0;
        int delay = Integer.parseInt(cli.getOptionValue("delay", String.valueOf(defaultDelay)));
        int recursive = Integer.parseInt(cli.getOptionValue("recursive", "1"));
        PrintStream out = cli.hasOption("out") ? CLIO.getOutStream() : null;
        boolean commit = cli.hasOption("commit");
        boolean optimize = cli.hasOption("optimize");
        String[] args = cli.getArgs();
        SimplePostTool spt = new SimplePostTool(mode, solrUrl, auto, type, format, recursive, delay, fileTypes, out, commit, optimize, args);
        spt.execute();
    }
}

